/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.container;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import weblogic.wsee.jws.container.ContainerDispatcherImpl;
import weblogic.wsee.jws.container.Request;
import weblogic.wsee.jws.container.Response;
import weblogic.wsee.message.WlMessageContext;

public abstract class ContainerDispatcher {
    public static final String JWSCONTAINER_PROPERTY = "weblogic.wsee.jws.containerDispatcher";
    private static final String DEFAULT_JWSCONTAINER = ContainerDispatcherImpl.class.getName();
    private static ContainerDispatcher instance = ContainerDispatcher.load();

    public static ContainerDispatcher getInstance() {
        return instance;
    }

    private static ContainerDispatcher newInstance(String string, ClassLoader classLoader) throws Exception {
        Class<?> clazz = classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
        return (ContainerDispatcher)clazz.newInstance();
    }

    private static ContainerDispatcher load() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String string = System.getProperty(JWSCONTAINER_PROPERTY);
            if (string != null) {
                return ContainerDispatcher.newInstance(string, classLoader);
            }
            String string2 = "META-INF/services/" + JWSCONTAINER_PROPERTY;
            InputStream inputStream = null;
            inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string2) : classLoader.getResourceAsStream(string2);
            if (inputStream != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                String string3 = bufferedReader.readLine();
                bufferedReader.close();
                if (string3 != null && !"".equals(string3)) {
                    return ContainerDispatcher.newInstance(string3, classLoader);
                }
            }
            return ContainerDispatcher.newInstance(DEFAULT_JWSCONTAINER, classLoader);
        }
        catch (Exception exception) {
            throw new InstantiationError(exception.getMessage());
        }
    }

    public abstract Response dispatch(WlMessageContext var1, Request var2) throws Exception;
}

