/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.container;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import weblogic.wsee.component.ComponentException;
import weblogic.wsee.component.pojo.JavaClassComponent;
import weblogic.wsee.jws.container.ContainerFactory;
import weblogic.wsee.jws.container.ContainerMarker;
import weblogic.wsee.jws.container.InvokeException;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.ws.WsSkel;

public class ContainerHandler
extends GenericHandler {
    static final String HANDLER_NAME = "CONTAINER_HANDLER";

    public boolean handleRequest(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        JavaClassComponent javaClassComponent = (JavaClassComponent)((WsSkel)wlMessageContext.getDispatcher().getWsPort().getEndpoint()).getComponent();
        ContainerMarker containerMarker = this.getContainer(wlMessageContext, javaClassComponent);
        containerMarker.setMessageContext(wlMessageContext);
        return true;
    }

    private ContainerMarker getContainer(WlMessageContext wlMessageContext, JavaClassComponent javaClassComponent) {
        ContainerMarker containerMarker = ContainerFactory.getContainer(wlMessageContext);
        if (containerMarker == null) {
            try {
                containerMarker = ContainerFactory.createContainer(wlMessageContext, javaClassComponent.createTarget(), true);
            }
            catch (ComponentException componentException) {
                throw new InvokeException(componentException.getMessage(), componentException);
            }
        } else {
            containerMarker.setMessageContext(wlMessageContext);
        }
        return containerMarker;
    }

    public boolean handleResponse(MessageContext messageContext) {
        ContainerMarker containerMarker = (ContainerMarker)messageContext.getProperty("weblogic.wsee.jws.container");
        if (containerMarker != null && messageContext.getProperty("weblogic.wsee.conversation.ConversationId") == null) {
            containerMarker.destroy();
        }
        return true;
    }

    public QName[] getHeaders() {
        return new QName[0];
    }
}

