/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.container;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.jws.container.Container;
import weblogic.wsee.jws.container.ContainerListenerHandler;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

public class ContainerListenerDeploymentListener
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(ContainerListenerDeploymentListener.class);

    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        if (verbose) {
            Verbose.log("ContainerListenerDeploymentListener firing");
        }
        Iterator<WsPort> iterator = wsDeploymentContext.getWsService().getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            if (!Container.isContainerRequired(wsPort)) continue;
            if (verbose) {
                Verbose.log("Adding " + this.getClass().getName() + " for " + wsDeploymentContext.getServiceURIs()[0]);
            }
            try {
                HandlerInfo handlerInfo = new HandlerInfo(ContainerListenerHandler.class, new HashMap(), null);
                List<String> list = Collections.emptyList();
                wsPort.getInternalHandlerList().insert("CONTAINER_LISTENER_HANDLER", handlerInfo, Arrays.asList("CONTAINER_HANDLER"), list);
            }
            catch (HandlerException handlerException) {
                throw new WsDeploymentException("Unable to register handler", handlerException);
            }
        }
    }
}

