/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.container;

import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import weblogic.wsee.handler.WLHandler;
import weblogic.wsee.jws.container.Container;
import weblogic.wsee.jws.container.ContainerFactory;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.ws.WsMethodImpl;

public class ContainerListenerHandler
extends GenericHandler
implements WLHandler {
    public static final String HANDLER_NAME = "CONTAINER_LISTENER_HANDLER";

    public boolean handleRequest(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        try {
            Container container = ContainerListenerHandler.getContainer(messageContext);
            container.getListeners().preInvoke(wlMessageContext);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new JAXRPCException((Throwable)exception);
        }
        return true;
    }

    private static Container getContainer(MessageContext messageContext) {
        Container container = ContainerFactory.getContainer(messageContext);
        if (container == null) {
            throw new IllegalStateException("Container not found in message context");
        }
        return container;
    }

    public boolean handleResponse(MessageContext messageContext) {
        try {
            this.notifyListeners(messageContext);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new JAXRPCException((Throwable)exception);
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext) {
        return this.handleResponse(messageContext);
    }

    public boolean handleClosure(MessageContext messageContext) {
        return this.handleResponse(messageContext);
    }

    public QName[] getHeaders() {
        return new QName[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(MessageContext messageContext) throws Exception {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        Container container = ContainerListenerHandler.getContainer(wlMessageContext);
        try {
            Exception exception = (Exception)wlMessageContext.getProperty("weblogic.wsee.component.AppException");
            if (exception != null) {
                WsMethodImpl wsMethodImpl = (WsMethodImpl)wlMessageContext.getDispatcher().getWsMethod();
                container.getListeners().onException(exception, wsMethodImpl.getMethodName(), wsMethodImpl.getMethodArgs(wlMessageContext.getDispatcher().getInParams()));
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            container.getListeners().postInvoke();
            throw throwable;
        }
        container.getListeners().postInvoke();
    }
}

