/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.container;

import java.lang.reflect.Method;
import weblogic.wsee.jws.container.ContainerListener;
import weblogic.wsee.jws.container.InvokeException;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.util.Verbose;

class ContextEventListener
implements ContainerListener {
    private static final long serialVersionUID = 2088692834536863957L;
    private static final boolean verbose = Verbose.isVerbose(ContextEventListener.class);
    private String contextFieldName = null;
    private Object targetJWS = null;

    ContextEventListener(String string, Object object) {
        this.contextFieldName = string;
        this.targetJWS = object;
    }

    public void onCreate() {
        this.executeMethod("onCreate", new Class[0], new Object[0], false);
    }

    public void onFinish(boolean bl) {
        this.executeMethod("onFinish", new Class[]{Boolean.TYPE}, new Object[]{bl}, true);
    }

    public void onException(Exception exception, String string, Object[] objectArray) {
        this.executeMethod("onException", new Class[]{Exception.class, String.class, Object[].class}, new Object[]{exception, string, objectArray}, false);
    }

    public void preInvoke(WlMessageContext wlMessageContext) throws Exception {
    }

    public void postInvoke() throws Exception {
    }

    public void onAgeTimeout(long l) throws Exception {
        this.executeMethod("onAgeTimeout", new Class[]{Long.TYPE}, new Object[]{l}, false);
    }

    public void onIdleTimeout(long l) throws Exception {
        this.executeMethod("onIdleTimeout", new Class[]{Long.TYPE}, new Object[]{l}, false);
    }

    public void onAsyncFailure(String string, Object[] objectArray) throws Exception {
        this.executeMethod("onAsyncFailure", new Class[]{String.class, Object[].class}, new Object[]{string, objectArray}, false);
    }

    private void executeMethod(String string, Class[] classArray, Object[] objectArray, boolean bl) throws InvokeException {
        block5: {
            String string2 = this.contextFieldName + "_" + string;
            try {
                Method method = this.targetJWS.getClass().getMethod(string2, classArray);
                method.invoke(this.targetJWS, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (verbose) {
                    string2 = " not found on " + this.targetJWS.getClass().getName();
                    Verbose.log(string2);
                }
            }
            catch (Exception exception) {
                if (bl) {
                    throw new InvokeException("Unable to Fire " + string + " event", exception);
                }
                if (!verbose) break block5;
                Verbose.log((Object)("Exception executing " + string2 + this.targetJWS.getClass().getName()), exception);
            }
        }
    }
}

