/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.container;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.conversation.ConversationUtils;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.jws.container.ConversationLifeCycleHandler;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

public class ConversationLifeCycleDeploymentListener
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(ConversationLifeCycleDeploymentListener.class);

    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        if (verbose) {
            Verbose.log("ConversationLifeCycleDeploymentListener firing");
        }
        Iterator<WsPort> iterator = wsDeploymentContext.getWsService().getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            if (!ConversationUtils.isConversational(wsPort)) continue;
            if (verbose) {
                Verbose.log("Adding " + this.getClass().getName() + " for " + wsDeploymentContext.getServiceURIs()[0]);
            }
            try {
                HandlerInfo handlerInfo = new HandlerInfo(ConversationLifeCycleHandler.class, new HashMap(), null);
                wsPort.getInternalHandlerList().insert("CONVERSATION_LIFE_CYCLE_HANDLER", handlerInfo, Arrays.asList("CONTAINER_HANDLER"), Arrays.asList("CONTAINER_LISTENER_HANDLER"));
            }
            catch (HandlerException handlerException) {
                throw new WsDeploymentException("Unable to register handler", handlerException);
            }
        }
    }
}

