/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.container;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import weblogic.wsee.conversation.ConversationPhase;
import weblogic.wsee.handler.WLHandler;
import weblogic.wsee.jws.container.Container;
import weblogic.wsee.jws.container.ContainerEvent;
import weblogic.wsee.jws.container.ContainerFactory;
import weblogic.wsee.jws.container.ConversationTimeoutListener;
import weblogic.wsee.jws.container.ConversationalContainer;
import weblogic.wsee.jws.container.InvokeException;
import weblogic.wsee.jws.conversation.ConversationTimeout;
import weblogic.wsee.jws.conversation.Store;
import weblogic.wsee.jws.conversation.StoreConfig;
import weblogic.wsee.jws.conversation.StoreException;
import weblogic.wsee.jws.conversation.StoreManager;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.util.Guid;

public class ConversationLifeCycleHandler
extends GenericHandler
implements WLHandler {
    public static final String HANDLER_NAME = "CONVERSATION_LIFE_CYCLE_HANDLER";

    public boolean handleRequest(MessageContext messageContext) {
        ConversationalContainer conversationalContainer = ConversationLifeCycleHandler.getConversationalContainer(messageContext);
        if (conversationalContainer != null) {
            conversationalContainer.resetIdleTime();
            if (conversationalContainer.getStartUser() == null) {
                conversationalContainer.setStartUser(ConversationLifeCycleHandler.getCallerName(conversationalContainer));
            }
            if (conversationalContainer.isSinglePrincipal() && !ConversationLifeCycleHandler.getCallerName(conversationalContainer).equals(conversationalContainer.getStartUser())) {
                throw new IllegalStateException("Service may only be called by the user who started the conversation.\nstarted = " + conversationalContainer.getStartUser() + " caller = " + ConversationLifeCycleHandler.getCallerName(conversationalContainer));
            }
        }
        return true;
    }

    private static ConversationalContainer getConversationalContainer(MessageContext messageContext) {
        Container container = ConversationLifeCycleHandler.getContainer(messageContext);
        if (container instanceof ConversationalContainer) {
            return (ConversationalContainer)container;
        }
        return null;
    }

    private static Container getContainer(MessageContext messageContext) {
        Container container = ContainerFactory.getContainer(messageContext);
        if (container == null) {
            throw new IllegalStateException("Container not found in message context");
        }
        return container;
    }

    public boolean handleResponse(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        ConversationalContainer conversationalContainer = ConversationLifeCycleHandler.getConversationalContainer(wlMessageContext);
        if (conversationalContainer != null) {
            ConversationPhase conversationPhase = (ConversationPhase)wlMessageContext.getProperty("weblogic.wsee.conversation.ConversationPhase");
            if (conversationPhase == null) {
                conversationPhase = ConversationPhase.CONTINUE;
            }
            try {
                if (conversationPhase.equals(ConversationPhase.FINISH) || conversationalContainer.isFinished()) {
                    conversationalContainer.finish();
                    conversationalContainer.destroy();
                }
                if (!conversationPhase.equals(ConversationPhase.FINISH) && !conversationalContainer.isFinished()) {
                    ConversationLifeCycleHandler.preSchedule(conversationalContainer, wlMessageContext);
                }
                ConversationLifeCycleHandler.updateStore(ConversationLifeCycleHandler.getStoreConfig(wlMessageContext), conversationalContainer, conversationPhase);
                if (!conversationPhase.equals(ConversationPhase.FINISH) && !conversationalContainer.isFinished()) {
                    ConversationLifeCycleHandler.schedule(conversationalContainer);
                }
            }
            catch (Exception exception) {
                throw new InvokeException("Error updating conversational state: " + exception.toString(), exception);
            }
        }
        return true;
    }

    private static void preSchedule(ConversationalContainer conversationalContainer, WlMessageContext wlMessageContext) {
        Object object;
        ArrayList<ConversationTimeoutListener> arrayList = new ArrayList<ConversationTimeoutListener>();
        if (conversationalContainer.getMaxAgeTime() > 0L) {
            ConversationTimeout conversationTimeout = new ConversationTimeout(ContainerEvent.TYPE.EVENT_AGE_TIMEOUT, conversationalContainer.getURI(), conversationalContainer.getId(), ConversationLifeCycleHandler.getStoreConfig(wlMessageContext), conversationalContainer.getMaxAgeTime());
            String string = Guid.generateGuid();
            object = new ConversationTimeoutListener(string, conversationTimeout);
            arrayList.add((ConversationTimeoutListener)object);
        }
        if (conversationalContainer.getMaxIdleSeconds() > 0L) {
            long l = conversationalContainer.getLastReqTime() + conversationalContainer.getMaxIdleSeconds() * 1000L;
            object = new ConversationTimeout(ContainerEvent.TYPE.EVENT_IDLE_TIMEOUT, conversationalContainer.getURI(), conversationalContainer.getId(), ConversationLifeCycleHandler.getStoreConfig(wlMessageContext), l);
            String string = Guid.generateGuid();
            ConversationTimeoutListener conversationTimeoutListener = new ConversationTimeoutListener(string, (ConversationTimeout)object);
            arrayList.add(conversationTimeoutListener);
        }
        if (arrayList.size() > 0) {
            conversationalContainer.setTimeoutListeners(arrayList);
        }
    }

    private static void schedule(ConversationalContainer conversationalContainer) {
        if (conversationalContainer.getTimeoutListeners() != null) {
            for (ConversationTimeoutListener conversationTimeoutListener : conversationalContainer.getTimeoutListeners()) {
                conversationTimeoutListener.schedule();
            }
        }
    }

    public boolean handleClosure(MessageContext messageContext) {
        return this.handleResponse(messageContext);
    }

    private static String getCallerName(ConversationalContainer conversationalContainer) {
        if (conversationalContainer.getCallerPrincipal() == null) {
            return "null";
        }
        return conversationalContainer.getCallerPrincipal().getName();
    }

    private static StoreConfig getStoreConfig(MessageContext messageContext) {
        return (StoreConfig)messageContext.getProperty("weblogic.wsee.conversation.StoreConfig");
    }

    private static void updateStore(StoreConfig storeConfig, ConversationalContainer conversationalContainer, ConversationPhase conversationPhase) throws StoreException {
        Store store = StoreManager.getStore(storeConfig);
        if (conversationPhase.equals(ConversationPhase.START)) {
            if (!conversationalContainer.isFinished()) {
                store.insert(conversationalContainer);
            }
        } else if (conversationPhase.equals(ConversationPhase.FINISH) || conversationalContainer.isFinished()) {
            store.delete(conversationalContainer.getId());
        } else {
            store.update(conversationalContainer);
        }
    }

    public QName[] getHeaders() {
        return new QName[0];
    }
}

