/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.container;

import java.util.Date;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManagerFactory;
import weblogic.wsee.conversation.LockManager;
import weblogic.wsee.jws.container.ConversationalContainer;
import weblogic.wsee.jws.conversation.ConversationTimeout;
import weblogic.wsee.jws.conversation.Store;
import weblogic.wsee.jws.conversation.StoreManager;
import weblogic.wsee.util.PathServiceUtil;
import weblogic.wsee.util.Verbose;

class ConversationTimeoutListener
implements TimerListener {
    private static final boolean verbose = Verbose.isVerbose(ConversationTimeoutListener.class);
    private static final String TIMER_MANAGER_NAME = "weblogic.wsee.ConversationTimeoutManager";
    private ConversationTimeout to;
    private String id;
    private boolean cancelled;
    private Timer timer;

    ConversationTimeoutListener(String string, ConversationTimeout conversationTimeout) {
        this.id = string;
        this.to = conversationTimeout;
        if (verbose) {
            Verbose.say("Created ConversationTimeoutListener " + string + " of type " + (Object)((Object)conversationTimeout.getEventType()) + " for conversation: " + conversationTimeout.getConversationID());
        }
    }

    synchronized void schedule() {
        TimerManager timerManager = TimerManagerFactory.getTimerManagerFactory().getTimerManager(TIMER_MANAGER_NAME, WorkManagerFactory.getInstance().getSystem());
        this.timer = timerManager.schedule((TimerListener)this, new Date(this.to.getTime()));
        if (verbose) {
            Verbose.say("Scheduled timer for ConversationTimeoutListener " + this.id);
        }
    }

    synchronized void cancel() {
        this.cancelled = true;
        this.to = null;
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (verbose) {
            Verbose.say("Cancelled ConversationTimeoutListener " + this.id);
        }
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(Timer timer) {
        Object object = this;
        synchronized (object) {
            if (this.cancelled) {
                return;
            }
        }
        if (verbose) {
            Verbose.log("JWS timeout for ConversationTimeoutListener: " + this.id);
        }
        ConversationalContainer.removeSerializedTimeoutListener(this.id);
        object = null;
        try {
            block11: {
                try {
                    object = LockManager.getInstance().lock(this.to.getConversationID());
                    Store store = StoreManager.getStore(this.to.getStoreConfig());
                    ConversationalContainer conversationalContainer = (ConversationalContainer)store.readForUpdate(this.to.getConversationID());
                    if (conversationalContainer == null) break block11;
                    this.notify(conversationalContainer);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Exception in timeout", exception);
                }
            }
            Object var6_7 = null;
            if (object != null) {
                ((LockManager.Lock)object).release();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (object != null) {
                ((LockManager.Lock)object).release();
            }
            throw throwable;
        }
    }

    private void notify(ConversationalContainer conversationalContainer) throws Exception {
        if (verbose) {
            Verbose.log("timeout notified - " + this.to.getConversationID());
            Verbose.log(this.to);
            Verbose.log("_maxAgeTime     = " + conversationalContainer.getMaxAgeTime());
            Verbose.log("_maxIdleSeconds = " + conversationalContainer.getMaxIdleSeconds());
            Verbose.log("_lastReqTime    = " + conversationalContainer.getLastReqTime());
        }
        switch (this.to.getEventType()) {
            case EVENT_AGE_TIMEOUT: {
                this.handleAgeTimeout(conversationalContainer);
                break;
            }
            case EVENT_IDLE_TIMEOUT: {
                this.handleIdleTimeout(conversationalContainer);
                break;
            }
            default: {
                System.out.println("Unhandled event: " + this.to);
            }
        }
    }

    private void handleIdleTimeout(ConversationalContainer conversationalContainer) throws Exception {
        if (conversationalContainer.getMaxIdleSeconds() > 0L && this.to.getTime() - conversationalContainer.getLastReqTime() >= conversationalContainer.getMaxIdleSeconds() * 1000L) {
            conversationalContainer.setState(1);
            conversationalContainer.getListeners().onIdleTimeout(this.to.getTime());
            conversationalContainer.finish();
            this.updateStore(conversationalContainer);
        }
    }

    private void handleAgeTimeout(ConversationalContainer conversationalContainer) throws Exception {
        if (conversationalContainer.getMaxAgeTime() > 0L && this.to.getTime() >= conversationalContainer.getMaxAgeTime()) {
            conversationalContainer.setState(2);
            conversationalContainer.getListeners().onAgeTimeout(this.to.getTime() - conversationalContainer.getStartTime());
            conversationalContainer.finish();
            this.updateStore(conversationalContainer);
        }
    }

    private void updateStore(ConversationalContainer conversationalContainer) throws Exception {
        Store store = StoreManager.getStore(this.to.getStoreConfig());
        store.delete(conversationalContainer.getId());
        try {
            PathServiceUtil.removeConversationIdMapping(conversationalContainer.getId());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

