/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.container;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.jws.Conversational;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.wsee.Version;
import weblogic.wsee.deploy.VersioningHelper;
import weblogic.wsee.jws.ServiceHandle;
import weblogic.wsee.jws.ServiceHandleImpl;
import weblogic.wsee.jws.container.Container;
import weblogic.wsee.jws.container.ConversationTimeoutListener;
import weblogic.wsee.jws.container.Duration;
import weblogic.wsee.jws.conversation.ConversationState;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.util.ServerSecurityHelper;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConversationalContainer
extends Container
implements ConversationState,
Serializable {
    private static final long serialVersionUID = 342753828856966520L;
    private static final boolean verbose = Verbose.isVerbose(ConversationalContainer.class);
    static final int STATE_ACTIVE = 0;
    static final int STATE_IDLE_TIMEOUT = 1;
    static final int STATE_AGE_TIMEOUT = 2;
    static final int STATE_FINISH_PENDING = 3;
    static final int STATE_FINISHED = 4;
    private static final List<Integer> TIMEOUT_STATES = Arrays.asList(2, 1);
    private long _lastReqTime = System.currentTimeMillis();
    private String _conversationId = null;
    private long _startTime = 0L;
    private long _maxIdleSeconds = 0L;
    private long _maxAgeTime = 0L;
    private int _state = 0;
    private String _startUser = null;
    private AuthenticatedSubject altSubject = null;
    private boolean _singlePrincipal = false;
    private String appName;
    private String version;
    private transient List<ConversationTimeoutListener> _timeoutListeners;
    private static final String MAX_AGE_DEFAULT = "1 day";
    private static ConcurrentHashMap<String, ConversationTimeoutListener> _serializedTimeoutListeners = new ConcurrentHashMap();

    protected ConversationalContainer(Object object, WlMessageContext wlMessageContext, String string) {
        super(object, wlMessageContext);
        this.init(string);
        this.appName = ApplicationVersionUtils.getApplicationName(ApplicationVersionUtils.getCurrentApplicationId());
        this.version = ApplicationVersionUtils.getCurrentVersionId();
        if (verbose) {
            Verbose.say("Constructed ConversationalContainer: " + string);
        }
    }

    private void init(String string) {
        this._conversationId = string;
        assert (!StringUtil.isEmpty(this._conversationId));
        this._startTime = System.currentTimeMillis();
        Conversational conversational = this.getTargetJWS().getClass().getAnnotation(Conversational.class);
        if (conversational != null) {
            this.setMaxIdleTime(conversational.maxIdleTime());
            this._singlePrincipal = conversational.singlePrincipal();
            if (conversational.runAsStartUser()) {
                this.altSubject = ServerSecurityHelper.getCurrentSubject();
            }
            this.setMaxAge(conversational.maxAge());
        } else {
            this.setMaxAge(MAX_AGE_DEFAULT);
        }
    }

    @Override
    public AuthenticatedSubject getAltAuthenticatedSubject() {
        return this.altSubject;
    }

    @Override
    public ServiceHandle getService() {
        return new ServiceHandleImpl(this.getEndpointAddress(), this.getContextPath(), this.getURI(), this._conversationId);
    }

    void finish() throws Exception {
        if (verbose) {
            Verbose.say("Finishing conversation: " + this.getId());
        }
        boolean bl = TIMEOUT_STATES.contains(this._state);
        this.finishConversation();
        this.getListeners().onFinish(bl);
        VersioningHelper.updateCount(this.appName, this.version, -1);
        this._state = 4;
        if (this._timeoutListeners != null) {
            for (ConversationTimeoutListener conversationTimeoutListener : this._timeoutListeners) {
                conversationTimeoutListener.cancel();
            }
            this._timeoutListeners.clear();
            this._timeoutListeners = null;
        }
    }

    @Override
    public void resetIdleTime() throws IllegalStateException {
        this._lastReqTime = System.currentTimeMillis();
    }

    @Override
    public boolean isFinished() {
        return this._state != 0;
    }

    @Override
    public void finishConversation() {
        this._state = 3;
    }

    @Override
    public void setMaxAge(Date date) throws IllegalStateException, IllegalArgumentException {
        this._maxAgeTime = date == null ? 0L : date.getTime();
    }

    @Override
    public void setMaxAge(String string) throws IllegalStateException, IllegalArgumentException {
        Duration duration = new Duration(string);
        this._maxAgeTime = duration.computeDate(this._startTime);
    }

    @Override
    public long getMaxAge() throws IllegalStateException {
        if (this._maxAgeTime > 0L) {
            return (this._maxAgeTime - this._startTime) / 1000L;
        }
        return 0L;
    }

    @Override
    public long getCurrentAge() throws IllegalStateException {
        return (System.currentTimeMillis() - this._startTime) / 1000L;
    }

    @Override
    public long getCurrentIdleTime() throws IllegalStateException {
        return (System.currentTimeMillis() - this._lastReqTime) / 1000L;
    }

    @Override
    public void setMaxIdleTime(long l) throws IllegalStateException, IllegalArgumentException {
        if (l < 0L) {
            l = 0L;
        }
        this._maxIdleSeconds = l;
    }

    @Override
    public void setMaxIdleTime(String string) throws IllegalStateException, IllegalArgumentException {
        Duration duration = new Duration(string);
        this._maxIdleSeconds = duration.convertToSeconds(new Date());
    }

    @Override
    public long getMaxIdleTime() throws IllegalStateException {
        return this._maxIdleSeconds;
    }

    @Override
    public String getId() {
        return this._conversationId;
    }

    @Override
    public long getTimeStamp() {
        return this._lastReqTime;
    }

    static void removeSerializedTimeoutListener(String string) {
        _serializedTimeoutListeners.remove(string);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF("10.3");
        ArrayList<String> arrayList = null;
        if (this._timeoutListeners != null) {
            if (verbose) {
                Verbose.say("In writeObject for ConversationalContainer " + this.getId() + " with " + this._timeoutListeners.size() + " timeout listeners");
            }
            arrayList = new ArrayList<String>();
            for (ConversationTimeoutListener conversationTimeoutListener : this._timeoutListeners) {
                _serializedTimeoutListeners.put(conversationTimeoutListener.getId(), conversationTimeoutListener);
                arrayList.add(conversationTimeoutListener.getId());
            }
        }
        objectOutputStream.writeObject(arrayList != null ? arrayList : null);
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        List list;
        String string = objectInputStream.readUTF();
        if (Version.isLaterThanOrEqualTo(string, "10.3") && (list = (List)objectInputStream.readObject()) != null) {
            if (verbose) {
                Verbose.say("In readObject for ConversationalContainer " + this.getId() + " with " + list.size() + " timeout listeners");
            }
            this._timeoutListeners = new ArrayList<ConversationTimeoutListener>();
            for (String string2 : list) {
                ConversationTimeoutListener conversationTimeoutListener = _serializedTimeoutListeners.remove(string2);
                if (conversationTimeoutListener == null) continue;
                this._timeoutListeners.add(conversationTimeoutListener);
            }
        }
        objectInputStream.defaultReadObject();
    }

    long getLastReqTime() {
        return this._lastReqTime;
    }

    long getMaxAgeTime() {
        return this._maxAgeTime;
    }

    long getMaxIdleSeconds() {
        return this._maxIdleSeconds;
    }

    boolean isSinglePrincipal() {
        return this._singlePrincipal;
    }

    long getStartTime() {
        return this._startTime;
    }

    String getStartUser() {
        return this._startUser;
    }

    int getState() {
        return this._state;
    }

    void setStartUser(String string) {
        this._startUser = string;
    }

    void setState(int n) {
        this._state = n;
    }

    List<ConversationTimeoutListener> getTimeoutListeners() {
        return this._timeoutListeners;
    }

    void setTimeoutListeners(List<ConversationTimeoutListener> list) {
        if (this._timeoutListeners != null) {
            ArrayList<ConversationTimeoutListener> arrayList = new ArrayList<ConversationTimeoutListener>();
            for (ConversationTimeoutListener conversationTimeoutListener : this._timeoutListeners) {
                if (conversationTimeoutListener == null || list != null && list.contains(conversationTimeoutListener)) continue;
                arrayList.add(conversationTimeoutListener);
            }
            for (ConversationTimeoutListener conversationTimeoutListener : arrayList) {
                conversationTimeoutListener.cancel();
            }
        }
        this._timeoutListeners = list;
    }
}

