/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.container;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class Duration {
    static final long serialVersionUID = 1L;
    private static final int VALUE_UNKNOWN = -1;
    private static String[] _durationNames = new String[]{"years", "months", "days", "hours", "minutes", "seconds"};
    private long years;
    private long months;
    private long days;
    private long hours;
    private long minutes;
    private long seconds;

    public Duration() {
    }

    public Duration(long l) {
        this.seconds = l;
    }

    public Duration(int n) {
        this.seconds = n;
    }

    public Duration(long l, long l2, long l3, long l4, long l5, long l6) {
        this.years = l;
        this.months = l2;
        this.days = l3;
        this.hours = l4;
        this.minutes = l5;
        this.seconds = l6;
    }

    public Duration(String string) throws IllegalArgumentException {
        this.setFromDescription(string);
    }

    public long getYears() {
        return this.years;
    }

    public long getMonths() {
        return this.months;
    }

    public long getDays() {
        return this.days;
    }

    public long getHours() {
        return this.hours;
    }

    public long getMinutes() {
        return this.minutes;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public boolean isZero() {
        return this.years == 0L && this.months == 0L && this.days == 0L && this.hours == 0L && this.minutes == 0L && this.seconds == 0L;
    }

    public String toString() {
        return this.years + "y" + this.months + "m" + this.days + "dt" + this.hours + "h" + this.minutes + "m" + this.seconds + "s";
    }

    public long computeDate(long l) {
        Date date = l == -1L ? new Date() : new Date(l);
        return this.computeDate(date).getTime();
    }

    public Date computeDate(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (date != null) {
            gregorianCalendar.setTime(date);
        }
        Duration.gregory(gregorianCalendar, 1, this.getYears());
        Duration.gregory(gregorianCalendar, 2, this.getMonths());
        Duration.gregory(gregorianCalendar, 5, this.getDays());
        Duration.gregory(gregorianCalendar, 10, this.getHours());
        Duration.gregory(gregorianCalendar, 12, this.getMinutes());
        Duration.gregory(gregorianCalendar, 13, this.getSeconds());
        return gregorianCalendar.getTime();
    }

    public long convertToSeconds(Date date) {
        if (date == null) {
            date = new Date();
        }
        return (this.computeDate(date).getTime() - date.getTime() + 499L) / 1000L;
    }

    private static void gregory(GregorianCalendar gregorianCalendar, int n, long l) {
        while (l != 0L) {
            int n2 = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (l < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)l);
            gregorianCalendar.add(n, n2);
            l -= (long)n2;
        }
    }

    private void setFromDescription(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        string = string.toLowerCase(Locale.ENGLISH);
        boolean bl = false;
        int n = 0;
        if (string.charAt(0) == 'p') {
            bl = true;
            ++n;
        }
        long[] lArray = new long[6];
        long l = -1L;
        int n2 = 0;
        boolean bl2 = false;
        while (n < string.length()) {
            char c = string.charAt(n);
            int n3 = n;
            if (bl2) {
                n2 = 3;
                bl2 = false;
            }
            if (Character.isWhitespace(c)) {
                if (bl) {
                    throw new IllegalArgumentException("Whitespace characters not allowed");
                }
                while (++n3 < string.length() && Character.isWhitespace(string.charAt(n3))) {
                }
            } else if (Character.isDigit(c)) {
                if (l != -1L) {
                    throw new IllegalArgumentException("Invalid format: multiple numeric values without delimiter");
                }
                while (++n3 < string.length() && Character.isDigit(string.charAt(n3))) {
                }
                l = Long.parseLong(string.substring(n, n3));
            } else if (Character.isLetter(c)) {
                int n4;
                while (++n3 < string.length() && Character.isLetter(string.charAt(n3))) {
                }
                String string2 = string.substring(n, n3);
                int n5 = 0;
                for (n4 = 1; n4 <= 4; ++n4) {
                    if (!string2.endsWith("time".substring(0, n4))) continue;
                    n5 = n4;
                }
                if (n5 > 0) {
                    if (bl && n5 != 1) {
                        throw new IllegalArgumentException("Single character duration type expected");
                    }
                    bl2 = true;
                    if (string2.length() == n5) {
                        n += n5;
                        continue;
                    }
                    string2 = string2.substring(0, string2.length() - n5);
                }
                if (l == -1L) {
                    throw new IllegalArgumentException("Please specify a valid duration. A duration value may be expressed in seconds, minutes, hours, days, months, or years. Examples: \"1 day\", \"2 minutes 30 seconds\", \"2 min 30 s\".");
                }
                if (bl && string2.length() > 1) {
                    throw new IllegalArgumentException("Single character duration type expected");
                }
                for (n4 = n2; n4 < _durationNames.length; ++n4) {
                    if (!_durationNames[n4].startsWith(string2)) continue;
                    lArray[n4] = l;
                    l = -1L;
                    if (!bl) break;
                    n2 = n4 + 1;
                    break;
                }
                if (n4 == _durationNames.length) {
                    throw new IllegalArgumentException("Unexpected duration value: " + string2);
                }
            } else {
                throw new IllegalArgumentException("Invalid character: " + c);
            }
            n = n3;
        }
        if (l != -1L) {
            throw new IllegalArgumentException("Please specify a valid duration. A duration value may be expressed in seconds, minutes, hours, days, months, or years. Examples: \"1 day\", \"2 minutes 30 seconds\", \"2 min 30 s\".");
        }
        this.years = lArray[0];
        this.months = lArray[1];
        this.days = lArray[2];
        this.hours = lArray[3];
        this.minutes = lArray[4];
        this.seconds = lArray[5];
    }
}

