/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.container;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Map;
import weblogic.jws.Callback;
import weblogic.jws.Context;
import weblogic.jws.ServiceClient;
import weblogic.utils.collections.WeakConcurrentHashMap;
import weblogic.wsee.jws.container.InvokeException;

class FieldHelper {
    private static Map<ClassLoader, WeakReference<Class>> contextClassCache = new WeakConcurrentHashMap();

    private FieldHelper() {
    }

    static boolean isStub(Field field) {
        return field.isAnnotationPresent(ServiceClient.class);
    }

    static boolean isContext(Field field) {
        if (field.isAnnotationPresent(Context.class)) {
            return true;
        }
        Class<?> clazz = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            WeakReference<Class> weakReference = contextClassCache.get(classLoader);
            if (weakReference != null && (clazz = (Class<?>)weakReference.get()) != null) {
                return field.isAnnotationPresent(clazz);
            }
            clazz = classLoader.loadClass("weblogic.controls.jws.Common$Context");
            contextClassCache.put(classLoader, new WeakReference(clazz));
            return field.isAnnotationPresent(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            contextClassCache.put(classLoader, new WeakReference<Class<Void>>(Void.class));
            return false;
        }
    }

    static boolean isCallback(Field field) {
        return field.isAnnotationPresent(Callback.class);
    }

    static void setFieldValue(Field field, Object object, Object object2) {
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(object, object2);
        }
        catch (Exception exception) {
            throw new InvokeException("Unable to assign Field Value", exception);
        }
    }

    static Object getFieldValue(Field field, Object object) {
        Object object2 = null;
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            object2 = field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvokeException("Unable to get Field Value", illegalAccessException);
        }
        return object2;
    }
}

