/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.container;

import com.bea.util.jam.JClass;
import com.bea.util.jam.JamClassLoader;
import com.bea.util.jam.JamServiceFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.jws.AsyncFailure;
import weblogic.jws.AsyncResponse;
import weblogic.jws.CallbackMethod;
import weblogic.jws.ReliabilityErrorHandler;
import weblogic.jws.ServiceClient;
import weblogic.jws.security.CallbackRolesAllowed;
import weblogic.jws.wlw.UseWLW81BindingTypes;
import weblogic.protocol.LocalServerIdentity;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.callback.CallbackInfoHeader;
import weblogic.wsee.callback.CallbackStubImpl;
import weblogic.wsee.callback.CallbackUtils;
import weblogic.wsee.callback.Wlw81CallbackHeader;
import weblogic.wsee.conversation.ContinueHeader;
import weblogic.wsee.conversation.ConversationUtils;
import weblogic.wsee.conversation.StartHeader;
import weblogic.wsee.jaxrpc.ServiceImpl;
import weblogic.wsee.jws.container.Container;
import weblogic.wsee.jws.container.ConversationalContainer;
import weblogic.wsee.jws.container.FieldHelper;
import weblogic.wsee.jws.container.InvokeException;
import weblogic.wsee.message.FreeStandingMsgHeaders;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.reliability.ReliabilityErrorContext;
import weblogic.wsee.server.ServerUtil;
import weblogic.wsee.util.ClassUtil;
import weblogic.wsee.util.Guid;
import weblogic.wsee.util.JmsUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.xml.schema.binding.internal.NameUtil;

class JwsInitializer {
    private final Object targetJWS;
    private final WlMessageContext initialMessageContext;
    private Container container = null;
    private static final boolean verbose = Verbose.isVerbose(JwsInitializer.class);
    private static final String WSDL_LOCATION = "weblogic.wsee.wsdl.location";
    private static final String SERVICE_CLASS_NAME = "weblogic.wsee.service.class.name";
    private static final String SERVICE_METHOD_NAME = "weblogic.wsee.service.method.name";

    JwsInitializer(Object object, WlMessageContext wlMessageContext, Container container) {
        this.targetJWS = object;
        this.initialMessageContext = wlMessageContext;
        this.container = container;
    }

    void initialize() {
        this.initializeFields();
        this.initializeStubs();
        if (this.isConversational()) {
            this.initializeConversationalStubs();
        }
    }

    private void initializeFields() {
        for (Field field : this.targetJWS.getClass().getDeclaredFields()) {
            Object object;
            if (!FieldHelper.isCallback(field) || !field.getType().isInterface() || (object = this.getInitialValueForCallback(field)) == null) continue;
            FieldHelper.setFieldValue(field, this.targetJWS, object);
        }
    }

    private void initializeStubs() {
        for (Field field : this.targetJWS.getClass().getDeclaredFields()) {
            if (!FieldHelper.isStub(field)) continue;
            if (!field.getType().isInterface()) {
                throw new JAXRPCException("ServiceClient annotation should only be used on an interface");
            }
            Object object = this.getInitialValueForStub(field);
            if (object == null) continue;
            FieldHelper.setFieldValue(field, this.targetJWS, object);
        }
    }

    private Object getInitialValueForStub(Field field) {
        try {
            Class<?> clazz = field.getType();
            String string = field.getName();
            this.logInjectionStart(clazz, "stub");
            ServiceClient serviceClient = field.getAnnotation(ServiceClient.class);
            assert (serviceClient != null) : "ServiceClient annotation not found";
            String string2 = serviceClient.wsdlLocation();
            String string3 = this.getServiceName(clazz, serviceClient.serviceName());
            Class<?> clazz2 = null;
            try {
                JwsInitializer.logMessage("Loading class " + string3 + " wsdlLocaltion = " + string2);
                clazz2 = clazz.getClassLoader().loadClass(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                string3 = this.getServiceName(clazz, serviceClient.serviceName() + "_Service");
                JwsInitializer.logMessage("Loading class " + string3 + " wsdlLocaltion = " + string2);
                clazz2 = clazz.getClassLoader().loadClass(string3);
            }
            ServiceImpl serviceImpl = this.createServiceInstance(string2, clazz2);
            if (serviceImpl == null) {
                return null;
            }
            JwsInitializer.logMessage("ServiceInstance is " + serviceImpl.getClass().getName());
            String string4 = this.getPortName(serviceImpl, serviceClient.portName());
            Method method = clazz2.getMethod("get" + NameUtil.getJAXRPCClassName((String)string4), new Class[0]);
            JwsInitializer.logMessage("Invoking method " + method);
            Stub stub = (Stub)method.invoke((Object)serviceImpl, new Object[0]);
            String string5 = serviceImpl._getPortTransport(string4);
            boolean bl = "SOAP12".equals(serviceImpl._getPortBindingType(string4));
            this.setupStubProperties(string2, stub, string3, method, serviceClient.endpointAddress(), serviceImpl, string4);
            this.setupAsyncProperties(stub, string, string5, bl);
            this.setupConversationStyle(serviceImpl, stub);
            if (serviceImpl.hasCallback()) {
                this.setupCallback(stub, string, serviceImpl, string5, string4);
            } else if (serviceImpl.has81Callback()) {
                this.setup81Callback(stub, string, serviceImpl, string5, string4);
                this.setupCallback(stub, string, serviceImpl, string5, string4);
            }
            this.logInjectionEnd();
            return stub;
        }
        catch (Exception exception) {
            if (verbose) {
                Verbose.logException(exception);
            }
            throw new InvokeException("Unable to Construct Stub", exception);
        }
    }

    private void setupConversationStyle(ServiceImpl serviceImpl, Stub stub) {
        if (serviceImpl._has81Conversation()) {
            ConversationUtils.setConversationVersionOne(stub);
        }
    }

    private void setupStubProperties(String string, Stub stub, String string2, Method method, String string3, ServiceImpl serviceImpl, String string4) {
        if (string.length() > 0) {
            stub._setProperty(WSDL_LOCATION, (Object)string);
        }
        stub._setProperty(SERVICE_CLASS_NAME, (Object)string2);
        stub._setProperty(SERVICE_METHOD_NAME, (Object)method.getName());
        if (string3.length() > 0) {
            stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)string3);
        } else if (string.length() > 0) {
            stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)serviceImpl._getPortLocation(string4));
        }
        stub._setProperty("weblogic.wsee.invoke_properties", new HashMap());
        stub._setProperty("weblogic.wsee.complex", (Object)"true");
    }

    private ServiceImpl createServiceInstance(String string, Class clazz) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object t;
        if (string.length() == 0) {
            Constructor constructor = clazz.getConstructor(new Class[0]);
            t = constructor.newInstance(new Object[0]);
        } else {
            Constructor constructor = clazz.getConstructor(String.class);
            t = constructor.newInstance(string);
        }
        if (t instanceof ServiceImpl) {
            return (ServiceImpl)t;
        }
        return null;
    }

    private String getPortName(ServiceImpl serviceImpl, String string) throws ServiceException {
        String string2 = null;
        Iterator iterator = serviceImpl.getPorts();
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            if (!StringUtil.isEmpty(string)) {
                if (!string.equals(qName.getLocalPart())) continue;
                return qName.getLocalPart();
            }
            if (string2 != null) {
                throw new JAXRPCException("there are multiple ports, portname is required in annotation");
            }
            string2 = qName.getLocalPart();
        }
        if (string2 == null) {
            throw new JAXRPCException("No suitable port found");
        }
        return string2;
    }

    private void setupCallback(Stub stub, String string, ServiceImpl serviceImpl, String string2, String string3) {
        EndpointReference endpointReference = new EndpointReference(this.getCallbackAddress(serviceImpl, string2, string3));
        FreeStandingMsgHeaders freeStandingMsgHeaders = new FreeStandingMsgHeaders();
        freeStandingMsgHeaders.addHeader(this.buildCallbackInfoHeader(string));
        endpointReference.setReferenceParameters(freeStandingMsgHeaders);
        stub._setProperty("weblogic.wsee.addressing.CallbackTo", (Object)endpointReference);
    }

    private void setup81Callback(Stub stub, String string, ServiceImpl serviceImpl, String string2, String string3) {
        String string4;
        String string5 = this.getCallbackAddress(serviceImpl, string2, string3);
        if ("jms".equals(string2)) {
            string5 = JmsUtil.wls9UriToWlw81(string5);
        }
        CallbackInfoHeader callbackInfoHeader = this.buildCallbackInfoHeader(string);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isConversational()) {
            ContinueHeader continueHeader = new ContinueHeader(this.getConversationId(), LocalServerIdentity.getIdentity().getServerName());
            string4 = "[" + continueHeader.convertToWlw81StringForm() + "]";
        } else {
            string4 = "[]";
        }
        stringBuffer.append(string4);
        stringBuffer.append(callbackInfoHeader.convertToWlw81StringForm());
        stringBuffer.append(":");
        stringBuffer.append(Guid.generateGuidStandardChar());
        stub._setProperty("weblogic.wsee.conversation.ConversationId", (Object)stringBuffer.toString());
        stub._setProperty("weblogic.wsee.callback.loc", (Object)string5);
    }

    private CallbackInfoHeader buildCallbackInfoHeader(String string) {
        CallbackInfoHeader callbackInfoHeader = new CallbackInfoHeader();
        callbackInfoHeader.setServiceURI(this.initialMessageContext.getDispatcher().getConnection().getTransport().getServiceURI());
        if (this.container instanceof ConversationalContainer) {
            Method[] methodArray = ApplicationVersionUtils.getCurrentVersionId();
            if (methodArray != null) {
                callbackInfoHeader.setAppVersion((String)methodArray);
                if (verbose) {
                    Verbose.log("conversational callback endpoint version = " + (String)methodArray);
                }
            } else if (verbose) {
                Verbose.log("conversation callback endpoint is not versioned");
            }
        } else if (verbose) {
            Verbose.log("non-conversational callback - no versioning");
        }
        for (Method method : this.targetJWS.getClass().getDeclaredMethods()) {
            CallbackMethod callbackMethod = method.getAnnotation(CallbackMethod.class);
            if (callbackMethod == null || !string.equals(callbackMethod.target())) continue;
            callbackInfoHeader.setStubName(string);
            CallbackRolesAllowed callbackRolesAllowed = method.getAnnotation(CallbackRolesAllowed.class);
            if (callbackRolesAllowed != null) {
                callbackInfoHeader.setRoleRequired(true);
                break;
            }
            try {
                Field field = this.targetJWS.getClass().getDeclaredField(string);
                callbackRolesAllowed = field.getAnnotation(CallbackRolesAllowed.class);
                if (callbackRolesAllowed == null) continue;
                callbackInfoHeader.setRoleRequired(true);
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new JAXRPCException((Throwable)noSuchFieldException);
            }
        }
        return callbackInfoHeader;
    }

    private String getCallbackAddress(ServiceImpl serviceImpl, String string, String string2) {
        String string3 = (String)this.initialMessageContext.getProperty("weblogic.wsee.context_path");
        if (string3 == null) {
            throw new JAXRPCException("Can't find the current context path");
        }
        QName qName = serviceImpl.getCallbackServiceName();
        String string4 = CallbackUtils.getCallbackPortName(string2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ServerUtil.getServerURL(string));
        if (!string3.startsWith("/")) {
            stringBuilder.append('/');
        }
        stringBuilder.append(string3);
        stringBuilder.append(CallbackUtils.getServiceUri(qName, string4));
        if (!string.equalsIgnoreCase("jms")) {
            return stringBuilder.toString();
        }
        return this.getJMSUrl(stringBuilder.toString(), ServerUtil.getCallbackQueueInfo().getQueueName());
    }

    private String getJMSUrl(String string, String string2) {
        return string + "?URI=" + string2 + "&FACTORY=" + ServerUtil.getJmsConnectionFactory();
    }

    private String getServiceName(Class clazz, String string) {
        String string2 = clazz.getName();
        string = NameUtil.getJAXRPCClassName((String)string);
        return string2.substring(0, string2.lastIndexOf(".") + 1) + string + "_Impl";
    }

    private void setupAsyncProperties(Stub stub, String string, String string2, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (Method method : this.targetJWS.getClass().getDeclaredMethods()) {
            AsyncResponse asyncResponse = method.getAnnotation(AsyncResponse.class);
            if (asyncResponse != null) {
                if (!string.equals(asyncResponse.target())) continue;
                hashMap.put(asyncResponse.operation(), method.getName());
                continue;
            }
            AsyncFailure asyncFailure = method.getAnnotation(AsyncFailure.class);
            if (asyncFailure != null) {
                if (!string.equals(asyncFailure.target())) continue;
                hashMap2.put(asyncFailure.operation(), method.getName());
                continue;
            }
            ReliabilityErrorHandler reliabilityErrorHandler = method.getAnnotation(ReliabilityErrorHandler.class);
            if (reliabilityErrorHandler == null || !string.equals(reliabilityErrorHandler.target())) continue;
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 1 || classArray[0] != ReliabilityErrorContext.class) {
                throw new JAXRPCException("Error handler method must have a single parameter of type '" + ReliabilityErrorContext.class.getName() + "'");
            }
            stub._setProperty("weblogic.wsee.reliabile.errorhandler", (Object)method.getName());
        }
        if (hashMap.size() > 0) {
            stub._setProperty("weblogic.wsee.async.response.map", hashMap);
        }
        if (hashMap2.size() > 0) {
            stub._setProperty("weblogic.wsee.async.failure.map", hashMap2);
        }
        EndpointReference endpointReference = AsyncUtil.getDefaultAsyncResponseServiceEPR(string2, bl);
        stub._setProperty("weblogic.wsee.async.res.epr", (Object)endpointReference);
        stub._setProperty("weblogic.wsee.stub.name", (Object)string);
        stub._setProperty("weblogic.wsee.enclosing.classname", (Object)this.targetJWS.getClass().getName());
        stub._setProperty("weblogic.wsee.enclosing.jws.serviceuri", (Object)this.initialMessageContext.getDispatcher().getConnection().getTransport().getServiceURI());
    }

    private Object getInitialValueForCallback(Field field) {
        try {
            Class<?> clazz = field.getType();
            this.logInjectionStart(clazz, "callback");
            Class clazz2 = this.loadServiceClass(clazz);
            Constructor constructor = clazz2.getConstructor(new Class[0]);
            Object t = constructor.newInstance(new Object[0]);
            Method method = clazz2.getMethod(this.getCallbackPortMethodName(), new Class[0]);
            JwsInitializer.logMessage("Invoking method " + method);
            Stub stub = (Stub)method.invoke(t, new Object[0]);
            this.setupCallbackEndpoint(stub);
            stub._setProperty("weblogic.wsee.complex", (Object)"true");
            stub._setProperty("weblogic.wsee.enclosing.jws.contextpath", this.initialMessageContext.getProperty("weblogic.wsee.context_path"));
            stub._setProperty("weblogic.wsee.enclosing.jws.servicename", this.initialMessageContext.getProperty("weblogic.wsee.service_name"));
            stub._setProperty("weblogic.wsee.enclosing.classname", (Object)this.targetJWS.getClass().getName());
            stub._setProperty("weblogic.wsee.enclosing.jws.serviceuri", (Object)this.initialMessageContext.getDispatcher().getConnection().getTransport().getServiceURI());
            if (this.targetJWS.getClass().getAnnotation(UseWLW81BindingTypes.class) != null) {
                stub._setProperty("weblogic.wsee.usewlw81bindingtypes", (Object)"true");
            }
            if (this.container != null && this.container instanceof ConversationalContainer) {
                stub._setProperty("weblogic.wsee.enclosing.container", (Object)this.container);
            }
            stub = CallbackStubImpl.newInstance(stub, clazz);
            this.logInjectionEnd();
            return stub;
        }
        catch (Exception exception) {
            if (verbose) {
                Verbose.logException(exception);
            }
            throw new InvokeException("Unable to Construct Stub", exception);
        }
    }

    private void setupCallbackEndpoint(Stub stub) {
        EndpointReference endpointReference = (EndpointReference)this.initialMessageContext.getProperty("weblogic.wsee.addressing.CallbackTo");
        if (endpointReference == null) {
            String string;
            MsgHeaders msgHeaders = this.initialMessageContext.getHeaders();
            assert (msgHeaders != null);
            StartHeader startHeader = (StartHeader)msgHeaders.getHeader(StartHeader.TYPE);
            if (startHeader != null && (string = startHeader.getCallbackLocation()) != null) {
                String string2 = startHeader.getConversationId();
                endpointReference = new EndpointReference(string);
                endpointReference.getReferenceParameters().addHeader(new Wlw81CallbackHeader(string2));
            }
        }
        if (endpointReference != null) {
            stub._setProperty("weblogic.wsee.addressing.Target", (Object)endpointReference);
        }
    }

    private Class loadServiceClass(Class clazz) throws ClassNotFoundException {
        String string = this.getCallbackServiceClassName(clazz);
        JwsInitializer.logMessage("Loading class " + string);
        Class<?> clazz2 = clazz.getClassLoader().loadClass(string);
        return clazz2;
    }

    private String getCallbackServiceClassName(Class clazz) {
        String string = clazz.getPackage().getName() + ".callbackclient.";
        String string2 = this.initialMessageContext.getDispatcher().getWsdlPort().getService().getName().getLocalPart();
        String string3 = ClassUtil.getServiceName(this.loadJClass(clazz), string2);
        String string4 = NameUtil.getJAXRPCClassName((String)string3) + "_Impl";
        return string + string4;
    }

    private JClass loadJClass(Class clazz) {
        JamClassLoader jamClassLoader = JamServiceFactory.getInstance().createJamClassLoader(Thread.currentThread().getContextClassLoader());
        return jamClassLoader.loadClass(clazz.getName());
    }

    private String getCallbackPortMethodName() {
        String string = CallbackUtils.getCallbackPortName(this.initialMessageContext.getDispatcher().getWsdlPort().getName().getLocalPart());
        return "get" + NameUtil.getJAXRPCClassName((String)string);
    }

    private boolean isConversational() {
        return !StringUtil.isEmpty(this.getConversationId());
    }

    private String getConversationId() {
        return (String)this.initialMessageContext.getProperty("weblogic.wsee.conversation.ConversationId");
    }

    private void initializeConversationalStubs() {
        String string = this.getConversationId();
        for (Field field : this.targetJWS.getClass().getDeclaredFields()) {
            Object object;
            if (!FieldHelper.isStub(field) || (object = FieldHelper.getFieldValue(field, this.targetJWS)) == null) continue;
            Stub stub = (Stub)object;
            this.setupContinueHeader(stub, "weblogic.wsee.addressing.CallbackTo", string);
            this.setupContinueHeader(stub, "weblogic.wsee.async.res.epr", string);
        }
    }

    private void setupContinueHeader(Stub stub, String string, String string2) {
        EndpointReference endpointReference = (EndpointReference)stub._getProperty(string);
        if (endpointReference != null) {
            endpointReference.getReferenceParameters().addHeader(new ContinueHeader(string2, LocalServerIdentity.getIdentity().getServerName()));
        }
    }

    private void logInjectionStart(Class clazz, String string) {
        if (verbose) {
            Verbose.getOut().println("-------------------------");
            Verbose.log("Dependency injection for " + string);
            Verbose.log("Instance class " + clazz.getName() + " " + clazz.isPrimitive() + " " + clazz.isInterface());
        }
    }

    private void logInjectionEnd() {
        if (verbose) {
            Verbose.getOut().println("-------------------------");
        }
    }

    private static void logMessage(String string) {
        if (verbose) {
            Verbose.log(string);
        }
    }
}

