/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.container;

import java.lang.reflect.Method;

public class Request {
    private Class _targetClass;
    private final Class[] _argTypes;
    private final Object[] _argValues;
    private Method _method;
    private final String _targetClassName;
    private final String _methodName;

    public Request(Class clazz, String string, Class[] classArray, Object[] objectArray) {
        this._targetClass = clazz;
        this._argTypes = classArray;
        this._argValues = objectArray;
        this._targetClassName = clazz.getName();
        this._methodName = string;
        try {
            this._method = clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("method not found on target.", noSuchMethodException);
        }
    }

    public Request(String string, String string2, Class[] classArray, Object[] objectArray) {
        this._argTypes = classArray;
        this._argValues = objectArray;
        this._targetClassName = string;
        this._methodName = string2;
    }

    public Class getTargetClass() {
        if (this._targetClass == null) {
            try {
                this._targetClass = Thread.currentThread().getContextClassLoader().loadClass(this._targetClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Class not found", classNotFoundException);
            }
        }
        return this._targetClass;
    }

    public Method getMethod() {
        if (this._method == null) {
            try {
                this._method = this.getTargetClass().getMethod(this._methodName, this._argTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException("method not found on target.", noSuchMethodException);
            }
        }
        return this._method;
    }

    public Object[] getMethodArgValues() {
        return this._argValues;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("Request\n");
        stringBuffer.append("_targetClass    = " + this._targetClass + "\n");
        stringBuffer.append("_argTypes       = " + this._argTypes + "\n");
        for (n = 0; n < this._argTypes.length; ++n) {
            stringBuffer.append("\t_argTypes[" + n + "] = " + this._argTypes[n].toString() + "\n");
        }
        stringBuffer.append("_argValues      = " + this._argValues + "\n");
        for (n = 0; n < this._argValues.length; ++n) {
            stringBuffer.append("\t_argValues[" + n + "] = " + this._argValues[n].toString() + "\n");
        }
        stringBuffer.append("_method         = " + this._method + "\n");
        return stringBuffer.toString();
    }
}

