/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.container;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPMessage;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.internal.SAFManagerImpl;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.store.PersistentStoreException;
import weblogic.wsee.addressing.AddressingHelper;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.addressing.MessageIdHeader;
import weblogic.wsee.async.AsyncInvokeState;
import weblogic.wsee.async.AsyncInvokeStateObjectHandler;
import weblogic.wsee.async.AsyncPostCallContextImpl;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.cluster.ClusterUtil;
import weblogic.wsee.conversation.LockManager;
import weblogic.wsee.handler.HandlerIterator;
import weblogic.wsee.handler.HandlerListImpl;
import weblogic.wsee.jws.JwsContext;
import weblogic.wsee.jws.container.Container;
import weblogic.wsee.jws.container.ContainerFactory;
import weblogic.wsee.jws.container.ConversationalContainer;
import weblogic.wsee.jws.conversation.Store;
import weblogic.wsee.jws.conversation.StoreConfig;
import weblogic.wsee.jws.conversation.StoreManager;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.reliability.WsrmSAFManagerFactory;
import weblogic.wsee.reliability.WsrmSAFReceivingManager;
import weblogic.wsee.reliability.WsrmSequenceContext;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.server.WsStorage;
import weblogic.wsee.server.WsStorageFactory;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.dispatch.server.JaxrpcChainHandler;
import weblogic.wsee.ws.dispatch.server.ServerDispatcher;

public class ServerResponsePathDispatcher {
    public static final String ASYNC_TX_INVOKE_PROP_NAME = "weblogic.jws.AsyncTransactionalInvoke";
    public static final String ASYNC_TX_INVOKE_IN_PROGRESS_PROP_NAME = "weblogic.jws.AsyncTransactionalInvokeInProgress";
    public static final String ASYNC_TX_INVOKE_SAVED_REQUEST_STATE_KEY_PROP_NAME = "weblogic.jws.AsyncTransactionalInvokeSavedRequestStateKey";
    public static final String PERSISTENT = "persistent";
    public static final String NON_PERSISTENT = "non-persistent";
    private static final boolean verbose = Verbose.isVerbose(ServerResponsePathDispatcher.class);
    private static final String SAVED_REQUEST_STATE_KEY_SUFFIX = "SavedRequestStateKey";

    public static WlMessageContext getWlMessageContext(JwsContext jwsContext) {
        WlMessageContext wlMessageContext = ((Container)jwsContext).getUnfilteredMessageContext();
        return wlMessageContext;
    }

    public static String getRequestMessageId(WlMessageContext wlMessageContext) {
        MessageIdHeader messageIdHeader = (MessageIdHeader)wlMessageContext.getHeaders().getHeader(MessageIdHeader.TYPE);
        assert (messageIdHeader != null);
        return messageIdHeader.getMessageId();
    }

    public static void saveContextForResponsePath(WlMessageContext wlMessageContext) throws WsException {
        boolean bl;
        MessageIdHeader messageIdHeader = (MessageIdHeader)wlMessageContext.getHeaders().getHeader(MessageIdHeader.TYPE);
        String string = messageIdHeader != null ? messageIdHeader.getMessageId() : (String)wlMessageContext.getProperty("weblogic.wsee.addressing.MessageId");
        assert (string != null);
        boolean bl2 = wlMessageContext.getProperty("weblogic.wsee.enable.rm") != null;
        String string2 = (String)wlMessageContext.getProperty(ASYNC_TX_INVOKE_PROP_NAME);
        boolean bl3 = bl = string2 != null && string2.equals(PERSISTENT);
        if (verbose) {
            Verbose.say("Saving request path state for message " + string + ". RM=" + bl2 + " persistent=" + bl);
        }
        wlMessageContext.removeProperty(ASYNC_TX_INVOKE_PROP_NAME);
        wlMessageContext.setProperty(ASYNC_TX_INVOKE_IN_PROGRESS_PROP_NAME, "true");
        WsStorage wsStorage = WsStorageFactory.getStorage("weblogic.wsee.async.store", new AsyncInvokeStateObjectHandler());
        AsyncInvokeState asyncInvokeState = new AsyncInvokeState();
        asyncInvokeState.setAsyncPostCallContext(new AsyncPostCallContextImpl());
        asyncInvokeState.setMessageContext(wlMessageContext);
        asyncInvokeState.setSubject(ClusterUtil.getSubject((AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())));
        asyncInvokeState.setDispatcher(null);
        String string3 = (String)asyncInvokeState.getMessageContext().getProperty("weblogic.wsee.enclosing.jws.serviceuri");
        if (string3 == null) {
            string3 = asyncInvokeState.getMessageContext().getDispatcher().getConnection().getTransport().getServiceURI();
            asyncInvokeState.getMessageContext().setProperty("weblogic.wsee.enclosing.jws.serviceuri", string3);
        }
        AsyncUtil.setApplicationVersionIdIntoContexts(asyncInvokeState.getMessageContext(), asyncInvokeState.getAsyncPostCallContext());
        String string4 = string + SAVED_REQUEST_STATE_KEY_SUFFIX;
        if (bl2) {
            ServerResponsePathDispatcher.removeNonSerializablePropertiesFromContext(wlMessageContext);
            try {
                wlMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", PolicyContext.getResponseEffectivePolicy(wlMessageContext));
                WssPolicyContext wssPolicyContext = (WssPolicyContext)wlMessageContext.getProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx");
                if (wssPolicyContext == null) {
                    wssPolicyContext = wlMessageContext.getDispatcher().getWsPort().getEndpoint().getService().getWssPolicyContext();
                    wlMessageContext.setProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx", wssPolicyContext);
                }
            }
            catch (PolicyException policyException) {
                throw new JAXRPCException((Throwable)policyException);
            }
            try {
                if (bl) {
                    wsStorage.persistentPut(string4, asyncInvokeState);
                }
                wsStorage.put(string4, asyncInvokeState);
            }
            catch (PersistentStoreException persistentStoreException) {
                throw new JAXRPCException((Throwable)persistentStoreException);
            }
        } else {
            wsStorage.put(string4, asyncInvokeState);
        }
    }

    private static void removeNonSerializablePropertiesFromContext(WlMessageContext wlMessageContext) throws WsException {
        wlMessageContext.removeProperty("weblogic.wsee.handler.jaxrpcHandlerChain");
        Container container = ServerResponsePathDispatcher.getContainer(wlMessageContext);
        ConversationalContainer conversationalContainer = null;
        if (container instanceof ConversationalContainer) {
            conversationalContainer = (ConversationalContainer)container;
        }
        wlMessageContext.removeProperty("weblogic.wsee.jws.container");
        LockManager.Lock lock = (LockManager.Lock)wlMessageContext.getProperty("weblogic.wsee.conversation.Lock");
        if (lock != null) {
            lock.release();
            try {
                StoreConfig storeConfig = (StoreConfig)wlMessageContext.getProperty("weblogic.wsee.conversation.StoreConfig");
                if (storeConfig != null && conversationalContainer != null) {
                    Store store = StoreManager.getStore(storeConfig);
                    store.update(conversationalContainer);
                }
            }
            catch (Exception exception) {
                throw new WsException(exception.toString(), exception);
            }
        }
        wlMessageContext.removeProperty("weblogic.wsee.conversation.Lock");
    }

    private static Container getContainer(MessageContext messageContext) {
        Container container = ContainerFactory.getContainer(messageContext);
        return container;
    }

    public static void dispatchResponsePath(String string, SOAPMessage sOAPMessage) throws WsException {
        if (verbose) {
            Verbose.say("ServerResponsePathDispatcher dispatching result: " + sOAPMessage);
        }
        FinalInvokeConfig finalInvokeConfig = ServerResponsePathDispatcher.loadSavedPathState(string, null);
        ServerResponsePathDispatcher.doFinalInvoke(finalInvokeConfig, finalInvokeConfig.context, finalInvokeConfig.subject, sOAPMessage);
        if (verbose) {
            Verbose.say("ServerResponsePathDispatcher done");
        }
    }

    public static void dispatchResponsePath(JwsContext jwsContext, String string, Object object) throws WsException {
        System.out.println("ServerResponsePathDispatcher dispatching result: " + object);
        FinalInvokeConfig finalInvokeConfig = ServerResponsePathDispatcher.loadSavedPathState(string, jwsContext);
        ServerResponsePathDispatcher.doFinalInvoke(finalInvokeConfig, finalInvokeConfig.context, finalInvokeConfig.subject, object);
        System.out.println("ServerResponsePathDispatcher done");
    }

    private static FinalInvokeConfig createFinalInvokeConfig(JwsContext jwsContext, AsyncInvokeState asyncInvokeState) {
        FinalInvokeConfig finalInvokeConfig = new FinalInvokeConfig();
        if (jwsContext != null) {
            finalInvokeConfig.container = (Container)jwsContext;
            finalInvokeConfig.dispatcher = (ServerDispatcher)finalInvokeConfig.container.messageContext.getDispatcher();
        } else {
            finalInvokeConfig.container = null;
            finalInvokeConfig.dispatcher = new ServerDispatcher(asyncInvokeState.getMessageContext());
            AsyncUtil.SavedServiceInfo savedServiceInfo = AsyncUtil.getSavedServiceInfo(asyncInvokeState, verbose);
            WsPort wsPort = savedServiceInfo.wsPort;
            finalInvokeConfig.dispatcher.setWsPort(wsPort);
            finalInvokeConfig.dispatcher.setHandlerChain(new HandlerIterator(finalInvokeConfig.dispatcher.getWsPort().getInternalHandlerList()));
        }
        return finalInvokeConfig;
    }

    private static void doFinalInvoke(FinalInvokeConfig finalInvokeConfig, WlMessageContext wlMessageContext, AuthenticatedSubject authenticatedSubject, Object object) throws WsException {
        ServerResponsePathDispatcher.addBackNonSerializablePropertiesToContext(finalInvokeConfig.container, finalInvokeConfig.dispatcher, wlMessageContext);
        AuthorizedInvoke authorizedInvoke = new AuthorizedInvoke(wlMessageContext, finalInvokeConfig.dispatcher, object);
        if (authenticatedSubject != null) {
            try {
                SecurityServiceManager.runAs((AuthenticatedSubject)((AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())), (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)authorizedInvoke);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof WsException) {
                    throw (WsException)privilegedActionException.getException();
                }
                throw new UndeclaredThrowableException(privilegedActionException.getException());
            }
        }
        try {
            authorizedInvoke.run();
        }
        catch (WsException wsException) {
            throw wsException;
        }
        catch (Exception exception) {
            throw new WsException(exception.toString(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FinalInvokeConfig loadSavedPathState(String string, JwsContext jwsContext) throws WsException {
        AsyncInvokeState asyncInvokeState;
        if (string == null) {
            throw new WsException("Null message ID passed to dispatchResponsePath");
        }
        if (verbose) {
            Verbose.say("Loading request path state for message " + string);
        }
        String string2 = string + SAVED_REQUEST_STATE_KEY_SUFFIX;
        WsStorage wsStorage = WsStorageFactory.getStorage("weblogic.wsee.async.store", new AsyncInvokeStateObjectHandler());
        try {
            asyncInvokeState = (AsyncInvokeState)wsStorage.persistentGet(string2);
            if (asyncInvokeState == null) {
                throw new WsException("Cannot retrieve 'saved state' from request path (key='" + string2 + "') in dispatchResponsePath");
            }
        }
        catch (PersistentStoreException persistentStoreException) {
            if (verbose) {
                Verbose.logException(persistentStoreException);
            }
            throw new WsException(persistentStoreException.toString(), persistentStoreException);
        }
        AsyncInvokeState asyncInvokeState2 = asyncInvokeState;
        synchronized (asyncInvokeState2) {
            asyncInvokeState = (AsyncInvokeState)wsStorage.get(string2);
            if (asyncInvokeState == null) {
                throw new WsException("Cannot retrieve 'saved state' from request path (key='" + string2 + "') in dispatchResponsePath");
            }
            try {
                wsStorage.persistentRemove(string2);
            }
            catch (Exception exception) {
                throw new WsException(exception.toString(), exception);
            }
            FinalInvokeConfig finalInvokeConfig = ServerResponsePathDispatcher.createFinalInvokeConfig(jwsContext, asyncInvokeState);
            finalInvokeConfig.context = asyncInvokeState.getMessageContext();
            finalInvokeConfig.subject = asyncInvokeState.getSubject();
            return finalInvokeConfig;
        }
    }

    private static void addBackNonSerializablePropertiesToContext(JwsContext jwsContext, ServerDispatcher serverDispatcher, WlMessageContext wlMessageContext) {
        wlMessageContext.setProperty("weblogic.wsee.jws.container", jwsContext);
        HandlerListImpl handlerListImpl = (HandlerListImpl)serverDispatcher.getWsPort().getInternalHandlerList();
        for (int i = 0; i < handlerListImpl.size(); ++i) {
            Handler handler = handlerListImpl.get(i);
            if (!(handler instanceof JaxrpcChainHandler)) continue;
            ((JaxrpcChainHandler)handler).prepareForFirstHandleResponse(wlMessageContext);
        }
    }

    public static void handleRMEndProcessing(WlMessageContext wlMessageContext) {
        block18: {
            try {
                String string = (String)wlMessageContext.getProperty("weblogic.wsee.reliability.RequestMessageSeqID");
                String string2 = (String)wlMessageContext.getProperty("weblogic.wsee.reliability.RequestMessageSeqNumber");
                String string3 = (String)wlMessageContext.getProperty("weblogic.wsee.reliability.RequestMessageAction");
                if (string != null) {
                    long l = Long.parseLong(string2);
                    String string4 = (String)wlMessageContext.getProperty("weblogic.wsee.reliability.RequestMessageOfferSeqID");
                    if (string4 != null) {
                        SAFConversationInfo sAFConversationInfo = SAFManagerImpl.getManager().getConversationInfoOnSendingSide(string4);
                        if (sAFConversationInfo != null) {
                            WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
                            if (wsrmSequenceContext != null) {
                                if (wsrmSequenceContext.getResponseSeqNumFromRequestSeqNum(l) == -2L) {
                                    if (!wlMessageContext.containsProperty(ASYNC_TX_INVOKE_IN_PROGRESS_PROP_NAME)) {
                                        if (verbose) {
                                            Verbose.say("*** Doing no-response mapping of requestSeqNum " + l + " action(" + string3 + ")" + " to 0 on offer sequence " + string4);
                                        }
                                        wsrmSequenceContext.mapRequestSeqNumToResponseSeqNum(l, 0L);
                                        SAFManagerImpl.getManager().storeConversationContextOnSendingSide(string4, wsrmSequenceContext);
                                        EndpointReference endpointReference = (EndpointReference)wlMessageContext.getProperty("weblogic.wsee.addressing.ReplyTo");
                                        if (endpointReference == null || AddressingHelper.isAnonymousEndpointReference(wlMessageContext, endpointReference)) {
                                            endpointReference = new EndpointReference(sAFConversationInfo.getDestinationURL());
                                        }
                                        WsrmSAFReceivingManager wsrmSAFReceivingManager = WsrmSAFManagerFactory.getWsrmSAFReceivingManager();
                                        wsrmSAFReceivingManager.checkForAutoTerminateOnOfferSequence(string4, wsrmSequenceContext, endpointReference);
                                    } else if (verbose) {
                                        Verbose.say("*** Deferred mapping of requestSeqNum " + l + " action(" + string3 + ")" + " on offer sequence " + string4 + " until response path is dispatched at a later date");
                                    }
                                } else if (verbose) {
                                    Verbose.say("*** Found that someone started processing and mapped requestSeqNum " + l + " action(" + string3 + ")" + " already on offer sequence " + string4);
                                }
                            }
                        } else if (verbose) {
                            Verbose.say("*** Didn't find conversation info for offer sequence " + string4 + " in order to map requestSeqNum " + l + " action(" + string3 + ")" + " to response on offer sequence");
                        }
                    } else if (verbose) {
                        Verbose.say("*** Didn't find a saved offer sequence ID on message context needed to process a sequence message from request sequence " + string + " in order to map requestSeqNum " + l + " action(" + string3 + ")" + " to response on offer sequence");
                    }
                }
            }
            catch (Exception exception) {
                if (!verbose) break block18;
                Verbose.logException(exception);
            }
        }
    }

    private static void ensureWsMethodOnDispatcher(ServerDispatcher serverDispatcher) throws WsException {
        WlMessageContext wlMessageContext = serverDispatcher.getContext();
        if (serverDispatcher.getWsMethod() == null) {
            QName qName = (QName)wlMessageContext.getProperty("weblogic.wsee.ws.server.OperationName");
            if (qName == null) {
                throw new WsException("No operation name on MessageContext");
            }
            WsMethod wsMethod = serverDispatcher.getWsPort().getEndpoint().getMethod(qName.getLocalPart());
            if (wsMethod == null) {
                throw new WsException("Unable to find method with name:" + qName + " method available are -- " + serverDispatcher.getWsPort().getEndpoint());
            }
            serverDispatcher.setWsMethod(wsMethod);
        }
    }

    static /* synthetic */ void access$100(ServerDispatcher serverDispatcher) throws WsException {
        ServerResponsePathDispatcher.ensureWsMethodOnDispatcher(serverDispatcher);
    }

    private static class AuthorizedInvoke
    implements PrivilegedExceptionAction {
        private WlMessageContext savedMc;
        private ServerDispatcher dispatcher;
        private Object result;

        AuthorizedInvoke(WlMessageContext wlMessageContext, ServerDispatcher serverDispatcher, Object object) {
            this.savedMc = wlMessageContext;
            this.dispatcher = serverDispatcher;
            this.result = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public Object run() throws WsException {
            this.dispatcher.setContext(this.savedMc);
            ServerResponsePathDispatcher.access$100(this.dispatcher);
            if (this.result instanceof SOAPMessage) {
                var1_1 = (SOAPMessage)this.result;
                var2_3 = (SOAPMessageContext)this.dispatcher.getContext();
                var2_3.setMessage(var1_1);
                try {
                    if (!var1_1.getSOAPBody().hasFault()) ** GOTO lbl24
                    var3_4 = var1_1.getSOAPBody().getFault();
                    var4_6 = new SOAPFaultException(var3_4.getFaultCodeAsQName(), var3_4.getFaultString(), var3_4.getFaultActor(), var3_4.getDetail());
                    var4_6.fillInStackTrace();
                    this.dispatcher.getContext().setFault(var4_6);
                }
                catch (Exception var3_5) {
                    throw new WsException(var3_5.toString(), var3_5);
                }
            } else if (this.result instanceof Throwable) {
                this.dispatcher.getContext().setFault((Throwable)this.result);
            } else {
                var1_2 = this.dispatcher.getWsMethod().getReturnType();
                if (var1_2 != null) {
                    this.dispatcher.getOutParams().put(var1_2.getName(), this.result);
                }
            }
lbl24:
            // 6 sources

            try {
                this.dispatcher.dispatchResponsePath();
            }
            finally {
                ServerResponsePathDispatcher.handleRMEndProcessing(this.savedMc);
            }
            return null;
        }
    }

    private static class FinalInvokeConfig {
        public WlMessageContext context;
        public AuthenticatedSubject subject;
        public Container container;
        public ServerDispatcher dispatcher;

        private FinalInvokeConfig() {
        }
    }
}

