/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.context;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import weblogic.jws.CallbackMethod;
import weblogic.security.SubjectUtils;
import weblogic.security.WLSPrincipals;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.RoleManager;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.service.WebServiceResource;
import weblogic.security.spi.Resource;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.utils.Debug;
import weblogic.wsee.connection.transport.servlet.HttpTransportUtils;
import weblogic.wsee.jws.context.JwsSecurityContext;
import weblogic.wsee.jws.util.Util;
import weblogic.wsee.message.WlMessageContext;

public class WebSecurityContext
implements JwsSecurityContext {
    private static final String DEBUG_PROPERTY = "weblogic.wsee.security.debug";
    private static final boolean DEBUG = Boolean.getBoolean("weblogic.wsee.security.debug");
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private boolean initted = false;
    private WlMessageContext messageContext;
    private Class jws;
    private Class<?> eiClass;
    private HashMap<WebServiceResource, Map> roles = new HashMap();

    public WebSecurityContext(WlMessageContext wlMessageContext, Class clazz) {
        this.messageContext = wlMessageContext;
        this.jws = clazz;
        this.eiClass = Util.getEIClass(clazz);
    }

    public void setMessageContext(WlMessageContext wlMessageContext) {
        this.messageContext = wlMessageContext;
    }

    public Principal getCallerPrincipal() {
        Principal principal = null;
        AuthenticatedSubject authenticatedSubject = WebSecurityContext.getSubject();
        if (authenticatedSubject != null) {
            principal = SubjectUtils.getUserPrincipal((AuthenticatedSubject)authenticatedSubject);
        }
        if (principal == null) {
            principal = WLSPrincipals.getAnonymousUserPrincipal();
        }
        return principal;
    }

    public boolean isCallerInRole(String string) {
        if (string == null) {
            return false;
        }
        AuthenticatedSubject authenticatedSubject = WebSecurityContext.getSubject();
        this.initRoleMaps(authenticatedSubject);
        for (Map.Entry<WebServiceResource, Map> httpServletRequest2 : this.roles.entrySet()) {
            if (!SecurityServiceManager.isUserInRole((AuthenticatedSubject)authenticatedSubject, (String)string, (Map)httpServletRequest2.getValue())) continue;
            return true;
        }
        HttpServletRequest httpServletRequest = HttpTransportUtils.getHttpServletRequest(this.messageContext);
        if (httpServletRequest != null && httpServletRequest instanceof ServletRequestImpl) {
            return ((ServletRequestImpl)httpServletRequest).getContext().getSecurityManager().getWebAppSecurity().isSubjectInRole(authenticatedSubject, string, ((ServletRequestImpl)httpServletRequest).getSecurityContextHandler(), ((ServletRequestImpl)httpServletRequest).getServletStub());
        }
        return false;
    }

    private void initRoleMaps(AuthenticatedSubject authenticatedSubject) {
        if (!this.initted) {
            Method[] methodArray;
            String string = (String)this.messageContext.getProperty("weblogic.wsee.service_name");
            String string2 = (String)this.messageContext.getProperty("weblogic.wsee.context_path");
            String string3 = (String)this.messageContext.getProperty("weblogic.wsee.security_realm");
            String string4 = (String)this.messageContext.getProperty("weblogic.wsee.application_id");
            RoleManager roleManager = (RoleManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)string3, (SecurityService.ServiceType)SecurityService.ServiceType.ROLE);
            for (Method method : methodArray = this.jws.getMethods()) {
                WebServiceResource webServiceResource;
                Map map;
                if (!Util.isWebMethod(method, this.eiClass) && !method.isAnnotationPresent(CallbackMethod.class) || (map = roleManager.getRoles(authenticatedSubject, (Resource)(webServiceResource = WebSecurityContext.createWebServiceResource(string4, string2, string, method)), null)) == null) continue;
                this.roles.put(webServiceResource, map);
                if (!DEBUG) continue;
                Debug.say((String)("*** Roles map for " + webServiceResource + " is " + map));
            }
            this.initted = true;
        }
    }

    private static final WebServiceResource createWebServiceResource(String string, String string2, String string3, Method method) {
        String string4 = method.getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        Class<?>[] classArray = method.getParameterTypes();
        for (Class<?> clazz : classArray) {
            arrayList.add(clazz.getCanonicalName());
        }
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        WebServiceResource webServiceResource = new WebServiceResource(string, string2, string3, string4, (String[])objectArray);
        if (DEBUG) {
            Debug.say((String)("*** Creating WebServiceResource: " + webServiceResource));
        }
        return webServiceResource;
    }

    private static AuthenticatedSubject getSubject() {
        return SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
    }
}

