/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.conversation;

import javax.xml.rpc.JAXRPCException;
import weblogic.store.ObjectHandler;
import weblogic.store.PersistentMap;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreManager;
import weblogic.store.xa.PersistentStoreXA;
import weblogic.wsee.jws.conversation.ConversationState;
import weblogic.wsee.jws.conversation.PersistentStoreObjectHandler;
import weblogic.wsee.jws.conversation.Store;
import weblogic.wsee.jws.conversation.StoreConfig;
import weblogic.wsee.jws.conversation.StoreException;

class FileStore
implements Store {
    private static final String DEFAULT_MAP_NAME = "WSConversations";
    private PersistentMap map;
    private StoreConfig storeConfig = null;

    FileStore(StoreConfig storeConfig) {
        this.storeConfig = storeConfig;
        String string = (String)storeConfig.get("storeName");
        this.init(string, null);
    }

    public StoreConfig getStoreConfig() {
        return this.storeConfig;
    }

    public void insert(ConversationState conversationState) throws StoreException {
        try {
            boolean bl = this.map.put((Object)conversationState.getId(), (Object)conversationState);
            if (bl) {
                throw new StoreException("Conversation already exists: " + conversationState.getId());
            }
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new StoreException("Could not update persistent state for conversation " + conversationState.getId(), (Exception)((Object)persistentStoreException));
        }
    }

    public void update(ConversationState conversationState) throws StoreException {
        try {
            boolean bl = this.map.put((Object)conversationState.getId(), (Object)conversationState);
            if (!bl) {
                throw new StoreException("Attempt to update non-existant conversation: " + conversationState.getId());
            }
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new StoreException("Could not update persistent state for conversation " + conversationState.getId(), (Exception)((Object)persistentStoreException));
        }
    }

    public ConversationState read(String string) throws StoreException {
        try {
            return (ConversationState)this.map.get((Object)string);
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new StoreException("Conversation read failed: id=" + string, (Exception)((Object)persistentStoreException));
        }
    }

    public ConversationState readForUpdate(String string) throws StoreException {
        try {
            return (ConversationState)this.map.get((Object)string);
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new StoreException("Conversation read failed: id=" + string, (Exception)((Object)persistentStoreException));
        }
    }

    public void delete(String string) throws StoreException {
        try {
            this.map.remove((Object)string);
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new StoreException("Conversation delete failed: id=" + string, (Exception)((Object)persistentStoreException));
        }
    }

    private void init(String string, String string2) {
        if (string2 == null) {
            string2 = DEFAULT_MAP_NAME;
        }
        PersistentStoreXA persistentStoreXA = this.getPersistentStore(string);
        try {
            this.map = persistentStoreXA.createPersistentMapXA(string2, (ObjectHandler)new PersistentStoreObjectHandler());
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new JAXRPCException("Could not create conversation map", (Throwable)persistentStoreException);
        }
    }

    private PersistentStoreXA getPersistentStore(String string) {
        PersistentStoreXA persistentStoreXA = null;
        persistentStoreXA = string == null ? (PersistentStoreXA)PersistentStoreManager.getManager().getDefaultStore() : (PersistentStoreManager.getManager().storeExistsByLogicalName(string) ? (PersistentStoreXA)PersistentStoreManager.getManager().getStoreByLogicalName(string) : (PersistentStoreXA)PersistentStoreManager.getManager().getStore(string));
        if (persistentStoreXA == null) {
            throw new JAXRPCException("persistent store not found: " + string == null ? "default" : string);
        }
        return persistentStoreXA;
    }
}

