/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.conversation;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.nio.ByteBuffer;
import weblogic.common.internal.ProxyClassResolver;
import weblogic.utils.io.ByteBufferDataInputStream;

public class PersistentStoreObjectInputStream
extends ByteBufferDataInputStream
implements ObjectInput {
    private ObjectInputStream ois;

    public PersistentStoreObjectInputStream(ByteBuffer[] byteBufferArray) {
        super(byteBufferArray);
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        if (this.ois == null) {
            this.ois = new ContextObjectInputStream((InputStream)((Object)this));
        }
        return this.ois.readObject();
    }

    private static class ContextObjectInputStream
    extends ObjectInputStream {
        public ContextObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
            this.enableResolveObject(true);
        }

        public Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            String string = objectStreamClass.getName();
            if ("int".equals(string)) {
                return Integer.TYPE;
            }
            if ("double".equals(string)) {
                return Double.TYPE;
            }
            if ("boolean".equals(string)) {
                return Boolean.TYPE;
            }
            if ("float".equals(string)) {
                return Float.TYPE;
            }
            if ("byte".equals(string)) {
                return Byte.TYPE;
            }
            if ("long".equals(string)) {
                return Long.TYPE;
            }
            if ("short".equals(string)) {
                return Short.TYPE;
            }
            if ("char".equals(string)) {
                return Character.TYPE;
            }
            return Class.forName(objectStreamClass.getName(), true, Thread.currentThread().getContextClassLoader());
        }

        protected Class resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
            return ProxyClassResolver.resolveProxyClass(stringArray);
        }
    }
}

