/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.conversation;

import java.util.HashMap;
import java.util.Map;
import weblogic.wsee.jws.conversation.FileStoreFactory;
import weblogic.wsee.jws.conversation.Store;
import weblogic.wsee.jws.conversation.StoreConfig;
import weblogic.wsee.jws.conversation.StoreException;
import weblogic.wsee.jws.conversation.StoreFactory;
import weblogic.wsee.jws.conversation.database.DBStoreFactory;

public class StoreManager {
    private static Map<String, StoreFactory> storeFactories = new HashMap<String, StoreFactory>();
    private static Map<StoreConfig, Store> storeCache = new HashMap<StoreConfig, Store>();

    public static synchronized void register(StoreFactory storeFactory) {
        storeFactories.put(storeFactory.getType(), storeFactory);
    }

    public static synchronized void unregister(String string) {
        storeFactories.remove(string);
    }

    public static synchronized Store getStore(StoreConfig storeConfig) throws StoreException {
        if (storeConfig == null) {
            throw new IllegalArgumentException("config may not be null");
        }
        Store store = storeCache.get(storeConfig);
        if (store == null) {
            StoreFactory storeFactory = storeFactories.get(storeConfig.getType());
            if (storeFactory == null) {
                throw new StoreException("unknown store factory type: " + storeConfig.getType());
            }
            store = storeFactory.createStore(storeConfig);
            storeCache.put(storeConfig, store);
        }
        return store;
    }

    static {
        StoreManager.register(new FileStoreFactory());
        StoreManager.register(new DBStoreFactory());
    }
}

