/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.conversation;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;

public class WlwObjectInputStream
extends ObjectInputStream {
    private ClassLoader _classLoader;

    public WlwObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException, StreamCorruptedException {
        super(inputStream);
        this._classLoader = classLoader;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        if ("int".equals(string)) {
            return Integer.TYPE;
        }
        if ("double".equals(string)) {
            return Double.TYPE;
        }
        if ("boolean".equals(string)) {
            return Boolean.TYPE;
        }
        if ("float".equals(string)) {
            return Float.TYPE;
        }
        if ("byte".equals(string)) {
            return Byte.TYPE;
        }
        if ("long".equals(string)) {
            return Long.TYPE;
        }
        if ("short".equals(string)) {
            return Short.TYPE;
        }
        if ("char".equals(string)) {
            return Character.TYPE;
        }
        ClassLoader classLoader = null;
        classLoader = this._classLoader;
        return Class.forName(objectStreamClass.getName(), false, classLoader);
    }

    protected Class resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        Class[] classArray = new Class[stringArray.length];
        ClassLoader classLoader = null;
        classLoader = this._classLoader;
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = Class.forName(stringArray[i], false, classLoader);
        }
        return Proxy.getProxyClass(classLoader, classArray);
    }
}

