/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.conversation.database;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import weblogic.utils.io.StreamUtils;
import weblogic.wsee.jws.conversation.database.DbPersistence;
import weblogic.wsee.jws.conversation.database.GenericTableAccess;
import weblogic.wsee.jws.conversation.database.LoadedObject;
import weblogic.wsee.jws.util.Config;

class DB2TableAccess
extends GenericTableAccess {
    DB2TableAccess() {
    }

    public String getCreateTableStatement() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE " + this._tableName + "(");
        stringBuffer.append("CG_ID");
        stringBuffer.append(" varchar(");
        stringBuffer.append(Config.getProperty("weblogic.jws.ConversationMaxKeyLength"));
        stringBuffer.append(") not null,");
        stringBuffer.append("LAST_ACCESS_TIME DECIMAL (19, 0),");
        String string = Config.getProperty("weblogic.jws.cgdata.size");
        stringBuffer.append("CG_DATA BLOB(" + string + "),");
        stringBuffer.append("PRIMARY KEY (CG_ID) )");
        return stringBuffer.toString();
    }

    protected String getCreateStatement() {
        if (this._createStmt == null) {
            StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
            stringBuffer.append(this._tableName);
            stringBuffer.append(" (CG_ID, LAST_ACCESS_TIME, CG_DATA");
            stringBuffer.append(" ) VALUES (?, ?, ?)");
            this._createStmt = stringBuffer.toString();
        }
        return this._createStmt;
    }

    protected String getSelectObjectStatement() {
        if (this._selectObjectStmt == null) {
            StringBuffer stringBuffer = new StringBuffer("SELECT CG_DATA FROM ");
            stringBuffer.append(this._tableName);
            stringBuffer.append(" WHERE CG_ID = ? ");
            stringBuffer.append("FOR UPDATE");
            this._selectObjectStmt = stringBuffer.toString();
        }
        return this._selectObjectStmt;
    }

    protected String getLoadStatement(boolean bl) {
        if (bl && this._loadStmt != null) {
            return this._loadStmt;
        }
        if (!bl && this._loadStmtNoUpdateLock != null) {
            return this._loadStmtNoUpdateLock;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        stringBuffer.append("LAST_ACCESS_TIME, CG_DATA ");
        stringBuffer.append(" FROM ");
        stringBuffer.append(this._tableName);
        stringBuffer.append(" WHERE CG_ID = ?");
        if (bl) {
            stringBuffer.append(" FOR UPDATE");
            this._loadStmt = stringBuffer.toString();
            return this._loadStmt;
        }
        this._loadStmtNoUpdateLock = stringBuffer.toString();
        return this._loadStmtNoUpdateLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedObject doLoad(Connection connection, String string, boolean bl) throws SQLException, IOException {
        byte[] byArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.getLoadStatement(bl));
            preparedStatement.setObject(1, string);
            preparedStatement.executeQuery();
            resultSet = preparedStatement.getResultSet();
            Object object = null;
            if (resultSet.next()) {
                byArray = this.readByteArrayFromResultSet(resultSet, 2);
                long l = resultSet.getLong(1);
                object = new LoadedObject(l, byArray);
            }
            byArray = object;
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            DbPersistence.close(resultSet);
            DbPersistence.close(preparedStatement);
            throw throwable;
        }
        DbPersistence.close(resultSet);
        DbPersistence.close(preparedStatement);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readByteArrayFromResultSet(ResultSet resultSet, int n) throws IOException, SQLException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        InputStream inputStream = null;
        byte[] byArray = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
            inputStream = resultSet.getBinaryStream(2);
            StreamUtils.writeTo((InputStream)inputStream, (OutputStream)bufferedOutputStream);
            bufferedOutputStream.flush();
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            DbPersistence.close(byteArrayOutputStream);
            throw throwable;
        }
        DbPersistence.close(byteArrayOutputStream);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doStoreByInsert(Connection connection, String string, byte[] byArray, long l) throws SQLException, IOException {
        boolean bl;
        ByteArrayInputStream byteArrayInputStream = null;
        PreparedStatement preparedStatement = null;
        try {
            boolean bl2;
            preparedStatement = connection.prepareStatement(this.getCreateStatement());
            preparedStatement.setObject(1, string);
            preparedStatement.setLong(2, l);
            byteArrayInputStream = null;
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            preparedStatement.setBinaryStream(3, (InputStream)byteArrayInputStream, byArray.length);
            bl = bl2 = preparedStatement.executeUpdate() == 1;
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            DbPersistence.close(preparedStatement);
            DbPersistence.close(byteArrayInputStream);
            throw throwable;
        }
        DbPersistence.close(preparedStatement);
        DbPersistence.close(byteArrayInputStream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doStoreByUpdate(Connection connection, String string, byte[] byArray, long l, boolean bl) throws SQLException, IOException {
        boolean bl2;
        PreparedStatement preparedStatement = null;
        ByteArrayInputStream byteArrayInputStream = null;
        boolean bl3 = false;
        try {
            if (bl) {
                preparedStatement = connection.prepareStatement(this.getStoreStatement());
                preparedStatement.setLong(1, l);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                preparedStatement.setBinaryStream(2, (InputStream)byteArrayInputStream, byArray.length);
                preparedStatement.setObject(3, string);
                bl3 = preparedStatement.executeUpdate() > 0;
            } else {
                boolean bl22 = false;
                preparedStatement = connection.prepareStatement(this.getStoreLiteStatement());
                preparedStatement.setLong(1, l);
                int n = this.getStoreLiteStatementIDColumn();
                preparedStatement.setObject(n, string);
                bl3 = preparedStatement.executeUpdate() > 0;
            }
            bl2 = bl3;
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            DbPersistence.close(preparedStatement);
            DbPersistence.close(byteArrayInputStream);
            throw throwable;
        }
        DbPersistence.close(preparedStatement);
        DbPersistence.close(byteArrayInputStream);
        return bl2;
    }
}

