/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.conversation.database;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ejb.EJBException;
import javax.naming.NamingException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;
import weblogic.wsee.jws.conversation.database.DB2TableAccess;
import weblogic.wsee.jws.conversation.database.GenericTableAccess;
import weblogic.wsee.jws.conversation.database.MsSqlServerTableAccess;
import weblogic.wsee.jws.conversation.database.OracleTableAccess;
import weblogic.wsee.jws.conversation.database.PointbaseTableAccess;
import weblogic.wsee.jws.conversation.database.SybaseTableAccess;
import weblogic.wsee.jws.conversation.database.TableAccess;
import weblogic.wsee.jws.util.Config;
import weblogic.wsee.jws.util.Util;

class DbPersistence {
    DbPersistence() {
    }

    private static TableAccess createTableAccess(Connection connection, String string) throws SQLException {
        GenericTableAccess genericTableAccess = null;
        switch (Util.getDBType(connection)) {
            case 1: {
                genericTableAccess = new OracleTableAccess();
                break;
            }
            case 3: {
                genericTableAccess = new PointbaseTableAccess();
                break;
            }
            case 4: {
                genericTableAccess = new MsSqlServerTableAccess();
                break;
            }
            case 5: {
                genericTableAccess = new SybaseTableAccess();
                break;
            }
            case 6: {
                genericTableAccess = new DB2TableAccess();
                break;
            }
            default: {
                genericTableAccess = new PointbaseTableAccess();
            }
        }
        genericTableAccess.setTableName(string);
        return genericTableAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TableAccess initTableAccess(String string) throws SQLException, SystemException, InvalidTransactionException {
        Connection connection = null;
        TableAccess tableAccess = null;
        Transaction transaction = null;
        TransactionManager transactionManager = null;
        try {
            transactionManager = TxHelper.getTransactionManager();
            if (transactionManager != null) {
                transaction = transactionManager.suspend();
            }
            connection = DbPersistence.getConnection();
            tableAccess = DbPersistence.createTableAccess(connection, string);
            if (!Config.iterativeDevDisabled()) {
                tableAccess.ensureTableCreated(connection);
            }
            connection.commit();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            DbPersistence.cleanup(connection, null);
            if (transaction != null) {
                transactionManager.resume(transaction);
            }
            throw throwable;
        }
        DbPersistence.cleanup(connection, null);
        if (transaction != null) {
            transactionManager.resume(transaction);
        }
        return tableAccess;
    }

    static Connection getConnection() throws SQLException {
        try {
            return Util.getConnection("java:comp/env/ConversationDataSource");
        }
        catch (NamingException namingException) {
            try {
                return Util.getConnection(Config.getProperty("weblogic.jws.ConversationDataSource"));
            }
            catch (NamingException namingException2) {
                throw new EJBException((Exception)namingException2);
            }
        }
    }

    static void cleanup(Connection connection, PreparedStatement preparedStatement) {
        Exception exception = null;
        Exception exception2 = null;
        try {
            DbPersistence.close(preparedStatement);
        }
        catch (Exception exception3) {
            exception = exception3;
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception4) {
            exception2 = exception4;
        }
        if (exception != null) {
            throw new EJBException(exception);
        }
        if (exception2 != null) {
            throw new EJBException(exception2);
        }
    }

    static void close(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static void close(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static void close(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void close(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

