/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.conversation.database;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import weblogic.wsee.jws.conversation.ConversationState;
import weblogic.wsee.jws.conversation.Store;
import weblogic.wsee.jws.conversation.StoreConfig;
import weblogic.wsee.jws.conversation.StoreException;
import weblogic.wsee.jws.conversation.database.DbPersistence;
import weblogic.wsee.jws.conversation.database.LoadedObject;
import weblogic.wsee.jws.conversation.database.TableAccess;

class DbStore
implements Store {
    private TableAccess _tableAccess;
    private StoreConfig _storeConfig = null;

    DbStore(StoreConfig storeConfig, TableAccess tableAccess) {
        this._tableAccess = tableAccess;
        this._storeConfig = storeConfig;
    }

    public StoreConfig getStoreConfig() {
        return this._storeConfig;
    }

    public void insert(ConversationState conversationState) throws StoreException {
        Connection connection = null;
        try {
            try {
                connection = DbPersistence.getConnection();
                byte[] byArray = this.toByteArray(conversationState);
                this._tableAccess.doStoreByInsert(connection, conversationState.getId(), byArray, conversationState.getTimeStamp());
            }
            catch (Exception exception) {
                throw new StoreException(exception);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            DbPersistence.cleanup(connection, null);
            throw throwable;
        }
        DbPersistence.cleanup(connection, null);
    }

    public void update(ConversationState conversationState) throws StoreException {
        if (this._tableAccess == null) {
            throw new StoreException("Unable to update conversation, Table does not exist");
        }
        Connection connection = null;
        try {
            try {
                connection = DbPersistence.getConnection();
                byte[] byArray = this.toByteArray(conversationState);
                this._tableAccess.doStoreByUpdate(connection, conversationState.getId(), byArray, conversationState.getTimeStamp(), true);
            }
            catch (Exception exception) {
                throw new StoreException(exception);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            DbPersistence.cleanup(connection, null);
            throw throwable;
        }
        DbPersistence.cleanup(connection, null);
    }

    public ConversationState read(String string) throws StoreException {
        ConversationState conversationState;
        if (this._tableAccess == null) {
            throw new StoreException("Unable to read conversation, Table does not exist");
        }
        Connection connection = null;
        try {
            connection = DbPersistence.getConnection();
            LoadedObject loadedObject = this._tableAccess.doLoad(connection, string, false);
            Object object = loadedObject.getObject();
            conversationState = (ConversationState)object;
            Object var7_7 = null;
        }
        catch (Exception exception) {
            try {
                throw new StoreException(exception);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                DbPersistence.cleanup(connection, null);
                throw throwable;
            }
        }
        DbPersistence.cleanup(connection, null);
        return conversationState;
    }

    public ConversationState readForUpdate(String string) throws StoreException {
        ConversationState conversationState;
        if (this._tableAccess == null) {
            throw new StoreException("Unable to read conversation, Table does not exist");
        }
        Connection connection = null;
        try {
            connection = DbPersistence.getConnection();
            LoadedObject loadedObject = this._tableAccess.doLoad(connection, string, true);
            Object object = loadedObject.getObject();
            conversationState = (ConversationState)object;
            Object var7_7 = null;
        }
        catch (Exception exception) {
            try {
                throw new StoreException(exception);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                DbPersistence.cleanup(connection, null);
                throw throwable;
            }
        }
        DbPersistence.cleanup(connection, null);
        return conversationState;
    }

    public void delete(String string) throws StoreException {
        if (this._tableAccess == null) {
            throw new StoreException("Unable to delete conversation, Table does not exist");
        }
        Connection connection = null;
        try {
            try {
                connection = DbPersistence.getConnection();
                this._tableAccess.doRemove(connection, string);
            }
            catch (Exception exception) {
                throw new StoreException(exception);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            DbPersistence.cleanup(connection, null);
            throw throwable;
        }
        DbPersistence.cleanup(connection, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] toByteArray(Object object) throws StoreException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                byArray = byteArrayOutputStream.toByteArray();
                Object var6_6 = null;
            }
            catch (IOException iOException) {
                throw new StoreException("Unable to serialize", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                objectOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            iOException.printStackTrace();
            return byArray;
        }
        objectOutputStream.close();
        return byArray;
    }
}

