/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.conversation.database;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import weblogic.utils.io.StreamUtils;
import weblogic.wsee.jws.conversation.database.DB2TableAccess;
import weblogic.wsee.jws.conversation.database.DbPersistence;
import weblogic.wsee.jws.conversation.database.LoadedObject;
import weblogic.wsee.jws.conversation.database.TableAccess;
import weblogic.wsee.jws.util.Config;

abstract class GenericTableAccess
implements TableAccess {
    protected boolean _createOnStore = false;
    protected boolean _insertOnCreate = Config.getInsertOnCreate();
    static final String CONV_ID_COLUMN_NAME = "CG_ID";
    protected String _tableName;
    protected String _createStmt;
    protected String _createByCallableStmt;
    protected String _findStmt;
    protected String _loadStmt;
    protected String _loadStmtNoUpdateLock;
    protected String _storeStmt;
    protected String _storeByCallableStmt;
    protected String _storeLiteStmt;
    protected String _removeStmt;
    protected String _selectStmt;
    protected String _resetObjectStmt;
    protected String _selectObjectStmt;
    protected int _storeStmtIDColumn = -1;
    protected int _storeLiteStmtIDColumn = -1;

    GenericTableAccess() {
    }

    public String getTableName() {
        return this._tableName;
    }

    public void setTableName(String string) {
        this._tableName = string;
    }

    protected abstract String getCreateTableStatement();

    int getStoreStatementIDColumn() {
        if (this._storeStmtIDColumn == -1) {
            this._storeStmtIDColumn = GenericTableAccess.countQuestionMarks(this.getStoreStatement());
        }
        return this._storeStmtIDColumn;
    }

    int getStoreLiteStatementIDColumn() {
        if (this._storeLiteStmtIDColumn == -1) {
            this._storeLiteStmtIDColumn = GenericTableAccess.countQuestionMarks(this.getStoreLiteStatement());
        }
        return this._storeLiteStmtIDColumn;
    }

    private static int countQuestionMarks(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '?') continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap ensureTableCreated(Connection connection) throws SQLException {
        String string = this.getTableName();
        String string2 = this.getCreateTableStatement();
        HashMap hashMap = new HashMap();
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = connection.prepareStatement("SELECT CG_ID FROM " + string);
                preparedStatement.executeQuery();
            }
            catch (SQLException sQLException) {
                if (this instanceof DB2TableAccess && sQLException.getErrorCode() != -204) {
                    HashMap hashMap2 = hashMap;
                    Object var12_9 = null;
                    DbPersistence.cleanup(null, preparedStatement);
                    return hashMap2;
                }
                Statement statement = null;
                try {
                    statement = connection.createStatement();
                    statement.executeUpdate(string2);
                    preparedStatement = connection.prepareStatement("SELECT CG_ID FROM " + string);
                    preparedStatement.executeQuery();
                    Object var10_12 = null;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    DbPersistence.close(statement);
                    throw throwable;
                }
                DbPersistence.close(statement);
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            DbPersistence.cleanup(null, preparedStatement);
            throw throwable;
        }
        DbPersistence.cleanup(null, preparedStatement);
        return hashMap;
    }

    protected String getCreateStatement() {
        if (this._createStmt == null) {
            StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
            stringBuffer.append(this._tableName);
            stringBuffer.append(" (CG_ID, LAST_ACCESS_TIME, CG_DATA");
            stringBuffer.append(" ) VALUES (?, ?, ?");
            stringBuffer.append(")");
            this._createStmt = stringBuffer.toString();
        }
        return this._createStmt;
    }

    protected String getCreateByCallableStatement() {
        if (this._createByCallableStmt == null) {
            StringBuffer stringBuffer = new StringBuffer("BEGIN ");
            stringBuffer.append("INSERT INTO ");
            stringBuffer.append(this._tableName);
            stringBuffer.append(" (CG_ID, LAST_ACCESS_TIME, CG_DATA");
            stringBuffer.append(" ) VALUES (?, ?, EMPTY_BLOB()) RETURNING CG_DATA INTO ?; END;");
            this._createByCallableStmt = stringBuffer.toString();
        }
        return this._createByCallableStmt;
    }

    private String getFindStatement() {
        if (this._findStmt == null) {
            StringBuffer stringBuffer = new StringBuffer("SELECT CG_ID");
            stringBuffer.append(" FROM ");
            stringBuffer.append(this._tableName);
            stringBuffer.append(" WHERE CG_ID = ?");
            this._findStmt = stringBuffer.toString();
        }
        return this._findStmt;
    }

    protected String getLoadStatement(boolean bl) {
        if (this._loadStmt == null) {
            StringBuffer stringBuffer = new StringBuffer("SELECT LAST_ACCESS_TIME, CG_DATA ");
            stringBuffer.append(" FROM ");
            stringBuffer.append(this._tableName);
            stringBuffer.append(" WHERE CG_ID = ?");
            this._loadStmt = stringBuffer.toString();
        }
        return this._loadStmt;
    }

    protected String getStoreStatement() {
        if (this._storeStmt == null) {
            StringBuffer stringBuffer = new StringBuffer("UPDATE ");
            stringBuffer.append(this._tableName);
            stringBuffer.append(" SET ");
            stringBuffer.append(" LAST_ACCESS_TIME = ?, ");
            stringBuffer.append(" CG_DATA = ? ");
            stringBuffer.append(" WHERE CG_ID = ?");
            this._storeStmt = stringBuffer.toString();
        }
        return this._storeStmt;
    }

    protected String getStoreByCallableStatement() {
        if (this._storeByCallableStmt == null) {
            StringBuffer stringBuffer = new StringBuffer("BEGIN ");
            stringBuffer.append("UPDATE ");
            stringBuffer.append(this._tableName);
            stringBuffer.append(" SET LAST_ACCESS_TIME = ?,");
            stringBuffer.append(" CG_DATA = EMPTY_BLOB() ");
            stringBuffer.append(" WHERE CG_ID = ? ");
            stringBuffer.append(" RETURNING CG_DATA INTO ?");
            stringBuffer.append("; END;");
            this._storeByCallableStmt = stringBuffer.toString();
        }
        return this._storeByCallableStmt;
    }

    protected String getStoreLiteStatement() {
        if (this._storeLiteStmt == null) {
            StringBuffer stringBuffer = new StringBuffer("UPDATE ");
            stringBuffer.append(this._tableName);
            stringBuffer.append(" SET ");
            stringBuffer.append(" LAST_ACCESS_TIME = ? ");
            stringBuffer.append(" WHERE CG_ID = ?");
            this._storeLiteStmt = stringBuffer.toString();
        }
        return this._storeLiteStmt;
    }

    private String getRemoveStatement() {
        if (this._removeStmt == null) {
            StringBuffer stringBuffer = new StringBuffer("DELETE FROM ");
            stringBuffer.append(this._tableName);
            stringBuffer.append(" WHERE CG_ID = ?");
            this._removeStmt = stringBuffer.toString();
        }
        return this._removeStmt;
    }

    protected String getSelectObjectStatement() {
        return this._selectObjectStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedObject doLoad(Connection connection, String string, boolean bl) throws SQLException, IOException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block3: {
            LoadedObject loadedObject;
            preparedStatement = null;
            resultSet = null;
            try {
                LoadedObject loadedObject2;
                preparedStatement = connection.prepareStatement(this.getLoadStatement(bl));
                preparedStatement.setObject(1, string);
                preparedStatement.executeQuery();
                resultSet = preparedStatement.getResultSet();
                if (!resultSet.next()) break block3;
                loadedObject = loadedObject2 = new LoadedObject(resultSet.getLong(1), this.readByteArrayFromResultSet(resultSet, 2));
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                DbPersistence.close(resultSet);
                DbPersistence.close(preparedStatement);
                throw throwable;
            }
            DbPersistence.close(resultSet);
            DbPersistence.close(preparedStatement);
            return loadedObject;
        }
        LoadedObject loadedObject = null;
        Object var9_10 = null;
        DbPersistence.close(resultSet);
        DbPersistence.close(preparedStatement);
        return loadedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readByteArrayFromResultSet(ResultSet resultSet, int n) throws IOException, SQLException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        InputStream inputStream = null;
        byte[] byArray = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
            inputStream = resultSet.getBinaryStream(n);
            StreamUtils.writeTo((InputStream)inputStream, (OutputStream)bufferedOutputStream);
            bufferedOutputStream.flush();
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            DbPersistence.close(byteArrayOutputStream);
            DbPersistence.close(bufferedOutputStream);
            DbPersistence.close(inputStream);
            throw throwable;
        }
        DbPersistence.close(byteArrayOutputStream);
        DbPersistence.close(bufferedOutputStream);
        DbPersistence.close(inputStream);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doStoreByInsert(Connection connection, String string, byte[] byArray, long l) throws SQLException, IOException {
        boolean bl;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.getCreateStatement());
            preparedStatement.setObject(1, string);
            preparedStatement.setLong(2, l);
            this.writeByteArrayToStatement(preparedStatement, 3, byArray);
            bl = preparedStatement.executeUpdate() == 1;
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            DbPersistence.close(preparedStatement);
            throw throwable;
        }
        DbPersistence.close(preparedStatement);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doStoreByUpdate(Connection connection, String string, byte[] byArray, long l, boolean bl) throws SQLException, IOException {
        boolean bl2;
        PreparedStatement preparedStatement = null;
        String string2 = null;
        string2 = bl ? this.getStoreStatement() : this.getStoreLiteStatement();
        try {
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setLong(1, l);
            int n = 0;
            if (bl) {
                this.writeByteArrayToStatement(preparedStatement, 2, byArray);
                n = this.getStoreStatementIDColumn();
            } else {
                n = this.getStoreLiteStatementIDColumn();
            }
            preparedStatement.setObject(n, string);
            bl2 = preparedStatement.executeUpdate() > 0;
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            DbPersistence.close(preparedStatement);
            throw throwable;
        }
        DbPersistence.close(preparedStatement);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doRemove(Connection connection, String string) throws SQLException {
        boolean bl;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.getRemoveStatement());
            preparedStatement.setObject(1, string);
            bl = preparedStatement.executeUpdate() > 0;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            DbPersistence.close(preparedStatement);
            throw throwable;
        }
        DbPersistence.close(preparedStatement);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeByteArrayToStatement(PreparedStatement preparedStatement, int n, byte[] byArray) throws SQLException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            preparedStatement.setBinaryStream(n, (InputStream)byteArrayInputStream, byArray.length);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            DbPersistence.close(byteArrayInputStream);
            throw throwable;
        }
        DbPersistence.close(byteArrayInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean keyExists(Connection connection, String string) throws SQLException {
        boolean bl;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.getFindStatement());
            preparedStatement.setObject(1, string);
            preparedStatement.executeQuery();
            resultSet = preparedStatement.getResultSet();
            bl = resultSet.next();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            DbPersistence.close(resultSet);
            DbPersistence.close(preparedStatement);
            throw throwable;
        }
        DbPersistence.close(resultSet);
        DbPersistence.close(preparedStatement);
        return bl;
    }
}

