/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.conversation.database;

import weblogic.wsee.jws.conversation.database.GenericTableAccess;
import weblogic.wsee.jws.util.Config;

class MsSqlServerTableAccess
extends GenericTableAccess {
    MsSqlServerTableAccess() {
    }

    protected String getCreateTableStatement() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE " + this._tableName + "(");
        stringBuffer.append("CG_ID varchar(" + Config.getProperty("weblogic.jws.ConversationMaxKeyLength") + ") NOT NULL PRIMARY KEY,");
        stringBuffer.append("LAST_ACCESS_TIME bigint, ");
        stringBuffer.append("CG_DATA IMAGE");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected String getLoadStatement(boolean bl) {
        if (bl && this._loadStmt != null) {
            return this._loadStmt;
        }
        if (!bl && this._loadStmtNoUpdateLock != null) {
            return this._loadStmtNoUpdateLock;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT LAST_ACCESS_TIME, CG_DATA ");
        stringBuffer.append(" FROM " + this._tableName);
        if (bl) {
            stringBuffer.append(" WITH (UPDLOCK)");
        }
        stringBuffer.append(" WHERE CG_ID = ?");
        if (bl) {
            this._loadStmt = stringBuffer.toString();
            return this._loadStmt;
        }
        this._loadStmtNoUpdateLock = stringBuffer.toString();
        return this._loadStmtNoUpdateLock;
    }

    protected String getStoreStatement() {
        if (this._storeStmt == null) {
            StringBuffer stringBuffer = new StringBuffer("UPDATE ");
            stringBuffer.append(this._tableName);
            stringBuffer.append(" WITH (UPDLOCK) SET ");
            stringBuffer.append(" LAST_ACCESS_TIME = ?, ");
            stringBuffer.append(" CG_DATA = ? ");
            stringBuffer.append(" WHERE CG_ID = ?");
            this._storeStmt = stringBuffer.toString();
        }
        return this._storeStmt;
    }

    protected String getStoreLiteStatement() {
        if (this._storeLiteStmt == null) {
            StringBuffer stringBuffer = new StringBuffer("UPDATE ");
            stringBuffer.append(this._tableName);
            stringBuffer.append(" WITH (UPDLOCK) SET ");
            stringBuffer.append(" LAST_ACCESS_TIME = ? ");
            stringBuffer.append(" WHERE CG_ID = ?");
            this._storeLiteStmt = stringBuffer.toString();
        }
        return this._storeLiteStmt;
    }
}

