/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.conversation.database;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import weblogic.jdbc.vendor.oracle.OracleThinBlob;
import weblogic.wsee.jws.conversation.database.DbPersistence;
import weblogic.wsee.jws.conversation.database.GenericTableAccess;
import weblogic.wsee.jws.conversation.database.LoadedObject;
import weblogic.wsee.jws.util.Config;

class OracleTableAccess
extends GenericTableAccess {
    OracleTableAccess() {
    }

    public String getCreateTableStatement() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE " + this._tableName + "(");
        stringBuffer.append("CG_ID");
        stringBuffer.append(" varchar(");
        stringBuffer.append(Config.getProperty("weblogic.jws.ConversationMaxKeyLength"));
        stringBuffer.append(") not null,");
        stringBuffer.append("LAST_ACCESS_TIME number(19,0), ");
        stringBuffer.append("CG_DATA BLOB");
        stringBuffer.append(", PRIMARY KEY (CG_ID) )");
        stringBuffer.append(" INITRANS 6");
        return stringBuffer.toString();
    }

    protected String getCreateStatement() {
        if (this._createStmt == null) {
            StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
            stringBuffer.append(this._tableName);
            stringBuffer.append(" (CG_ID, LAST_ACCESS_TIME, CG_DATA");
            stringBuffer.append(" ) VALUES (?, ?, EMPTY_BLOB()");
            stringBuffer.append(")");
            this._createStmt = stringBuffer.toString();
        }
        return this._createStmt;
    }

    protected String getSelectObjectStatement() {
        if (this._selectObjectStmt == null) {
            StringBuffer stringBuffer = new StringBuffer("SELECT CG_DATA FROM ");
            stringBuffer.append(this._tableName);
            stringBuffer.append(" WHERE CG_ID = ? ");
            stringBuffer.append("FOR UPDATE");
            this._selectObjectStmt = stringBuffer.toString();
        }
        return this._selectObjectStmt;
    }

    protected String getLoadStatement(boolean bl) {
        if (bl && this._loadStmt != null) {
            return this._loadStmt;
        }
        if (!bl && this._loadStmtNoUpdateLock != null) {
            return this._loadStmtNoUpdateLock;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        stringBuffer.append("/*+ FIRST_ROWS(1) */");
        stringBuffer.append("LAST_ACCESS_TIME, CG_DATA ");
        stringBuffer.append(" FROM ");
        stringBuffer.append(this._tableName);
        stringBuffer.append(" WHERE CG_ID = ?");
        if (bl) {
            stringBuffer.append(" FOR UPDATE");
            this._loadStmt = stringBuffer.toString();
            return this._loadStmt;
        }
        this._loadStmtNoUpdateLock = stringBuffer.toString();
        return this._loadStmtNoUpdateLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedObject doLoad(Connection connection, String string, boolean bl) throws SQLException, IOException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block3: {
            LoadedObject loadedObject;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.getLoadStatement(bl));
                preparedStatement.setObject(1, string);
                preparedStatement.executeQuery();
                resultSet = preparedStatement.getResultSet();
                if (!resultSet.next()) break block3;
                loadedObject = new LoadedObject(resultSet.getLong(1), this.readByteArrayFromResultSet(resultSet, 2));
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                DbPersistence.close(resultSet);
                DbPersistence.close(preparedStatement);
                throw throwable;
            }
            DbPersistence.close(resultSet);
            DbPersistence.close(preparedStatement);
            return loadedObject;
        }
        LoadedObject loadedObject = null;
        Object var8_9 = null;
        DbPersistence.close(resultSet);
        DbPersistence.close(preparedStatement);
        return loadedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readByteArrayFromResultSet(ResultSet resultSet, int n) throws IOException, SQLException {
        Blob blob = null;
        int n2 = -1;
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byArray = null;
        try {
            blob = resultSet.getBlob(n);
            n2 = (int)blob.length();
            byteArrayOutputStream = new ByteArrayOutputStream(n2);
            byteArrayOutputStream.write(blob.getBytes(1L, n2), 0, n2);
            byArray = byteArrayOutputStream.toByteArray();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            DbPersistence.close(byteArrayOutputStream);
            throw throwable;
        }
        DbPersistence.close(byteArrayOutputStream);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doStoreByInsert(Connection connection, String string, byte[] byArray, long l) throws SQLException, IOException {
        boolean bl;
        Blob blob = null;
        OutputStream outputStream = null;
        CallableStatement callableStatement = null;
        boolean bl2 = false;
        try {
            callableStatement = connection.prepareCall(this.getCreateByCallableStatement());
            callableStatement.setString(1, string);
            callableStatement.setLong(2, l);
            callableStatement.registerOutParameter(3, 2004);
            if (callableStatement.executeUpdate() == 1) {
                blob = callableStatement.getBlob(3);
                outputStream = blob instanceof OracleThinBlob ? ((OracleThinBlob)blob).getBinaryOutputStream() : blob.setBinaryStream(1L);
                outputStream.write(byArray);
                outputStream.flush();
                outputStream.close();
                outputStream = null;
                bl2 = true;
            }
            bl = bl2;
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            DbPersistence.close(outputStream);
            DbPersistence.close(callableStatement);
            throw throwable;
        }
        DbPersistence.close(outputStream);
        DbPersistence.close(callableStatement);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean doStoreByUpdate(Connection var1_1, String var2_2, byte[] var3_3, long var4_4, boolean var6_5) throws SQLException, IOException {
        var7_6 = null;
        var8_7 = null;
        var9_8 = null;
        var10_9 = null;
        var11_10 = null;
        var12_11 = null;
        var13_12 = false;
        try {
            if (var6_5) {
                var8_7 = var1_1.prepareCall(this.getStoreByCallableStatement());
                var8_7.setLong(1, var4_4);
                var8_7.setString(2, var2_2);
                var8_7.registerOutParameter(3, 2004);
                if (var8_7.executeUpdate() == 1) {
                    var7_6 = var8_7.getBlob(3);
                    try {
                        var9_8 = var7_6 instanceof OracleThinBlob != false ? ((OracleThinBlob)var7_6).getBinaryOutputStream() : var7_6.setBinaryStream(1L);
                        var9_8.write(var3_3);
                        var9_8.flush();
                        var9_8.close();
                        var9_8 = null;
                        var13_12 = true;
                    }
                    catch (SQLException var14_13) {
                        if (var14_13.getErrorCode() == 22275) {
                            var11_10 = var1_1.prepareStatement(this.getSelectObjectStatement());
                            var11_10.setString(1, var2_2);
                            var11_10.executeQuery();
                            var12_11 = var11_10.getResultSet();
                            if (!var12_11.next()) ** GOTO lbl41
                            throw var14_13;
                        }
                        throw var14_13;
                    }
                }
            } else {
                var14_14 = 0;
                var10_9 = var1_1.prepareStatement(this.getStoreLiteStatement());
                var10_9.setLong(1, var4_4);
                var14_14 = this.getStoreLiteStatementIDColumn();
                var10_9.setObject(var14_14, var2_2);
                var13_12 = var10_9.executeUpdate() > 0;
            }
lbl41:
            // 4 sources

            var14_15 = var13_12;
            var16_16 = null;
        }
        catch (Throwable var15_18) {
            var16_17 = null;
            DbPersistence.close(var9_8);
            DbPersistence.close(var8_7);
            DbPersistence.close(var10_9);
            DbPersistence.close(var12_11);
            DbPersistence.close(var11_10);
            throw var15_18;
        }
        DbPersistence.close(var9_8);
        DbPersistence.close(var8_7);
        DbPersistence.close(var10_9);
        DbPersistence.close(var12_11);
        DbPersistence.close(var11_10);
        return var14_15;
    }
}

