/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.jaxrpc;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JAnnotationValue;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JElement;
import com.bea.xml.XmlException;
import com.sun.java.xml.ns.j2Ee.ParamValueType;
import com.sun.java.xml.ns.j2Ee.PortComponentHandlerType;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import weblogic.j2ee.descriptor.EnvEntryBean;
import weblogic.j2ee.descriptor.ParamValueBean;
import weblogic.j2ee.descriptor.PortComponentBean;
import weblogic.j2ee.descriptor.PortComponentHandlerBean;
import weblogic.wsee.jws.HandlerException;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.wseegen.schemas.HandlerChainType;
import weblogic.wsee.tools.wseegen.schemas.HandlerConfig;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.UniqueNameSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerChainDecl
extends weblogic.wsee.jws.HandlerChainDecl<HandlerChainType> {
    public HandlerChainDecl(JClass jClass, JClass jClass2) {
        super(jClass, jClass2);
    }

    protected HandlerChainType[] processSOAPMessageHandlers(JClass jClass, JAnnotation jAnnotation) {
        JAnnotationValue jAnnotationValue = jAnnotation.getValue("value");
        if (jAnnotationValue == null) {
            return null;
        }
        JAnnotation[] jAnnotationArray = jAnnotationValue.asAnnotationArray();
        HandlerChainType handlerChainType = HandlerChainType.Factory.newInstance();
        UniqueNameSet uniqueNameSet = new UniqueNameSet();
        if (jAnnotationArray != null) {
            for (JAnnotation jAnnotation2 : jAnnotationArray) {
                String[] stringArray;
                ParamValueType paramValueType;
                int n;
                JAnnotationValue jAnnotationValue2;
                JAnnotationValue jAnnotationValue3;
                PortComponentHandlerType portComponentHandlerType = handlerChainType.addNewHandler();
                String string = "";
                JAnnotationValue jAnnotationValue4 = jAnnotation2.getValue("className");
                if (jAnnotationValue4 != null) {
                    string = jAnnotationValue4.asString();
                }
                portComponentHandlerType.addNewHandlerClass().setStringValue(string);
                JAnnotationValue jAnnotationValue5 = jAnnotation2.getValue("name");
                String string2 = !StringUtil.isEmpty(jAnnotationValue5.asString()) ? uniqueNameSet.add(jAnnotationValue5.asString()) : uniqueNameSet.add(string);
                portComponentHandlerType.addNewHandlerName().setStringValue(string2);
                JAnnotationValue jAnnotationValue6 = jAnnotation2.getValue("initParams");
                if (jAnnotationValue6 != null && (jAnnotationValue3 = jAnnotationValue6.asAnnotationArray()) != null) {
                    jAnnotationValue2 = jAnnotationValue3;
                    int n2 = ((JAnnotationValue)jAnnotationValue2).length;
                    for (n = 0; n < n2; ++n) {
                        JAnnotationValue jAnnotationValue7 = jAnnotationValue2[n];
                        paramValueType = portComponentHandlerType.addNewInitParam();
                        paramValueType.addNewParamName().setStringValue(jAnnotationValue7.getValue("name").asString());
                        paramValueType.addNewParamValue().setStringValue(jAnnotationValue7.getValue("value").asString());
                    }
                }
                if ((jAnnotationValue3 = jAnnotation2.getValue("roles")) != null) {
                    JAnnotationValue jAnnotationValue8 = jAnnotationValue2 = jAnnotationValue3.asStringArray();
                    n = ((JAnnotationValue)jAnnotationValue8).length;
                    for (int i = 0; i < n; ++i) {
                        paramValueType = jAnnotationValue8[i];
                        portComponentHandlerType.addNewSoapRole().setStringValue((String)paramValueType);
                    }
                }
                if ((jAnnotationValue2 = jAnnotation2.getValue("headers")) == null) continue;
                for (String string3 : stringArray = jAnnotationValue2.asStringArray()) {
                    portComponentHandlerType.addNewSoapHeader().setQNameValue(QName.valueOf(string3));
                }
            }
        }
        return new HandlerChainType[]{handlerChainType};
    }

    protected HandlerChainType[] processHandlerChain(JClass jClass, URL uRL, String string) {
        try {
            HandlerChainType[] handlerChainTypeArray;
            HandlerConfig handlerConfig = HandlerConfig.Factory.parse(uRL);
            handlerConfig.validate();
            for (HandlerChainType handlerChainType : handlerChainTypeArray = handlerConfig.getHandlerConfig().getHandlerChainArray()) {
                if (handlerChainType.getHandlerChainName() == null || !handlerChainType.getHandlerChainName().getStringValue().equals(string.trim())) continue;
                return new HandlerChainType[]{handlerChainType};
            }
            this.addLogEvent(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.handlerChain.chainNotFound", string, uRL));
        }
        catch (XmlException xmlException) {
            this.addLogEvent(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.handlerChain.chainFileNotValid", uRL, xmlException.getMessage()));
        }
        catch (IOException iOException) {
            this.addLogEvent(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.handlerChain.chainFileParseError", uRL, iOException.getMessage()));
        }
        return null;
    }

    @Override
    public void populatePort(PortComponentBean portComponentBean, EnvEntryBean[] envEntryBeanArray) {
        if (this.getHandlerChains() == null) {
            return;
        }
        for (HandlerChainType handlerChainType : (HandlerChainType[])this.getHandlerChains()) {
            for (PortComponentHandlerType portComponentHandlerType : handlerChainType.getHandlerArray()) {
                ParamValueBean paramValueBean;
                if (portComponentHandlerType.getHandlerName() == null) {
                    throw new HandlerException("Could not locate handler in Handler Chain:  " + handlerChainType.getHandlerChainName().getStringValue() + ". Handler Config file might be missing j2ee namespace. ");
                }
                PortComponentHandlerBean portComponentHandlerBean = portComponentBean.createHandler();
                portComponentHandlerBean.setHandlerName(portComponentHandlerType.getHandlerName().getStringValue());
                portComponentHandlerBean.setHandlerClass(portComponentHandlerType.getHandlerClass().getStringValue());
                for (ParamValueType paramValueType : portComponentHandlerType.getInitParamArray()) {
                    paramValueBean = portComponentHandlerBean.createInitParam();
                    paramValueBean.setParamName(paramValueType.getParamName().getStringValue());
                    paramValueBean.setParamValue(paramValueType.getParamValue().getStringValue());
                }
                for (ParamValueType paramValueType : portComponentHandlerType.getSoapHeaderArray()) {
                    portComponentHandlerBean.addSoapHeader(paramValueType.getQNameValue());
                }
                for (ParamValueType paramValueType : portComponentHandlerType.getSoapRoleArray()) {
                    portComponentHandlerBean.addSoapRole(paramValueType.getStringValue());
                }
                if (envEntryBeanArray == null) continue;
                for (ParamValueType paramValueType : envEntryBeanArray) {
                    paramValueBean = portComponentHandlerBean.createEnvEntry();
                    paramValueBean.setEnvEntryName(paramValueType.getEnvEntryName());
                    paramValueBean.setEnvEntryType(paramValueType.getEnvEntryType());
                    paramValueBean.setEnvEntryValue(paramValueType.getEnvEntryValue());
                }
            }
        }
    }

    @Override
    public String[] getHandlerClassNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        HandlerChainType[] handlerChainTypeArray = (HandlerChainType[])this.getHandlerChains();
        if (handlerChainTypeArray != null) {
            for (HandlerChainType handlerChainType : handlerChainTypeArray) {
                for (PortComponentHandlerType portComponentHandlerType : handlerChainType.getHandlerArray()) {
                    try {
                        arrayList.add(portComponentHandlerType.getHandlerClass().getStringValue());
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new HandlerException("Could not parse a handler for chain [" + handlerChainType.getHandlerChainName() + "], Pls. check the validity of the chain configuration file");
                    }
                }
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

