/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.jaxws;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JElement;
import com.bea.xml.XmlException;
import com.sun.java.xml.ns.javaee.HandlerChainType;
import com.sun.java.xml.ns.javaee.HandlerChainsDocument;
import com.sun.java.xml.ns.javaee.PortComponentHandlerType;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.w3c.dom.Node;
import weblogic.j2ee.dd.xml.J2eeAnnotationProcessor;
import weblogic.j2ee.descriptor.EnvEntryBean;
import weblogic.j2ee.descriptor.HandlerChainBean;
import weblogic.j2ee.descriptor.HandlerChainsBean;
import weblogic.j2ee.descriptor.J2eeClientEnvironmentBean;
import weblogic.j2ee.descriptor.PortComponentBean;
import weblogic.j2ee.descriptor.PortComponentHandlerBean;
import weblogic.wsee.jws.HandlerException;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerChainDecl
extends weblogic.wsee.jws.HandlerChainDecl<HandlerChainType> {
    public HandlerChainDecl(JClass jClass, JClass jClass2) {
        super(jClass, jClass2);
    }

    public HandlerChainDecl(JClass jClass, JClass jClass2, ClassLoader classLoader) {
        super(jClass, jClass2, classLoader);
    }

    protected HandlerChainType[] processSOAPMessageHandlers(JClass jClass, JAnnotation jAnnotation) {
        this.addLogEvent(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.handlerChain.jaxws.soapMessageHandlersNotSupported", jClass.getQualifiedName()));
        return null;
    }

    protected HandlerChainType[] processHandlerChain(JClass jClass, URL uRL, String string) {
        if (!StringUtil.isEmpty(string)) {
            this.addLogEvent(EventLevel.WARNING, new JwsLogEvent((JElement)jClass, "type.handlerChain.jaxws.nameSpecified", jClass.getQualifiedName()));
        }
        try {
            HandlerChainsDocument handlerChainsDocument = HandlerChainsDocument.Factory.parse((URL)uRL);
            handlerChainsDocument.validate();
            return handlerChainsDocument.getHandlerChains().getHandlerChainArray();
        }
        catch (XmlException xmlException) {
            this.addLogEvent(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.handlerChain.chainFileNotValid", uRL, xmlException.getMessage()));
        }
        catch (IOException iOException) {
            this.addLogEvent(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.handlerChain.chainFileParseError", uRL, iOException.getMessage()));
        }
        return null;
    }

    @Override
    public void populatePort(PortComponentBean portComponentBean, EnvEntryBean[] envEntryBeanArray) {
        if (this.getHandlerChains() == null) {
            return;
        }
        if (portComponentBean.getHandlerChains() != null) {
            return;
        }
        HandlerChainsBean handlerChainsBean = portComponentBean.createHandlerChains();
        for (HandlerChainType handlerChainType : (HandlerChainType[])this.getHandlerChains()) {
            PortComponentHandlerType[] portComponentHandlerTypeArray;
            HandlerChainBean handlerChainBean = handlerChainsBean.createHandlerChain();
            if (handlerChainType.xgetPortNamePattern() == null) {
                handlerChainBean.setPortNamePattern(handlerChainType.getPortNamePattern());
            } else {
                portComponentHandlerTypeArray = handlerChainType.xgetPortNamePattern().getDomNode();
                handlerChainBean.setPortNamePattern(this.getQualifiedNamePattern((Node)portComponentHandlerTypeArray));
            }
            if (handlerChainType.getProtocolBindings() != null) {
                handlerChainBean.setProtocolBindings(handlerChainType.getProtocolBindings().toString());
            }
            if (handlerChainType.xgetServiceNamePattern() == null) {
                handlerChainBean.setServiceNamePattern(handlerChainType.getServiceNamePattern());
            } else {
                portComponentHandlerTypeArray = handlerChainType.xgetServiceNamePattern().getDomNode();
                handlerChainBean.setServiceNamePattern(this.getQualifiedNamePattern((Node)portComponentHandlerTypeArray));
            }
            for (PortComponentHandlerType portComponentHandlerType : handlerChainType.getHandlerArray()) {
                PortComponentHandlerBean portComponentHandlerBean = handlerChainBean.createHandler();
                if (portComponentHandlerType.getHandlerName() != null) {
                    portComponentHandlerBean.setHandlerName(portComponentHandlerType.getHandlerName().getStringValue());
                }
                portComponentHandlerBean.setHandlerClass(portComponentHandlerType.getHandlerClass().getStringValue());
                for (int i = 0; i < portComponentHandlerType.sizeOfSoapRoleArray(); ++i) {
                    portComponentHandlerBean.addSoapRole(portComponentHandlerType.getSoapRoleArray(i).getStringValue());
                }
                if (envEntryBeanArray != null) {
                    for (EnvEntryBean envEntryBean : envEntryBeanArray) {
                        EnvEntryBean envEntryBean2 = portComponentHandlerBean.createEnvEntry();
                        envEntryBean2.setEnvEntryName(envEntryBean.getEnvEntryName());
                        envEntryBean2.setEnvEntryType(envEntryBean.getEnvEntryType());
                        envEntryBean2.setEnvEntryValue(envEntryBean.getEnvEntryValue());
                    }
                }
                this.processAnnotations(portComponentHandlerType, portComponentHandlerBean);
            }
        }
    }

    private String getQualifiedNamePattern(Node node) {
        int n;
        String string;
        if (node == null || node.getFirstChild() == null) {
            return null;
        }
        String string2 = string = node.getFirstChild().getNodeValue();
        if (string != null && (n = string.indexOf(":")) > 0) {
            String string3 = "xmlns:" + string.substring(0, n);
            String string4 = null;
            for (Node node2 = node; node2 != null && (node2.getAttributes() == null || node2.getAttributes().getNamedItem(string3) == null || (string4 = node2.getAttributes().getNamedItem(string3).getNodeValue()) == null); node2 = node2.getParentNode()) {
            }
            if (string4 != null) {
                string2 = "{" + string4 + "}" + string.substring(n + 1);
            }
        }
        return string2;
    }

    private void processAnnotations(PortComponentHandlerType portComponentHandlerType, PortComponentHandlerBean portComponentHandlerBean) {
        try {
            Class<?> clazz = Class.forName(portComponentHandlerType.getHandlerClass().getStringValue(), true, Thread.currentThread().getContextClassLoader());
            J2eeAnnotationProcessor j2eeAnnotationProcessor = new J2eeAnnotationProcessor();
            j2eeAnnotationProcessor.processJ2eeAnnotations(clazz, (J2eeClientEnvironmentBean)portComponentHandlerBean);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HandlerException(classNotFoundException);
        }
    }

    @Override
    public String[] getHandlerClassNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        HandlerChainType[] handlerChainTypeArray = (HandlerChainType[])this.getHandlerChains();
        if (handlerChainTypeArray != null) {
            for (HandlerChainType handlerChainType : handlerChainTypeArray) {
                for (PortComponentHandlerType portComponentHandlerType : handlerChainType.getHandlerArray()) {
                    arrayList.add(portComponentHandlerType.getHandlerClass().getStringValue());
                }
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

