/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import weblogic.management.DomainDir;

public class JwsProperties {
    public static final String TESTCONSOLE_PROPNAME = "wlw.testConsole";
    public static final String ITERATIVEDEV_PROPNAME = "wlw.iterativeDev";
    public static final String LOG_ERRORS_TO_CONSOLE_PROPNAME = "wlw.logErrorsToConsole";
    public static final String CONFIG_FILENAME = "jws-config.properties";
    protected static Properties _systemProps = System.getProperties();
    protected static Properties _fileProps;
    protected static Properties _defaultProps;
    protected static Boolean _insertOnCreate;
    public static final String DebugTransactionTimeout = "weblogic.jws.DebugTransactionTimeout";
    public static final String DebugTransactionTimeout_default = "43200";
    public static final String CgDataBlobSize = "weblogic.jws.cgdata.size";
    public static final String CgDataBlobSize_Default = "1M";
    public static final String InternalJMSServer = "weblogic.jws.InternalJMSServer";
    public static final String InternalJMSServer_default = "cgJMSServer";
    public static final String InternalJMSConnFactory = "weblogic.jws.InternalJMSConnFactory";
    public static final String InternalJMSConnFactory_default = "weblogic.jws.jms.QueueConnectionFactory";
    public static final String ConversationDataSource = "weblogic.jws.ConversationDataSource";
    public static final String ConversationDataSource_default = "cgDataSource";
    public static final String JMSControlDataSource = "weblogic.jws.JMSControlDataSource";
    public static final String JMSControlDataSource_default = "cgDataSource";
    public static final String ConversationMaxKeyLength = "weblogic.jws.ConversationMaxKeyLength";
    public static String ConversationMaxKeyLength_default;
    public static final String SybaseConversationMaxKeyLength_default = "300";
    public static final String MSSqlServerConversationMaxKeyLength_default = "550";
    public static final String DB2ConversationMaxKeyLength_default = "600";
    public static final String InsertOnCreate = "weblogic.jws.InsertOnCreate";
    public static final String InsertOnCreate_default = "false";

    protected static void setPropertiesFromConfigFile(File file) {
        _defaultProps = new Properties();
        _defaultProps.setProperty(InternalJMSServer, InternalJMSServer_default);
        _defaultProps.setProperty(InternalJMSConnFactory, InternalJMSConnFactory_default);
        _defaultProps.setProperty(ConversationDataSource, "cgDataSource");
        _defaultProps.setProperty(CgDataBlobSize, CgDataBlobSize_Default);
        _defaultProps.setProperty(JMSControlDataSource, "cgDataSource");
        _defaultProps.setProperty(DebugTransactionTimeout, DebugTransactionTimeout_default);
        _defaultProps.setProperty(InsertOnCreate, InsertOnCreate_default);
        _fileProps = new Properties(_defaultProps);
        try {
            File file2 = new File(file, CONFIG_FILENAME);
            JwsProperties.loadProps(_fileProps, file2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void loadProps(Properties properties, File file) throws IOException {
        if (!file.exists()) return;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            Object var4_3 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fileInputStream == null) throw throwable;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
    }

    public static String getProperty(String string) {
        String string2 = JwsProperties.getSystemProperty(string);
        if (string2 == null) {
            string2 = JwsProperties.getJwsProperty(string);
        }
        return string2;
    }

    protected static String getSystemProperty(String string) {
        return _systemProps.getProperty(string);
    }

    protected static String getJwsProperty(String string) {
        if (_fileProps != null) {
            return _fileProps.getProperty(string);
        }
        return _defaultProps.getProperty(string);
    }

    public static Boolean getPropertyAsBoolean(String string) {
        return Boolean.valueOf(JwsProperties.getProperty(string));
    }

    public static boolean iterativeDevDisabled() {
        boolean bl = false;
        String string = JwsProperties.getProperty(ITERATIVEDEV_PROPNAME);
        if (string != null && string.equalsIgnoreCase("true")) {
            bl = true;
        }
        return !bl;
    }

    public static String getStackTraceForMessages(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        if (JwsProperties.iterativeDevDisabled()) {
            stringWriter.write(throwable.getMessage());
        } else {
            throwable.printStackTrace(new PrintWriter(stringWriter));
        }
        return stringWriter.toString();
    }

    public static boolean testConsoleDisabled() {
        boolean bl = false;
        String string = JwsProperties.getProperty(TESTCONSOLE_PROPNAME);
        if (string != null && string.equalsIgnoreCase("true")) {
            bl = true;
        }
        return !bl;
    }

    public static synchronized boolean getInsertOnCreate() {
        if (_insertOnCreate == null) {
            _insertOnCreate = JwsProperties.getPropertyAsBoolean(InsertOnCreate);
        }
        return _insertOnCreate;
    }

    static {
        ConversationMaxKeyLength_default = "768";
        JwsProperties.setPropertiesFromConfigFile(new File(DomainDir.getRootDir()));
    }
}

