/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import weblogic.utils.io.StreamUtils;
import weblogic.wsee.jws.util.Config;
import weblogic.wsee.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    public static final int DB_TYPE_UNKNOWN = 0;
    public static final int DB_TYPE_ORACLE = 1;
    public static final int DB_TYPE_CLOUDSCAPE = 2;
    public static final int DB_TYPE_POINTBASE = 3;
    public static final int DB_TYPE_SQLSERVER = 4;
    public static final int DB_TYPE_SYBASE = 5;
    public static final int DB_TYPE_DB2 = 6;
    private static Map _datasources = new Hashtable();
    private static char[] specialChars = new char[]{'&', '<', '>'};
    private static String[] predEntities = new String[]{"&amp;", "&lt;", "&gt;"};

    public static String cleanURL(URL uRL) {
        if (uRL == null) {
            return "";
        }
        String string = uRL.getUserInfo();
        return string != null ? uRL.toString().replaceFirst(string, "xxxxx:xxxxx") : uRL.toString();
    }

    public static Map parseQueryString(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl = string == null;
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (!bl) {
            int n4;
            n2 = string.indexOf(38, n);
            if (n2 == 0) {
                ++n;
                continue;
            }
            if (n2 < 0) {
                n2 = string.length();
                bl = true;
            }
            if ((n4 = string.indexOf(61, n)) < 0 || n4 > n2) {
                throw new RuntimeException("Missing value:" + string);
            }
            String string2 = string.substring(n, n4);
            String string3 = string.substring(n4 + 1, n2);
            hashMap.put(string2, string3);
            if (n2 >= n3) {
                bl = true;
                continue;
            }
            n = n2 + 1;
        }
        return hashMap;
    }

    public static int computeArrayDimensions(Class clazz) {
        Class<?> clazz2 = clazz;
        int n = 0;
        while (clazz2.isArray()) {
            ++n;
            clazz2 = clazz2.getComponentType();
        }
        return n;
    }

    public static String escapeJavaString(String string) {
        if (string.indexOf(92) < 0 && string.indexOf(34) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("\\\"");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String encodeXML(String string) {
        return Util.encodeXML(string, specialChars, predEntities);
    }

    public static String encodeXML(String string, char[] cArray, String[] stringArray) {
        char c;
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            n = string.charAt(i);
            for (c = '\u0000'; c < cArray.length; ++c) {
                if (n != cArray[c]) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (!bl) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            int n3 = 0;
            for (n3 = 0; n3 < cArray.length; ++n3) {
                if (c != cArray[n3]) continue;
                stringBuffer.append(stringArray[n3]);
                break;
            }
            if (n3 < cArray.length) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String stdDateFormat(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        return simpleDateFormat.format(new Date(l));
    }

    public static String stdDateFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        return simpleDateFormat.format(new Date());
    }

    public static InputStream loadResourceStream(String string) {
        InputStream inputStream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        inputStream = classLoader.getResourceAsStream(string);
        return inputStream;
    }

    public static byte[] loadResourceBinary(String string) throws IOException {
        byte[] byArray = null;
        InputStream inputStream = Util.loadResourceStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        int n = bufferedInputStream.available();
        byArray = new byte[n];
        if (n > 0) {
            bufferedInputStream.read(byArray, 0, n);
        }
        return byArray;
    }

    public static String loadResourceString(String string) throws IOException {
        String string2 = "";
        String string3 = null;
        InputStream inputStream = Util.loadResourceStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string3 = bufferedReader.readLine()) != null) {
            string2 = string2 + string3 + "\n";
        }
        return string2;
    }

    public static File createTempDir(String string, String string2) throws IOException {
        File file = File.createTempFile(string, string2);
        file.delete();
        file.mkdirs();
        file.deleteOnExit();
        return file;
    }

    public static void copyTextFile(String string, String string2) throws IOException {
        int n;
        FileReader fileReader = new FileReader(string);
        FileWriter fileWriter = new FileWriter(string2);
        while ((n = fileReader.read()) != -1) {
            fileWriter.write(n);
        }
        fileReader.close();
        fileWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyStream(InputStream inputStream, File file) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            StreamUtils.writeTo((InputStream)inputStream, (OutputStream)fileOutputStream);
            fileOutputStream.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            fileOutputStream = null;
            file.delete();
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void copyReader(Reader reader, Writer writer) throws IOException {
        int n = 8192;
        char[] cArray = new char[n];
        int n2 = 0;
        while ((n2 = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n2);
        }
    }

    public static void copyBinaryFile(File file, File file2) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        StreamUtils.writeTo((InputStream)bufferedInputStream, (OutputStream)bufferedOutputStream);
        bufferedInputStream.close();
        bufferedOutputStream.close();
    }

    public static String replaceDollarSign(String string) {
        if (string == null) {
            return "";
        }
        return string.replace('$', '.');
    }

    public static String arrayToString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray == null) {
            stringBuffer.append("null");
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append("[" + i + "]=" + objectArray[i]);
            }
        }
        return stringBuffer.toString();
    }

    public static void recursiveCopy(File file, File file2) throws IOException {
        assert (file2.exists()) : "Dest " + file2 + " does not exist!";
        assert (file2.isDirectory()) : "Dest " + file2 + " must be a dir!";
        if (!file.exists()) {
            return;
        }
        file = file.getCanonicalFile();
        String string = file.getName();
        File file3 = new File(file2, string);
        if (file.isFile()) {
            Util.copyBinaryFile(file, file3);
        } else if (file.isDirectory()) {
            file3.mkdirs();
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                Util.recursiveCopy(fileArray[i], file3);
            }
        } else assert (false) : "File " + file + "is neither a normal file or dir!";
    }

    public static void recursiveDelete(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                Util.recursiveDelete(new File(file, stringArray[i]));
            }
        }
        file.delete();
    }

    public static void recursivePrint(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        System.out.println(file.getPath());
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                Util.recursivePrint(new File(file, stringArray[i]));
            }
        }
    }

    public static Class getObjectTypeFromPrimitiveType(Class clazz) {
        if (clazz.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (clazz.equals(Character.TYPE)) {
            return Character.class;
        }
        if (clazz.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (clazz.equals(Short.TYPE)) {
            return Short.class;
        }
        if (clazz.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (clazz.equals(Long.TYPE)) {
            return Long.class;
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.class;
        }
        if (clazz.equals(Double.TYPE)) {
            return Double.class;
        }
        return null;
    }

    public static Class getPrimitiveTypeFromObjectType(Class clazz) {
        if (clazz.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        if (clazz.equals(Character.class)) {
            return Character.TYPE;
        }
        if (clazz.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (clazz.equals(Short.class)) {
            return Short.TYPE;
        }
        if (clazz.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (clazz.equals(Long.class)) {
            return Long.TYPE;
        }
        if (clazz.equals(Float.class)) {
            return Float.TYPE;
        }
        if (clazz.equals(Double.class)) {
            return Double.TYPE;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String string) throws NamingException, SQLException {
        Object object;
        DataSource dataSource = (DataSource)_datasources.get(string);
        if (dataSource == null) {
            object = null;
            try {
                object = Util.getInitialContext();
                dataSource = (DataSource)((InitialContext)object).lookup(string);
                _datasources.put(string, dataSource);
            }
            finally {
                if (object != null) {
                    ((InitialContext)object).close();
                }
            }
        }
        object = dataSource.getConnection();
        return object;
    }

    private static InitialContext getInitialContext() throws NamingException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        return new InitialContext(hashtable);
    }

    public static int getDBType(Connection connection) throws SQLException {
        String string;
        int n = 0;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string2 = databaseMetaData.getDatabaseProductName();
        if (string2 == null) {
            string2 = "<not found>";
        }
        String string3 = Util.getDBDriverName(databaseMetaData);
        String string4 = string2.toLowerCase(Locale.ENGLISH);
        if (Util.isOracle(string4, string = string3.toLowerCase(Locale.ENGLISH))) {
            n = 1;
        } else if (Util.isPointbase(string4, string)) {
            n = 3;
        } else if (Util.isMsSqlServer(string4, string)) {
            n = 4;
        } else if (Util.isSybase(string4, string)) {
            n = 5;
        } else if (Util.isDB2(string4, string)) {
            n = 6;
        }
        return n;
    }

    private static String getDBDriverName(DatabaseMetaData databaseMetaData) throws SQLException {
        String string = Config.getProperty("weblogic.jws.dbtype");
        if (string == null && databaseMetaData != null) {
            string = databaseMetaData.getDriverName();
        }
        if (string == null) {
            string = "<not found>";
        }
        return string;
    }

    private static boolean isOracle(String string, String string2) {
        return string.indexOf("oracle") != -1 || string2.indexOf("oracle") != -1;
    }

    private static boolean isPointbase(String string, String string2) {
        return string.indexOf("pointbase") != -1 || string2.indexOf("pointbase") != -1;
    }

    private static boolean isMsSqlServer(String string, String string2) {
        return (string.indexOf("sql server") != -1 || string.indexOf("sqlserver") != -1) && string2.indexOf("sybase") == -1;
    }

    private static boolean isSybase(String string, String string2) {
        return string.indexOf("sybase") != -1 || string.indexOf("jconnect") != -1 || string.indexOf("sql server") != -1 && string2.indexOf("sybase") != -1;
    }

    private static boolean isDB2(String string, String string2) {
        return string.indexOf("db2") != -1 || string2.indexOf("db2") != -1;
    }

    public static boolean isValidURI(String string) {
        try {
            new URI(string);
            return true;
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public static Class<?> getEIClass(Class<?> clazz) {
        String string;
        Class<?> clazz2 = null;
        WebService webService = clazz.getAnnotation(WebService.class);
        if (webService != null && !StringUtil.isEmpty(string = webService.endpointInterface())) {
            try {
                clazz2 = clazz.getClassLoader().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz2 = null;
            }
        }
        return clazz2;
    }

    public static boolean isWebMethod(Method method, Class<?> clazz) {
        Method method2 = method;
        if (clazz != null) {
            try {
                method2 = clazz.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (Exception exception) {
                return false;
            }
        }
        return method2.isAnnotationPresent(WebMethod.class);
    }

    public static class TypeError
    extends Exception {
        public String description;
        public int offset;

        public TypeError(String string, int n) {
            this.description = string;
            this.offset = n;
        }
    }

    public static class Type {
        public String packageName;
        public String className;
        public int arrayDepth;
        public boolean isBuiltin;

        public String getQualifiedName() {
            return this.packageName.equals("") ? this.className : this.packageName + "." + this.className;
        }
    }
}

