/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.wlw;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.Text;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.w3c.dom.Node;
import weblogic.wsee.jws.wlw.SoapFaultException;
import weblogic.wsee.jws.wlw.UnRecognizedFaultException;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.WLSOAPFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JwsSoapFaultHelper {
    public static final String URI_FAULT_CODE = "http://www.bea.com/2003/04/jwFaultCode/";
    public static final String SOAP_ENVELOPE = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String SOAP12_ENVELOPE;
    private static final Name DETAIL_KEY;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fillFault(SOAPFault sOAPFault, int n, SoapFaultException soapFaultException) throws SOAPException {
        if (sOAPFault == null) {
            throw new SOAPException("Cannot fill SOAPFault since it's null");
        }
        if (n == 1 && (soapFaultException.soapFaultVersion() == 1 || soapFaultException.soapFaultVersion() == 0)) {
            try {
                XmlObject xmlObject = soapFaultException.getFault();
                if (xmlObject != null) {
                    Class<?> clazz = JwsSoapFaultHelper.getContextClassLoader().loadClass("weblogic.wsee.jws.wlw.schemas.soap11.Fault");
                    Method method = clazz.getMethod("getFaultcode", new Class[0]);
                    QName qName = (QName)method.invoke((Object)xmlObject, new Object[0]);
                    sOAPFault.addNamespaceDeclaration("fault", qName.getNamespaceURI());
                    sOAPFault.setFaultCode("fault:" + qName.getLocalPart());
                    Method method2 = clazz.getMethod("getFaultstring", new Class[0]);
                    sOAPFault.setFaultString((String)method2.invoke((Object)xmlObject, new Object[0]));
                    Method method3 = clazz.getMethod("getFaultactor", new Class[0]);
                    sOAPFault.setFaultActor((String)method3.invoke((Object)xmlObject, new Object[0]));
                    Method method4 = clazz.getMethod("getDetail", new Class[0]);
                    XmlObject xmlObject2 = (XmlObject)method4.invoke((Object)xmlObject, new Object[0]);
                    if (xmlObject2 == null) return;
                    JwsSoapFaultHelper.setDetailFromFault(sOAPFault, xmlObject2);
                    return;
                }
                String string = soapFaultException.isCausedBySender() ? "Client" : "Server";
                sOAPFault.addNamespaceDeclaration("fault", SOAP_ENVELOPE);
                sOAPFault.setFaultCode("fault:" + string);
                sOAPFault.setFaultString("Undefined");
                if (!soapFaultException.hasDetail()) return;
                JwsSoapFaultHelper.setDetail(sOAPFault, soapFaultException.getDetail());
                return;
            }
            catch (Exception exception) {
                throw new SOAPException((Throwable)exception);
            }
        } else if (n == 2 && (soapFaultException.soapFaultVersion() == 2 || soapFaultException.soapFaultVersion() == 0)) {
            try {
                XmlObject xmlObject = soapFaultException.getFault();
                if (xmlObject != null) {
                    Class<?> clazz = JwsSoapFaultHelper.getContextClassLoader().loadClass("weblogic.wsee.jws.wlw.schemas.soap12.Fault");
                    if (!clazz.isAssignableFrom(xmlObject.getClass())) {
                        throw new SOAPException("Unexpected content in wlw SoapFaultException: " + xmlObject.getClass().getName());
                    }
                    Method method = clazz.getMethod("getCode", new Class[0]);
                    Object object = method.invoke((Object)xmlObject, new Object[0]);
                    Method method5 = object.getClass().getMethod("getValue", new Class[0]);
                    QName qName = (QName)method5.invoke(object, new Object[0]);
                    sOAPFault.setFaultCode(qName);
                    Method method6 = clazz.getMethod("getReason", new Class[0]);
                    Object object2 = method6.invoke((Object)xmlObject, new Object[0]);
                    Method method7 = object2.getClass().getMethod("getTextArray", new Class[0]);
                    XmlString[] xmlStringArray = (XmlString[])method7.invoke(object2, new Object[0]);
                    for (XmlString xmlString : xmlStringArray) {
                        Method method8 = xmlString.getClass().getMethod("getLang", new Class[0]);
                        String string = (String)method8.invoke((Object)xmlString, new Object[0]);
                        Locale locale = string == null ? Locale.getDefault() : new Locale(string);
                        sOAPFault.addFaultReasonText(xmlString.getStringValue(), locale);
                    }
                    Method method9 = clazz.getMethod("getRole", new Class[0]);
                    sOAPFault.setFaultRole((String)method9.invoke((Object)xmlObject, new Object[0]));
                    Method method10 = clazz.getMethod("getDetail", new Class[0]);
                    XmlObject xmlObject3 = (XmlObject)method10.invoke((Object)xmlObject, new Object[0]);
                    if (xmlObject3 == null) return;
                    JwsSoapFaultHelper.setDetailFromFault(sOAPFault, xmlObject3);
                    return;
                }
                String string = soapFaultException.isCausedBySender() ? "Sender" : "Receiver";
                sOAPFault.setFaultCode(string);
                sOAPFault.addFaultReasonText("Undefined", Locale.US);
                if (!soapFaultException.hasDetail()) return;
                JwsSoapFaultHelper.setDetail(sOAPFault, soapFaultException.getDetail());
                return;
            }
            catch (Exception exception) {
                throw new SOAPException((Throwable)exception);
            }
        } else {
            String string = "JWSError";
            String string2 = "Wrong SOAP Fault version. SOAP Fault Version must be the same version with the SOAP protocol used. See com.bea.control.Context.getProtocol().";
            if (sOAPFault.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
                sOAPFault.setFaultCode(string);
                sOAPFault.addFaultReasonText(string2, Locale.US);
                return;
            } else {
                sOAPFault.addNamespaceDeclaration("fault", URI_FAULT_CODE);
                sOAPFault.setFaultCode("fault:" + string);
                sOAPFault.setFaultString(string2);
            }
        }
    }

    public static SoapFaultException createExceptionFromFault(SOAPFault sOAPFault, int n) throws UnRecognizedFaultException {
        if (n == 1) {
            LinkedList<XmlObject> linkedList = null;
            Detail detail = sOAPFault.getDetail();
            if (detail != null) {
                linkedList = JwsSoapFaultHelper.getDetailList(detail);
            }
            try {
                Class<?> clazz = JwsSoapFaultHelper.getContextClassLoader().loadClass("weblogic.wsee.jws.wlw.schemas.soap11.Fault$Factory");
                Class<?> clazz2 = JwsSoapFaultHelper.getContextClassLoader().loadClass("weblogic.wsee.jws.wlw.schemas.soap11.Fault");
                Method method = clazz.getMethod("newInstance", new Class[0]);
                XmlObject xmlObject = (XmlObject)method.invoke(null, new Object[0]);
                Method method2 = clazz2.getMethod("setFaultactor", String.class);
                method2.invoke((Object)xmlObject, sOAPFault.getFaultActor());
                Method method3 = clazz2.getMethod("setFaultstring", String.class);
                method3.invoke((Object)xmlObject, sOAPFault.getFaultString());
                Name name = sOAPFault.getFaultCodeAsName();
                QName qName = new QName(name.getURI(), name.getLocalName(), name.getPrefix());
                Method method4 = clazz2.getMethod("setFaultcode", QName.class);
                method4.invoke((Object)xmlObject, qName);
                if (linkedList != null && linkedList.size() > 0) {
                    Method method5 = clazz2.getMethod("addNewDetail", new Class[0]);
                    XmlObject xmlObject2 = (XmlObject)method5.invoke((Object)xmlObject, new Object[0]);
                    xmlObject2.set(linkedList.get(0));
                }
                return new SoapFaultException(xmlObject);
            }
            catch (Exception exception) {
                throw new UnRecognizedFaultException(exception);
            }
        }
        if (n == 2) {
            LinkedList<XmlObject> linkedList = null;
            Detail detail = sOAPFault.getDetail();
            if (detail != null) {
                linkedList = JwsSoapFaultHelper.getDetailList(detail);
            }
            try {
                Object object;
                Object object2;
                Object object3;
                Locale locale;
                Class<?> clazz = JwsSoapFaultHelper.getContextClassLoader().loadClass("weblogic.wsee.jws.wlw.schemas.soap12.Fault$Factory");
                Class<?> clazz3 = JwsSoapFaultHelper.getContextClassLoader().loadClass("weblogic.wsee.jws.wlw.schemas.soap12.Fault");
                Method method = clazz.getMethod("newInstance", new Class[0]);
                XmlObject xmlObject = (XmlObject)method.invoke(null, new Object[0]);
                Method method6 = clazz3.getMethod("setRole", String.class);
                method6.invoke((Object)xmlObject, sOAPFault.getFaultRole());
                Method method7 = clazz3.getMethod("addNewReason", new Class[0]);
                Object object4 = method7.invoke((Object)xmlObject, new Object[0]);
                Method method8 = object4.getClass().getMethod("addNewText", new Class[0]);
                Iterator iterator = sOAPFault.getFaultReasonTexts();
                Iterator iterator2 = sOAPFault.getFaultReasonLocales();
                while (iterator.hasNext()) {
                    locale = Locale.getDefault();
                    if (iterator2.hasNext()) {
                        locale = (Locale)iterator2.next();
                    }
                    object3 = iterator.next().toString();
                    object2 = (XmlString)method8.invoke(object4, new Object[0]);
                    object2.setStringValue((String)object3);
                    object = object2.getClass().getMethod("setLang", String.class);
                    ((Method)object).invoke(object2, locale.getCountry());
                }
                locale = sOAPFault.getFaultCodeAsName();
                object3 = new QName(locale.getURI(), locale.getLocalName(), locale.getPrefix());
                object2 = clazz3.getMethod("addNewCode", new Class[0]);
                object = ((Method)object2).invoke((Object)xmlObject, new Object[0]);
                Method method9 = object.getClass().getMethod("setValue", QName.class);
                method9.invoke(object, object3);
                if (linkedList != null && linkedList.size() > 0) {
                    Method method10 = clazz3.getMethod("addNewDetail", new Class[0]);
                    XmlObject xmlObject3 = (XmlObject)method10.invoke((Object)xmlObject, new Object[0]);
                    xmlObject3.set(linkedList.get(0));
                }
                return new SoapFaultException(xmlObject);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new UnRecognizedFaultException(exception);
            }
        }
        throw new IllegalArgumentException("Unrecognized soap version");
    }

    private static LinkedList<XmlObject> getDetailList(Detail detail) throws UnRecognizedFaultException {
        LinkedList<XmlObject> linkedList = new LinkedList<XmlObject>();
        Iterator iterator = detail.getDetailEntries();
        while (iterator.hasNext()) {
            Node node;
            Text text;
            boolean bl = false;
            Object e = iterator.next();
            if (e instanceof Text) {
                text = (Text)e;
                linkedList.add(JwsSoapFaultHelper.getXmlObjectFromText(text.getValue()));
                bl = true;
            } else if (e instanceof DetailEntry && (node = (text = (DetailEntry)e).getFirstChild()) != null && node instanceof Text) {
                Text text2 = (Text)node;
                linkedList.add(JwsSoapFaultHelper.getXmlObjectFromText(text2.getValue()));
                bl = true;
            }
            if (bl) continue;
            throw new UnRecognizedFaultException("Cannot create SoapFaultException");
        }
        return linkedList;
    }

    private static final XmlObject getXmlObjectFromText(String string) throws UnRecognizedFaultException {
        try {
            Verbose.log("****** About to unmarshal the following xml text: ");
            Verbose.log(string);
            return XmlObject.Factory.parse((String)string);
        }
        catch (XmlException xmlException) {
            throw new UnRecognizedFaultException(xmlException);
        }
    }

    private static void setDetail(SOAPFault sOAPFault, XmlObject[] xmlObjectArray) throws SOAPException {
        if (xmlObjectArray != null && xmlObjectArray.length > 0) {
            if (sOAPFault.getDetail() != null) {
                sOAPFault.getDetail().detachNode();
            }
            Detail detail = sOAPFault.addDetail();
            for (XmlObject xmlObject : xmlObjectArray) {
                DetailEntry detailEntry = detail.addDetailEntry(DETAIL_KEY);
                detailEntry.addTextNode(xmlObject.xmlText());
                Verbose.log("***** Added following detail entry: " + xmlObject.xmlText());
            }
        }
    }

    private static void setDetailFromFault(SOAPFault sOAPFault, XmlObject xmlObject) throws SOAPException {
        if (xmlObject != null) {
            if (sOAPFault.getDetail() != null) {
                sOAPFault.getDetail().detachNode();
            }
            Detail detail = sOAPFault.addDetail();
            detail.addTextNode(xmlObject.xmlText());
        }
    }

    private static final ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    static {
        String string = System.getProperty("com.bea.jws.soap12.env");
        SOAP12_ENVELOPE = string != null ? string : "http://www.w3.org/2003/05/soap-envelope";
        string = null;
        try {
            string = WLSOAPFactory.createSOAPFactory().createName("WLW_FAULT_DETAIL");
        }
        catch (SOAPException sOAPException) {
            Verbose.log((Object)"Unable to create Name for WLW_FAULT_DETAIL", sOAPException);
        }
        if (string == null) {
            throw new RuntimeException("Unable to create Name for WLW_FAULT_DETAIL");
        }
        DETAIL_KEY = string;
    }
}

