/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.wlw;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.jws.wlw.WLW81CompatTxVoidReturnClientHandler;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

public class WLW81CompatTxVoidReturnDeploymentListener
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(WLW81CompatTxVoidReturnDeploymentListener.class);
    private static final List BEFORE = Arrays.asList((Object[])new String[]{"CONNECTION_HANDLER"});
    private static final List AFTER = Arrays.asList((Object[])new String[]{"ASYNC_HANDLER"});
    private static final String HANDLER_NAME = "WLW81_COMPAT_TX_VOID_RETURN_CLIENT_HANDLER";
    private static final HandlerInfo HANDLER_INFO = new HandlerInfo(WLW81CompatTxVoidReturnClientHandler.class, null, new QName[0]);

    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        if (verbose) {
            Verbose.log("WLW81CompatTxVoidReturnDeploymentListener firing");
        }
        Iterator<WsPort> iterator = wsDeploymentContext.getWsService().getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            if ("jms".equalsIgnoreCase(wsPort.getWsdlPort().getTransport())) {
                try {
                    wsPort.getInternalHandlerList().insert(HANDLER_NAME, HANDLER_INFO, AFTER, BEFORE);
                    if (!verbose) continue;
                    Verbose.log("Added client tx void return handler for " + wsPort.getWsdlPort().getName());
                    continue;
                }
                catch (HandlerException handlerException) {
                    throw new WsDeploymentException("Could not insert WLW81CompatTxVoidReturnClientHandler handler", handlerException);
                }
            }
            if (!verbose) continue;
            Verbose.log(wsPort.getWsdlPort().getName() + " does not have jms transport. ");
        }
    }
}

