/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.api;

import com.sun.xml.ws.api.FeatureConstructor;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.client.ServiceCreationInterceptor;
import com.sun.xml.ws.developer.WSBindingProvider;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.Binding;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import weblogic.jws.jaxws.client.async.AsyncClientTransportFeature;
import weblogic.kernel.KernelStatus;
import weblogic.wsee.WseeMCLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class McFeature
extends WebServiceFeature
implements ServiceCreationInterceptor {
    private static final Logger LOGGER = Logger.getLogger(McFeature.class.getName());
    private static final String ID = "MakeConnection Feature";
    private static final String DEFAULT_EXPIRES_INTERVAL = "P1D";
    private static final String DEFAULT_MESSAGE_INTERVAL = "P0DT5S";
    private WSBinding _binding;
    private String _messageInterval;
    private String _expiresInterval;
    private boolean _exponentialBackoff;
    private boolean _useMcWithSyncInvoke;
    private boolean _nonPersistent;

    @FeatureConstructor
    public McFeature() {
        this.enabled = true;
        this._nonPersistent = !KernelStatus.isServer();
        this._messageInterval = DEFAULT_MESSAGE_INTERVAL;
        this._expiresInterval = DEFAULT_EXPIRES_INTERVAL;
        this._useMcWithSyncInvoke = true;
        this._exponentialBackoff = false;
    }

    public McFeature(boolean bl) {
        this.enabled = true;
        this._nonPersistent = !KernelStatus.isServer();
        this._messageInterval = DEFAULT_MESSAGE_INTERVAL;
        this._expiresInterval = DEFAULT_EXPIRES_INTERVAL;
        this._exponentialBackoff = false;
        this._useMcWithSyncInvoke = bl;
    }

    public String getID() {
        return ID;
    }

    public void setUseMcWithSyncInvoke(boolean bl) {
        this._useMcWithSyncInvoke = bl;
    }

    public boolean isUseMcWithSyncInvoke() {
        return this._useMcWithSyncInvoke;
    }

    public void setInterval(String string) {
        this._messageInterval = string;
    }

    public String getInterval() {
        return this._messageInterval;
    }

    public void setExpires(String string) {
        this._expiresInterval = string;
    }

    public String getExpires() {
        return this._expiresInterval;
    }

    public boolean isNonPersistent() {
        return this._nonPersistent;
    }

    public void setNonPersistent(boolean bl) {
        this._nonPersistent = bl;
    }

    public void setExponentialBackoff(boolean bl) {
        this._exponentialBackoff = bl;
    }

    public boolean isUseExponentialBackoff() {
        return this._exponentialBackoff;
    }

    public void setBinding(WSBinding wSBinding) {
        this._binding = wSBinding;
    }

    public void postCreateDispatch(WSBindingProvider wSBindingProvider) {
        if (this._binding != null) {
            if (this._binding.getFeature(AsyncClientTransportFeature.class) != null) {
                throw new WebServiceException(WseeMCLogger.logCannotUseAsyncClientTransportLoggable().getMessage());
            }
        } else {
            Binding binding = wSBindingProvider.getBinding();
            if (binding instanceof WSBinding) {
                if (((WSBinding)binding).getFeature(AsyncClientTransportFeature.class) != null) {
                    throw new WebServiceException(WseeMCLogger.logCannotUseAsyncClientTransportLoggable().getMessage());
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to check feature compatability as binding is not a WS Binding");
            }
        }
    }

    public void postCreateProxy(WSBindingProvider wSBindingProvider, Class<?> clazz) {
        this.postCreateDispatch(wSBindingProvider);
    }

    public static String getMcFeatureIDValue() {
        return ID;
    }
}

