/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.cluster;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPException;
import weblogic.wsee.WseeMCLogger;
import weblogic.wsee.config.WebServiceMBeanFactory;
import weblogic.wsee.jaxws.cluster.spi.AffinityBasedRoutingInfoFinder;
import weblogic.wsee.jaxws.cluster.spi.RoutingInfo;
import weblogic.wsee.jaxws.cluster.spi.RoutingInfoFinder;
import weblogic.wsee.jaxws.cluster.spi.RoutingInfoFinderRegistry;
import weblogic.wsee.mc.cluster.McAffinityStore;
import weblogic.wsee.mc.messages.McMsg;
import weblogic.wsee.mc.tube.McTubeUtils;
import weblogic.wsee.mc.utils.McConstants;

public class McAnonIDRoutingInfoFinder
implements AffinityBasedRoutingInfoFinder {
    private static final Logger LOGGER = Logger.getLogger(McAnonIDRoutingInfoFinder.class.getName());
    private static boolean _didRegister = false;
    private final McAffinityStore _store;
    private final ReentrantReadWriteLock _affinityLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerIfNeeded() {
        Class<McAnonIDRoutingInfoFinder> clazz = McAnonIDRoutingInfoFinder.class;
        synchronized (McAnonIDRoutingInfoFinder.class) {
            if (!_didRegister) {
                _didRegister = true;
                McAnonIDRoutingInfoFinder mcAnonIDRoutingInfoFinder = new McAnonIDRoutingInfoFinder();
                RoutingInfoFinderRegistry.getInstance().addFinder(mcAnonIDRoutingInfoFinder);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public McAnonIDRoutingInfoFinder() {
        String string = WebServiceMBeanFactory.getInstance().getWebServicePersistence().getDefaultLogicalStoreName();
        try {
            this._store = McAffinityStore.getStore(string);
            this._affinityLock = new ReentrantReadWriteLock();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    public void setUsageMode(RoutingInfoFinder.UsageMode usageMode) {
    }

    public int getFinderPriority() {
        return 200;
    }

    /*
     * WARNING - void declaration
     */
    public RoutingInfo findRoutingInfo(HeaderList headerList) throws Exception {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Searching headers for routing info");
        }
        for (AddressingVersion addressingVersion : AddressingVersion.values()) {
            for (AddressingVersion addressingVersion2 : SOAPVersion.values()) {
                String string = headerList.getAction(addressingVersion, (SOAPVersion)addressingVersion2);
                if (string == null || !McConstants.Action.MC.matchesAnyMCVersion(string)) continue;
                return new RoutingInfo(string, RoutingInfo.Type.NEED_BODY);
            }
        }
        WSEndpointReference wSEndpointReference = null;
        for (AddressingVersion addressingVersion : AddressingVersion.values()) {
            for (SOAPVersion sOAPVersion : SOAPVersion.values()) {
                wSEndpointReference = headerList.getReplyTo(addressingVersion, sOAPVersion);
                if (wSEndpointReference == null) continue;
                if (!McTubeUtils.isMcAnonURI(wSEndpointReference)) break;
                String string = McTubeUtils.getUUID(wSEndpointReference);
                return this.lookupRoutingInfo(string);
            }
            if (wSEndpointReference != null) break;
        }
        WSEndpointReference wSEndpointReference2 = null;
        for (AddressingVersion addressingVersion : AddressingVersion.values()) {
            void var10_24;
            SOAPVersion[] sOAPVersionArray = SOAPVersion.values();
            int n = sOAPVersionArray.length;
            boolean bl = false;
            while (var10_24 < n) {
                SOAPVersion sOAPVersion = sOAPVersionArray[var10_24];
                wSEndpointReference2 = headerList.getFaultTo(addressingVersion, sOAPVersion);
                if (wSEndpointReference2 != null) {
                    if (!McTubeUtils.isMcAnonURI(wSEndpointReference2)) break;
                    String string = McTubeUtils.getUUID(wSEndpointReference2);
                    return this.lookupRoutingInfo(string);
                }
                ++var10_24;
            }
            if (wSEndpointReference2 != null) break;
        }
        return new RoutingInfo(null, RoutingInfo.Type.ABSTAIN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoutingInfo findRoutingInfoFromSoapBody(RoutingInfo routingInfo, Packet packet) throws Exception {
        RoutingInfo routingInfo2;
        Message message = packet.getMessage();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Finding MC routing info from MC msg within SOAP body");
        }
        McMsg mcMsg = new McMsg();
        try {
            mcMsg.readFromSOAPMsg(message.readAsSOAPMessage());
        }
        catch (SOAPException sOAPException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "McAnonIDRoutingInfoFinder failed: exception reading SOAP message: " + (Object)((Object)sOAPException));
            }
            WseeMCLogger.logUnexpectedException((String)sOAPException.toString(), (Throwable)sOAPException);
            throw sOAPException;
        }
        String string = mcMsg.getAddress();
        if (string == null) {
            return new RoutingInfo(null, RoutingInfo.Type.ABSTAIN);
        }
        boolean bl = McTubeUtils.isMcAnonURI(string);
        if (!bl) {
            return new RoutingInfo(null, RoutingInfo.Type.ABSTAIN);
        }
        String string2 = McTubeUtils.getUUID(string);
        try {
            this._affinityLock.readLock().lock();
            routingInfo2 = (RoutingInfo)this._store.get(string2);
            Object var10_10 = null;
            this._affinityLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this._affinityLock.readLock().unlock();
            throw throwable;
        }
        if (routingInfo2 == null) {
            routingInfo2 = new RoutingInfo(null, RoutingInfo.Type.ABSTAIN);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "McAnonIDRoutingInfoFinder: returning routing info: " + routingInfo2.toString());
        }
        return routingInfo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordRoutingIDAffinity(RoutingInfo routingInfo, RoutingInfo routingInfo2) {
        String string;
        if (routingInfo2 != null && (string = routingInfo.getName()) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("MC finder associating anon URI '" + string + "' with routing info: " + routingInfo2);
            }
            try {
                this._affinityLock.writeLock().lock();
                RoutingInfo routingInfo3 = (RoutingInfo)this._store.remove(string);
                this._store.put(string, routingInfo2);
                if (routingInfo3 != null && routingInfo3.getType() == RoutingInfo.Type.ABSTAIN) {
                    RoutingInfo routingInfo4 = routingInfo3;
                    synchronized (routingInfo4) {
                        routingInfo3.notifyAll();
                    }
                }
                Object var8_7 = null;
                this._affinityLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this._affinityLock.writeLock().unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RoutingInfo lookupRoutingInfo(String string) {
        RoutingInfo routingInfo;
        block9: {
            this._affinityLock.writeLock().lock();
            routingInfo = (RoutingInfo)this._store.get(string);
            if (routingInfo != null) break block9;
            routingInfo = new RoutingInfo(string, RoutingInfo.Type.ABSTAIN);
            this._store.put(string, routingInfo);
            RoutingInfo routingInfo2 = routingInfo;
            Object var7_5 = null;
            this._affinityLock.writeLock().unlock();
            return routingInfo2;
        }
        try {
            RoutingInfo routingInfo3;
            while (routingInfo.getType() == RoutingInfo.Type.ABSTAIN) {
                routingInfo3 = routingInfo;
                synchronized (routingInfo3) {
                    try {
                        this._affinityLock.writeLock().unlock();
                        routingInfo.wait();
                        this._affinityLock.writeLock().lock();
                    }
                    catch (InterruptedException interruptedException) {
                        this._affinityLock.writeLock().lock();
                    }
                }
                routingInfo = (RoutingInfo)this._store.get(string);
            }
            routingInfo3 = routingInfo;
            Object var7_6 = null;
            this._affinityLock.writeLock().unlock();
            return routingInfo3;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this._affinityLock.writeLock().unlock();
            throw throwable;
        }
    }
}

