/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.faults;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import weblogic.wsee.mc.exception.McFaultException;
import weblogic.wsee.mc.utils.McConstants;

public abstract class McFaultMsg {
    private final McConstants.McVersion version;
    protected McConstants.FaultCode code;
    protected String subCode;
    protected String reason;

    protected McFaultMsg(McConstants.McVersion mcVersion, McConstants.FaultCode faultCode, String string, String string2) {
        this.version = mcVersion;
        this.code = faultCode;
        this.subCode = string;
        this.reason = string2;
    }

    public McConstants.McVersion getMcVersion() {
        return this.version;
    }

    public McConstants.FaultCode getCode() {
        return this.code;
    }

    public String getCodeQualifiedName(McConstants.SOAPVersion sOAPVersion) {
        return this.code.getCodeQualifiedName(sOAPVersion);
    }

    public QName getCodeQName(McConstants.SOAPVersion sOAPVersion) {
        return this.code.getCodeQName(sOAPVersion);
    }

    public String getCodeLocalName(McConstants.SOAPVersion sOAPVersion) {
        return this.code.getCodeLocalName(sOAPVersion);
    }

    public String getSubCodeQualifiedName() {
        return this.version.getPrefix() + ":" + this.subCode;
    }

    public QName getSubCodeQName() {
        return new QName(this.version.getNamespaceUri(), this.subCode, this.version.getPrefix());
    }

    public String getSubCodeLocalName() {
        return this.subCode;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public abstract void read(SOAPMessage var1) throws McFaultException;

    public abstract void write(SOAPMessage var1) throws McFaultException;

    public abstract void readDetail(Element var1) throws McFaultException;

    public abstract void writeDetail(Element var1) throws McFaultException;
}

