/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.faults;

import java.util.Iterator;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import weblogic.wsee.mc.exception.McFaultException;
import weblogic.wsee.mc.faults.McFaultMsg;
import weblogic.wsee.mc.utils.McConstants;
import weblogic.wsee.mc.utils.McProtocolUtils;

public class MissingSelectionFaultMsg
extends McFaultMsg {
    public MissingSelectionFaultMsg(McConstants.McVersion mcVersion) {
        super(mcVersion, McConstants.FaultCode.RECEIVER, McConstants.Element.MISSING_SELECTION_FAULT.getElementName(), "The MakeConnection element did not contain any selection criteria");
    }

    public void read(SOAPMessage sOAPMessage) throws McFaultException {
        try {
            SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
            if (sOAPBody == null) {
                throw new McFaultException("No body in SOAP message");
            }
            if (!sOAPBody.hasFault()) {
                throw new McFaultException("No SOAP fault in SOAP message");
            }
            SOAPFault sOAPFault = sOAPBody.getFault();
            this.code = McProtocolUtils.getSOAPFaultCodeFromName(sOAPFault.getFaultCodeAsName());
            SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
            String string = sOAPEnvelope.getNamespaceURI();
            McConstants.SOAPVersion sOAPVersion = McProtocolUtils.getSOAPVersionFromNamespaceUri(string);
            if (sOAPVersion == McConstants.SOAPVersion.SOAP_11) {
                String string2 = sOAPFault.getFaultCodeAsName().getLocalName();
                if (!this.getSubCodeLocalName().equals(string2)) {
                    throw new McFaultException("Wrong subcode for UnspportedSelectionFault");
                }
            } else {
                Iterator iterator = sOAPFault.getFaultSubcodes();
                boolean bl = false;
                while (iterator.hasNext() && !bl) {
                    QName qName = (QName)iterator.next();
                    if (!this.getSubCodeQName().equals(qName)) continue;
                    bl = true;
                }
                if (!bl) {
                    throw new McFaultException("Wrong subcode for UnsupportedSelectionFault");
                }
            }
            this.reason = sOAPFault.getFaultString();
        }
        catch (SOAPException sOAPException) {
            throw new McFaultException("SOAPException", sOAPException);
        }
    }

    public void write(SOAPMessage sOAPMessage) throws McFaultException {
        try {
            SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
            String string = sOAPEnvelope.getNamespaceURI();
            SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
            if (sOAPBody == null) {
                throw new McFaultException("No body in SOAP message");
            }
            if (this.code == null) {
                throw new McFaultException("Fault code is not set");
            }
            SOAPFault sOAPFault = sOAPBody.addFault();
            McConstants.SOAPVersion sOAPVersion = McProtocolUtils.getSOAPVersionFromNamespaceUri(string);
            if (sOAPVersion == McConstants.SOAPVersion.SOAP_11) {
                Name name = sOAPEnvelope.createName(this.getSubCodeLocalName(), this.getMcVersion().getPrefix(), this.getMcVersion().getNamespaceUri());
                sOAPFault.setFaultCode(name);
            } else {
                sOAPFault.setFaultCode(sOAPEnvelope.createName(this.getCodeLocalName(sOAPVersion), sOAPEnvelope.getPrefix(), sOAPEnvelope.getNamespaceURI()));
                sOAPFault.appendFaultSubcode(this.getSubCodeQName());
            }
            if (this.reason != null) {
                sOAPFault.setFaultString(this.reason, Locale.US);
            }
            this.writeDetail((Element)sOAPFault);
        }
        catch (SOAPException sOAPException) {
            throw new McFaultException("SOAPException", sOAPException);
        }
    }

    public void writeDetail(Element element) throws McFaultException {
    }

    public void readDetail(Element element) throws McFaultException {
    }
}

