/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.faults;

import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.mc.exception.McFaultException;
import weblogic.wsee.mc.faults.McFaultMsg;
import weblogic.wsee.mc.utils.McConstants;
import weblogic.wsee.mc.utils.McProtocolUtils;
import weblogic.xml.dom.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsupportedSelectionFaultMsg
extends McFaultMsg {
    public static final String SUBCODE_LOCAL_NAME = "UnsupportedSelection";
    private List<QName> _unsupportedList;

    public UnsupportedSelectionFaultMsg(McConstants.McVersion mcVersion) {
        super(mcVersion, McConstants.FaultCode.RECEIVER, McConstants.Element.UNSUPPORTED_SELECTION_FAULT.getElementName(), "The extension element used in the message selection is not supported by the MakeConnection receiver");
    }

    public void setUnsupported(List<QName> list) {
        this._unsupportedList = list;
    }

    public List<QName> getUnsupported() {
        return this._unsupportedList;
    }

    @Override
    public void read(SOAPMessage sOAPMessage) throws McFaultException {
        assert (sOAPMessage != null);
        try {
            SOAPHeader sOAPHeader = sOAPMessage.getSOAPHeader();
            if (sOAPHeader == null) {
                throw new McFaultException("No header in SOAP message");
            }
            SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
            if (sOAPBody == null) {
                throw new McFaultException("No body in SOAP message");
            }
            if (!sOAPBody.hasFault()) {
                throw new McFaultException("No SOAP fault in SOAP message");
            }
            SOAPFault sOAPFault = sOAPBody.getFault();
            this.code = McProtocolUtils.getSOAPFaultCodeFromName(sOAPFault.getFaultCodeAsName());
            SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
            String string = sOAPEnvelope.getNamespaceURI();
            boolean bl = "http://www.w3.org/2003/05/soap-envelope".equals(string);
            this.reason = sOAPFault.getFaultString();
            Detail detail = sOAPFault.getDetail();
            this.readDetail((Element)detail);
        }
        catch (SOAPException sOAPException) {
            throw new McFaultException("SOAPException", sOAPException);
        }
    }

    @Override
    public void write(SOAPMessage sOAPMessage) throws McFaultException {
        try {
            Name name;
            boolean bl;
            SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
            String string = sOAPEnvelope.getNamespaceURI();
            McConstants.SOAPVersion sOAPVersion = McProtocolUtils.getSOAPVersionFromNamespaceUri(string);
            SOAPHeader sOAPHeader = sOAPMessage.getSOAPHeader();
            if (sOAPHeader == null) {
                throw new McFaultException("No header in SOAP message");
            }
            SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
            if (sOAPBody == null) {
                throw new McFaultException("No body in SOAP message");
            }
            if (this.code == null) {
                throw new McFaultException("Fault code is not set");
            }
            SOAPFault sOAPFault = sOAPBody.addFault();
            McConstants.McVersion mcVersion = this.getMcVersion();
            String string2 = DOMUtils.getNamespaceURI((Element)sOAPHeader, mcVersion.getPrefix());
            boolean bl2 = bl = string2 == null || string2.length() == 0;
            if (bl) {
                DOMUtils.addNamespaceDeclaration((Element)sOAPHeader, mcVersion.getPrefix(), mcVersion.getNamespaceUri());
            }
            if (sOAPVersion == McConstants.SOAPVersion.SOAP_11) {
                name = sOAPEnvelope.createName(this.getSubCodeLocalName(), this.getMcVersion().getPrefix(), this.getMcVersion().getNamespaceUri());
                sOAPFault.setFaultCode(name);
            } else {
                sOAPFault.setFaultCode(sOAPEnvelope.createName(this.getCodeLocalName(sOAPVersion), sOAPEnvelope.getPrefix(), sOAPEnvelope.getNamespaceURI()));
                sOAPFault.appendFaultSubcode(this.getSubCodeQName());
            }
            if (this.reason != null) {
                sOAPFault.setFaultString(this.reason, Locale.US);
            }
            name = sOAPFault.addDetail();
            this.writeDetail((Element)name);
        }
        catch (SOAPException sOAPException) {
            throw new McFaultException("SOAPException", sOAPException);
        }
    }

    @Override
    public void writeDetail(Element element) throws McFaultException {
        if (this._unsupportedList == null) {
            throw new McFaultException("Unsupported Selection is not set");
        }
        DOMUtils.addNamespaceDeclaration(element, this.getMcVersion().getPrefix(), this.getMcVersion().getNamespaceUri());
        for (QName qName : this._unsupportedList) {
            Element element2 = element.getOwnerDocument().createElementNS(this.getMcVersion().getNamespaceUri(), McConstants.Element.UNSUPPORTED_SELECTION.getQualifiedName(this.getMcVersion()));
            String string = qName.getNamespaceURI();
            if (string == null || string.equals("")) {
                throw new McFaultException("Unsupported Selection must have namespace");
            }
            String string2 = qName.getPrefix();
            if (string2 == null || string2.equals("")) {
                string2 = "ns1";
            }
            DOMUtils.addNamespaceDeclaration(element2, string2, string);
            String string3 = string2 + ":" + qName.getLocalPart();
            DOMUtils.addTextData(element2, string3);
            element.appendChild(element2);
        }
    }

    @Override
    public void readDetail(Element element) throws McFaultException {
        String string = this.getMcVersion().getNamespaceUri();
        String string2 = McConstants.Element.UNSUPPORTED_SELECTION.getElementName();
        Node node = element.getFirstChild();
        while (node != null) {
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            if (string.equals(element2.getNamespaceURI()) && string2.equals(element2.getLocalName())) {
                try {
                    QName qName;
                    String string3 = DOMUtils.getTextContent(element2, true);
                    int n = string3.indexOf(":");
                    if (n <= 0) {
                        qName = new QName(string3);
                    } else {
                        String string4 = string3.substring(0, n - 1);
                        String string5 = string3.substring(n + 1);
                        String string6 = DOMUtils.getNamespaceURI(element2, string4);
                        if (string6 == null) {
                            throw new McFaultException("Unsupported selection contains unknown namespace");
                        }
                        qName = new QName(string6, string5);
                    }
                    this._unsupportedList.add(qName);
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new McFaultException("Parsing error during processing of unsupported selection");
                }
            }
            throw new McFaultException("Illegal element in detail of fault message");
        }
    }
}

