/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.headers;

import javax.xml.namespace.QName;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import weblogic.wsee.mc.utils.McConstants;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderType;
import weblogic.wsee.reliability2.compat.CommonHeader;
import weblogic.wsee.reliability2.compat.SimpleElement;

public class MessagePendingHeader
extends CommonHeader {
    private static final long serialVersionUID = 1L;
    public static final String LOCAL_NAME = McConstants.Element.MESSAGE_PENDING.getElementName();
    public static final MsgHeaderType TYPE = new MsgHeaderType();
    private final McConstants.McVersion _mcVersion;
    private boolean _pending = false;

    public MessagePendingHeader(McConstants.McVersion mcVersion) {
        super(new QName(mcVersion.getNamespaceUri(), LOCAL_NAME, mcVersion.getPrefix()));
        this._mcVersion = mcVersion;
    }

    public MessagePendingHeader() {
        this(McConstants.McVersion.latest());
    }

    public MsgHeaderType getType() {
        return TYPE;
    }

    public McConstants.McVersion getMcVersion() {
        return this._mcVersion;
    }

    public void setPending(boolean bl) {
        this._pending = bl;
    }

    public boolean getPending() {
        return this._pending;
    }

    public void readFromSimpleElement(SimpleElement simpleElement) throws MsgHeaderException {
        this._pending = false;
        String string = simpleElement.getAttr(null, McConstants.Element.PENDING.getElementName());
        if (string != null) {
            this._pending = Boolean.parseBoolean(string);
        }
    }

    public SimpleElement writeToSimpleElement() throws MsgHeaderException {
        QName qName = McConstants.Element.MESSAGE_PENDING.getQName(this.getMcVersion());
        SimpleElement simpleElement = new SimpleElement(qName);
        String string = Boolean.toString(this._pending);
        simpleElement.setAttr(null, McConstants.Element.PENDING.getElementName(), string);
        return simpleElement;
    }

    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
    }
}

