/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.mc.utils.McConstants;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.util.PolicyHelper;

public class MCSupported
extends PolicyAssertion {
    private static final long serialVersionUID = -4920168888986897631L;
    public static final QName MC_QNAME = new QName(McConstants.McVersion.MC_11.getNamespaceUri(), McConstants.Element.MC_SUPPORTED.getElementName(), McConstants.McVersion.MC_11.getPrefix());
    Boolean optional = null;

    public boolean getOptional() {
        if (null == this.optional) {
            return true;
        }
        return this.optional;
    }

    public boolean isOptional() {
        return this.getOptional();
    }

    public void setOptional(boolean bl) {
        this.optional = new Boolean(bl);
    }

    public Element serialize(Document document) throws PolicyException {
        Element element = DOMUtils.createElement(this.getName(), document, McConstants.McVersion.MC_11.getPrefix());
        if (this.optional != null) {
            PolicyHelper.addOptionalAttribute(element, this.optional, this.getPolicyNamespaceUri());
        }
        return element;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.optional = objectInput.readBoolean() ? new Boolean(objectInput.readBoolean()) : null;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        if (this.optional != null) {
            objectOutput.writeBoolean(true);
            objectOutput.writeBoolean(this.optional);
        } else {
            objectOutput.writeBoolean(false);
        }
    }

    public QName getName() {
        return MC_QNAME;
    }
}

