/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.mbean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import weblogic.management.ManagementException;
import weblogic.wsee.mc.processor.McPending;
import weblogic.wsee.mc.processor.McPendingManager;
import weblogic.wsee.mc.utils.McProtocolUtils;
import weblogic.wsee.monitoring.WseeBaseRuntimeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WseeMcRuntimeData
extends WseeBaseRuntimeData {
    private static final String OPEN_TYPE_NAME = "MakeConnectionAnonymousEndpoint";
    private static final String OPEN_DESCRIPTION = "This object represents a MakeConnection Anonymous Id";
    private static final String ITEM_ID = "AnonymousEndpointId";
    private static final String ITEM_PENDING_MESSAGES = "PendingMessageCount";
    private static final String ITEM_RECEIVED_MC_MESSAGES = "ReceivedMcMessageCount";
    private static final String ITEM_EMPTY_RESPONSES = "EmptyResponseCount";
    private static final String ITEM_NON_EMPTY_RESPONSES = "NonEmptyResponseCount";
    private static final String ITEM_OLDEST_PENDING_MESSAGE = "OldestPendingMessageTime";
    private static final String ITEM_NEWEST_PENDING_MESSAGE = "NewestPendingMessageTime";
    private static String[] itemNames = new String[]{"AnonymousEndpointId", "PendingMessageCount", "ReceivedMcMessageCount", "EmptyResponseCount", "NonEmptyResponseCount", "OldestPendingMessageTime", "NewestPendingMessageTime"};
    private static String[] itemDescriptions = new String[]{"Anonymous Endpoint Id", "Pending messages", "Received MakeConnection messages", "Empty responses to MakeConnection messages", "Non-empty responses to MakeConnection messages", "Oldest pending message", "Newest pending message"};
    private static OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.LONG, SimpleType.LONG};
    private HashSet<String> _mcAnonIds = new HashSet();

    WseeMcRuntimeData(String string) throws ManagementException {
        super(string, null);
    }

    public void addMcAnonId(String string) {
        this._mcAnonIds.add(string);
    }

    public void removeMcAnonId(String string) {
        this._mcAnonIds.remove(string);
    }

    public List<String> getMcAnonymousIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        McPendingManager mcPendingManager = McPendingManager.getInstance();
        Iterator<String> iterator = this._mcAnonIds.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            McPending mcPending = mcPendingManager.getPending(string);
            if (mcPending == null) {
                iterator.remove();
                continue;
            }
            arrayList.add(McProtocolUtils.decodeId(string));
        }
        return arrayList;
    }

    public CompositeData getIdInfo(String string) throws ManagementException {
        try {
            McPendingManager mcPendingManager = McPendingManager.getInstance();
            String string2 = McProtocolUtils.encodeId(string);
            McPending mcPending = mcPendingManager.getPending(string2);
            if (mcPending == null) {
                return null;
            }
            int n = mcPending.size();
            int n2 = mcPending.getRemovalAttempts();
            int n3 = mcPending.getSuccessfulRemovalAttempts();
            int n4 = n2 - n3;
            long l = mcPending.getOldestTimestamp();
            long l2 = mcPending.getNewestTimestamp();
            if (l == -1L) {
                l = 0L;
            }
            if (l2 == -1L) {
                l2 = 0L;
            }
            CompositeType compositeType = new CompositeType(OPEN_TYPE_NAME, OPEN_DESCRIPTION, itemNames, itemDescriptions, itemTypes);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(ITEM_ID, string);
            hashMap.put(ITEM_PENDING_MESSAGES, n);
            hashMap.put(ITEM_RECEIVED_MC_MESSAGES, n2);
            hashMap.put(ITEM_EMPTY_RESPONSES, n4);
            hashMap.put(ITEM_NON_EMPTY_RESPONSES, n3);
            hashMap.put(ITEM_OLDEST_PENDING_MESSAGE, l);
            hashMap.put(ITEM_NEWEST_PENDING_MESSAGE, l2);
            return new CompositeDataSupport(compositeType, hashMap);
        }
        catch (Exception exception) {
            throw new ManagementException(exception.toString(), (Throwable)exception);
        }
    }
}

