/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.messages;

import com.sun.istack.NotNull;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.WseeMCLogger;
import weblogic.wsee.mc.exception.McMsgException;
import weblogic.wsee.mc.utils.McConstants;
import weblogic.wsee.util.ToStringWriter;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class McMsg {
    private final McConstants.McVersion _mcVersion;
    private String _address;
    private List<QName> _otherList = new ArrayList<QName>();

    public McMsg(McConstants.McVersion mcVersion) {
        this._mcVersion = mcVersion;
    }

    public McMsg() {
        this._mcVersion = McConstants.McVersion.latest();
    }

    public McConstants.McVersion getMcVersion() {
        return this._mcVersion;
    }

    public void setAddress(String string) {
        this._address = string;
    }

    public String getAddress() {
        return this._address;
    }

    public List<QName> getOther() {
        return this._otherList;
    }

    public Element readFromSOAPMsg(@NotNull SOAPMessage sOAPMessage) throws McMsgException {
        Element element;
        SOAPBody sOAPBody;
        try {
            sOAPBody = sOAPMessage.getSOAPBody();
        }
        catch (SOAPException sOAPException) {
            throw new McMsgException(WseeMCLogger.logSOAPBodyExceptionLoggable().getMessage(), sOAPException);
        }
        if (sOAPBody == null) {
            throw new McMsgException(WseeMCLogger.logNoSOAPBodyLoggable().getMessage());
        }
        QName qName = new QName(this._mcVersion.getNamespaceUri(), McConstants.Element.MC.getElementName(), this._mcVersion.getPrefix());
        try {
            element = DOMUtils.getElementByTagNameNS((Element)sOAPBody, qName.getNamespaceURI(), qName.getLocalPart());
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new McMsgException(WseeMCLogger.logMCMsgExceptionLoggable().getMessage(), (Throwable)((Object)dOMProcessingException));
        }
        this.read(element);
        return element;
    }

    public Element writeIntoSOAPMsg(@NotNull SOAPMessage sOAPMessage) throws McMsgException {
        SOAPBody sOAPBody;
        try {
            sOAPBody = sOAPMessage.getSOAPBody();
        }
        catch (SOAPException sOAPException) {
            throw new McMsgException(WseeMCLogger.logSOAPBodyExceptionLoggable().getMessage(), sOAPException);
        }
        if (sOAPBody == null) {
            throw new McMsgException(WseeMCLogger.logNoSOAPBodyLoggable().getMessage());
        }
        QName qName = new QName(this._mcVersion.getNamespaceUri(), McConstants.Element.MC.getElementName(), this._mcVersion.getPrefix());
        Element element = sOAPBody.getOwnerDocument().createElementNS(qName.getNamespaceURI(), qName.getPrefix() + ":" + qName.getLocalPart());
        DOMUtils.addNamespaceDeclaration((Element)sOAPBody, qName.getPrefix(), qName.getNamespaceURI());
        this.write(element);
        sOAPBody.appendChild(element);
        return element;
    }

    public void read(Element element) throws McMsgException {
        String string = this.getMcVersion().getNamespaceUri();
        String string2 = McConstants.Element.ADDRESS.getElementName();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            if (string.equals(element2.getNamespaceURI()) && string2.equals(element2.getLocalName())) {
                try {
                    this._address = DOMUtils.getTextData(element2);
                }
                catch (DOMProcessingException dOMProcessingException) {}
                continue;
            }
            this._otherList.add(new QName(element2.getNamespaceURI(), element2.getLocalName()));
        }
    }

    public void write(Element element) throws McMsgException {
        if (this._address == null) {
            throw new McMsgException(WseeMCLogger.logNoAddressLoggable().getMessage());
        }
        DOMUtils.addValueNS(element, this.getMcVersion().getNamespaceUri(), McConstants.Element.ADDRESS.getQualifiedName(this.getMcVersion()), this._address);
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.writeField(McConstants.Element.ADDRESS.getElementName(), this._address);
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }
}

