/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.processor;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.wsee.jaxws.persistence.PersistentMessage;
import weblogic.wsee.jaxws.persistence.PersistentMessageFactory;
import weblogic.wsee.mc.utils.McProtocolUtils;
import weblogic.wsee.persistence.Storable;

public class McPending
implements Storable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(McPending.class.getName());
    private String _id;
    private String _address;
    private long _creationTimestamp;
    private transient ReentrantReadWriteLock _messageLock;
    private transient List<PersistentMessage> _messages;
    private List<Long> _timestamps;
    private transient AddressingVersion _addressingVersion;
    private transient SOAPVersion _soapVersion;
    private transient int _removalAttempts;
    private transient int _successfulRemovalAttempts;
    private boolean _expired;
    private transient String _logicalStoreName;
    private transient String _physicalStoreName;

    public McPending() {
    }

    private void initTransients() {
        this._messageLock = new ReentrantReadWriteLock();
        this._addressingVersion = AddressingVersion.W3C;
        this._soapVersion = SOAPVersion.SOAP_11;
        this._removalAttempts = 0;
        this._successfulRemovalAttempts = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject("10.3.6");
        objectOutputStream.writeObject(this._addressingVersion.nsUri);
        objectOutputStream.writeObject(this._soapVersion.nsUri);
        try {
            this._messageLock.writeLock().lock();
            objectOutputStream.writeObject(this._messages);
            objectOutputStream.writeObject(this._timestamps);
        }
        finally {
            this._messageLock.writeLock().unlock();
        }
        objectOutputStream.defaultWriteObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.initTransients();
        objectInputStream.readObject();
        String string = (String)objectInputStream.readObject();
        this._addressingVersion = AddressingVersion.fromNsUri((String)string);
        String string2 = (String)objectInputStream.readObject();
        this._soapVersion = SOAPVersion.fromNsUri((String)string2);
        try {
            this._messageLock.writeLock().lock();
            this._messages = (List)objectInputStream.readObject();
            this._timestamps = (List)objectInputStream.readObject();
        }
        finally {
            this._messageLock.writeLock().unlock();
        }
        objectInputStream.defaultReadObject();
    }

    public McPending(String string, String string2, AddressingVersion addressingVersion, SOAPVersion sOAPVersion) {
        this.initTransients();
        this._id = string;
        this._logicalStoreName = string2;
        this._address = null;
        this._creationTimestamp = System.currentTimeMillis();
        this._addressingVersion = addressingVersion;
        this._soapVersion = sOAPVersion;
        this._messages = new ArrayList<PersistentMessage>();
        this._timestamps = new ArrayList<Long>();
        this._expired = false;
    }

    public String getId() {
        return this._id;
    }

    private ReentrantReadWriteLock getMessageLock() {
        return this._messageLock;
    }

    public int getRemovalAttempts() {
        return this._removalAttempts;
    }

    public int getSuccessfulRemovalAttempts() {
        return this._successfulRemovalAttempts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOldestTimestamp() {
        try {
            this.getMessageLock().readLock().lock();
            int n = this._timestamps.size();
            if (n == 0) {
                long l = -1L;
                return l;
            }
            long l = this._timestamps.get(0);
            return l;
        }
        finally {
            this.getMessageLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNewestTimestamp() {
        try {
            this.getMessageLock().readLock().lock();
            int n = this._timestamps.size();
            if (n == 0) {
                long l = -1L;
                return l;
            }
            long l = this._timestamps.get(n - 1);
            return l;
        }
        finally {
            this.getMessageLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet removeMessage(Packet packet) {
        try {
            Object object;
            PersistentMessageFactory persistentMessageFactory;
            block10: {
                ++this._removalAttempts;
                persistentMessageFactory = PersistentMessageFactory.getInstance();
                this.getMessageLock().writeLock().lock();
                try {
                    if (!this._messages.isEmpty()) break block10;
                    Packet packet2 = null;
                    return packet2;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    Packet packet3 = null;
                    return packet3;
                }
            }
            Packet packet4 = packet.copy(false);
            persistentMessageFactory.setMessageIntoPacket(this._messages.remove(0), packet4);
            this._timestamps.remove(0);
            ++this._successfulRemovalAttempts;
            if (LOGGER.isLoggable(Level.FINE)) {
                object = null;
                Message message = packet4.getMessage();
                if (message != null) {
                    object = message.getID(this._addressingVersion, this._soapVersion);
                }
                LOGGER.fine("Message with id " + (String)object + " removed from pending list " + McProtocolUtils.decodeId(this.getId()) + ", " + this._messages.size() + " message(s) now pending");
            }
            if (this.isEmpty()) {
                this._expired = true;
            }
            object = packet4;
            return object;
        }
        finally {
            this.getMessageLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        try {
            this.getMessageLock().readLock().lock();
            int n = this._messages.size();
            return n;
        }
        finally {
            this.getMessageLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        try {
            this.getMessageLock().readLock().lock();
            boolean bl = this._messages.isEmpty();
            return bl;
        }
        finally {
            this.getMessageLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(Packet packet) {
        this._expired = false;
        try {
            this.getMessageLock().writeLock().lock();
            String string = null;
            Message message = packet.getMessage();
            if (message != null) {
                string = message.getID(this._addressingVersion, this._soapVersion);
            }
            for (PersistentMessage persistentMessage : this._messages) {
                String string2 = persistentMessage.getMessage().getID(this._addressingVersion, this._soapVersion);
                if (!string2.equals(string)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Message with id " + string + " already added to pending list " + McProtocolUtils.decodeId(this.getId()));
                }
                return;
            }
            this._messages.add(PersistentMessageFactory.getInstance().createMessageFromPacket(string, packet));
            this._timestamps.add(System.currentTimeMillis());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Message with id " + string + " added to pending list " + McProtocolUtils.decodeId(this.getId()) + ", " + this._messages.size() + " message(s) now pending");
            }
        }
        finally {
            this.getMessageLock().writeLock().unlock();
        }
    }

    public String getAddress() {
        return this._address;
    }

    public void setAddress(String string) {
        this._address = string;
    }

    public long getCreationTimestamp() {
        return this._creationTimestamp;
    }

    public boolean isExpired() {
        return this._expired;
    }

    public boolean hasExplicitExpiration() {
        return true;
    }

    public String getLogicalStoreName() {
        return this._logicalStoreName;
    }

    public void setLogicalStoreName(String string) {
        this._logicalStoreName = string;
    }

    public String getPhysicalStoreName() {
        return this._physicalStoreName;
    }

    public void setPhysicalStoreName(String string) {
        this._physicalStoreName = string;
    }

    public Long getCreationTime() {
        return this._creationTimestamp;
    }

    public Long getLastUpdatedTime() {
        return this.getNewestTimestamp() > 0L ? this.getNewestTimestamp() : this.getCreationTimestamp();
    }

    public void touch() {
    }

    public Serializable getObjectId() {
        return this.getId();
    }
}

