/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.management.configuration.WebServiceLogicalStoreMBean;
import weblogic.management.configuration.WebServiceMBean;
import weblogic.management.configuration.WebServicePersistenceMBean;
import weblogic.wsee.WseeMCLogger;
import weblogic.wsee.config.WebServiceMBeanFactory;
import weblogic.wsee.mc.processor.McPending;
import weblogic.wsee.mc.processor.PendingStore;
import weblogic.wsee.mc.utils.McProtocolUtils;
import weblogic.wsee.persistence.LogicalStore;
import weblogic.wsee.persistence.LogicalStoreListChangeListener;
import weblogic.wsee.persistence.StoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class McPendingManager {
    private static final Logger LOGGER = Logger.getLogger(McPendingManager.class.getName());
    private static McPendingManager _instance;
    private final List<PendingStore> _stores;
    private final ReentrantReadWriteLock _storesLock = new ReentrantReadWriteLock(false);

    public static McPendingManager getInstance() {
        return _instance;
    }

    public McPendingManager() throws StoreException {
        this._stores = new ArrayList<PendingStore>();
        this.recover();
    }

    private void recover() throws StoreException {
        WebServiceLogicalStoreMBean[] webServiceLogicalStoreMBeanArray;
        WebServiceMBean webServiceMBean = WebServiceMBeanFactory.getInstance();
        WebServicePersistenceMBean webServicePersistenceMBean = webServiceMBean.getWebServicePersistence();
        for (WebServiceLogicalStoreMBean webServiceLogicalStoreMBean : webServiceLogicalStoreMBeanArray = webServicePersistenceMBean.getWebServiceLogicalStores()) {
            this.handleLogicalStoreAdded(webServiceLogicalStoreMBean.getName());
        }
        LogicalStore.addLogicalStoreListChangeListener(new LogicalStoreListChangeListener(){

            public void logicalStoreAdded(String string) {
                try {
                    McPendingManager.this.handleLogicalStoreAdded(string);
                }
                catch (Exception exception) {
                    WseeMCLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }

            public void logicalStorePreRemoval(String string) {
                try {
                    McPendingManager.this.handleLogicalStorePreRemoval(string);
                }
                catch (Exception exception) {
                    WseeMCLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }

            public void logicalStoreRemoved(String string) {
                try {
                    McPendingManager.this.handleLogicalStoreRemoved(string);
                }
                catch (Exception exception) {
                    WseeMCLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLogicalStoreAdded(String string) throws StoreException {
        try {
            this._storesLock.writeLock().lock();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Handling newly added logical store: " + string);
            }
            PendingStore pendingStore = this.getPendingStore(string);
            this._stores.add(pendingStore);
            if (LOGGER.isLoggable(Level.FINE)) {
                this.dumpLogicalStoreNames("Added");
                this.dumpPendings();
            }
        }
        finally {
            this._storesLock.writeLock().unlock();
        }
    }

    protected void handleLogicalStorePreRemoval(String string) throws StoreException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLogicalStoreRemoved(String string) throws StoreException {
        try {
            this._storesLock.writeLock().lock();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Handling newly removed logical store: " + string);
            }
            PendingStore pendingStore = null;
            for (PendingStore pendingStore2 : this._stores) {
                if (!pendingStore2.getName().equals(string)) continue;
                pendingStore = pendingStore2;
                break;
            }
            if (pendingStore != null) {
                this._stores.remove(pendingStore);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                this.dumpLogicalStoreNames("Removed");
                this.dumpPendings();
            }
        }
        finally {
            this._storesLock.writeLock().unlock();
        }
    }

    private void dumpLogicalStoreNames(String string) {
        Set<String> set = this.getPendingStoreNames();
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : set) {
            stringBuffer.append(string2).append(", ");
        }
        LOGGER.fine("These logical stores exist after one was " + string + ": " + stringBuffer.toString());
    }

    private void dumpPendings() {
        if (LOGGER.isLoggable(Level.FINER)) {
            Set<String> set = this.keySet();
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : set) {
                McPending mcPending = this.get(string);
                if (mcPending == null) continue;
                stringBuffer.append("   ").append(mcPending.getClass().getSimpleName()).append(": ").append(McProtocolUtils.decodeId(string)).append(" - ").append(mcPending.getLogicalStoreName()).append("\n");
            }
            LOGGER.finer("Current Pending Lists:\n" + stringBuffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        Exception exception = null;
        try {
            this._storesLock.writeLock().lock();
            for (PendingStore pendingStore : this._stores) {
                try {
                    pendingStore.close();
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
            }
        }
        finally {
            this._storesLock.writeLock().unlock();
        }
        super.finalize();
        if (exception != null) {
            throw exception;
        }
    }

    private PendingStore getPendingStore(String string) throws StoreException {
        return PendingStore.getStore(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPendingStoreNames() {
        try {
            this._storesLock.readLock().lock();
            HashSet<String> hashSet = new HashSet<String>();
            for (PendingStore pendingStore : this._stores) {
                hashSet.add(pendingStore.getName());
            }
            HashSet<String> hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    public PendingStore getPendingStoreForPending(McPending mcPending) {
        String string = mcPending.getLogicalStoreName();
        if (string == null) {
            throw new IllegalStateException("Pending List " + mcPending.getId() + " doesn't have a logical store name assigned to it!");
        }
        try {
            this._storesLock.readLock().lock();
            for (PendingStore pendingStore : this._stores) {
                if (!pendingStore.getName().equals(string)) continue;
                PendingStore pendingStore2 = pendingStore;
                return pendingStore2;
            }
            throw new IllegalStateException("Pending list " + mcPending.getId() + " refers to a logical store name for which there is no associated physical store: " + string);
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    public void addPending(McPending mcPending) {
        String string = mcPending.getId();
        if (!this.containsKey(string)) {
            this.put(string, mcPending);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Added management of pending list " + McProtocolUtils.decodeId(string) + ". Current count of lists: " + this.size());
            }
        }
    }

    public void updatePending(McPending mcPending) {
        this.put(mcPending.getId(), mcPending);
    }

    public McPending getPending(String string) {
        return this.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<McPending> values() {
        try {
            this._storesLock.readLock().lock();
            LinkedList linkedList = new LinkedList();
            for (PendingStore pendingStore : this._stores) {
                linkedList.addAll(pendingStore.values());
            }
            LinkedList linkedList2 = linkedList;
            return linkedList2;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int n = 0;
        try {
            this._storesLock.readLock().lock();
            for (PendingStore pendingStore : this._stores) {
                n += pendingStore.size();
            }
            int n2 = n;
            return n2;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        try {
            this._storesLock.readLock().lock();
            for (PendingStore pendingStore : this._stores) {
                if (!pendingStore.isEmpty()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object object) {
        try {
            this._storesLock.readLock().lock();
            for (PendingStore pendingStore : this._stores) {
                if (!pendingStore.containsKey(object)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object object) {
        try {
            this._storesLock.readLock().lock();
            for (PendingStore pendingStore : this._stores) {
                if (!pendingStore.containsValue(object)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public McPending get(String string) {
        try {
            this._storesLock.readLock().lock();
            for (PendingStore pendingStore : this._stores) {
                if (!pendingStore.containsKey(string)) continue;
                McPending mcPending = (McPending)pendingStore.get(string);
                return mcPending;
            }
            Iterator<PendingStore> iterator = null;
            return iterator;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    public McPending put(String string, McPending mcPending) {
        PendingStore pendingStore = this.getPendingStoreForPending(mcPending);
        return pendingStore.put(string, mcPending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public McPending remove(String string) {
        try {
            this._storesLock.writeLock().lock();
            for (PendingStore pendingStore : this._stores) {
                if (!pendingStore.containsKey(string)) continue;
                McPending mcPending = (McPending)pendingStore.remove(string);
                return mcPending;
            }
            Iterator<PendingStore> iterator = null;
            return iterator;
        }
        finally {
            this._storesLock.writeLock().unlock();
        }
    }

    public void putAll(Map<String, McPending> map) {
        for (String string : map.keySet()) {
            McPending mcPending = map.get(string);
            this.put(string, mcPending);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this._storesLock.writeLock().lock();
            for (PendingStore pendingStore : this._stores) {
                pendingStore.clear();
            }
        }
        finally {
            this._storesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet() {
        try {
            this._storesLock.readLock().lock();
            HashSet hashSet = new HashSet();
            for (PendingStore pendingStore : this._stores) {
                hashSet.addAll(pendingStore.keySet());
            }
            HashSet hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Map.Entry<String, McPending>> entrySet() {
        try {
            this._storesLock.readLock().lock();
            HashSet hashSet = new HashSet();
            for (PendingStore pendingStore : this._stores) {
                hashSet.addAll(pendingStore.entrySet());
            }
            HashSet hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    static {
        try {
            _instance = new McPendingManager();
        }
        catch (Exception exception) {
            WseeMCLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            throw new RuntimeException(exception.toString(), exception);
        }
    }
}

