/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.processor;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import weblogic.wsee.WseeMCLogger;
import weblogic.wsee.jaxws.framework.WsUtil;
import weblogic.wsee.jaxws.spi.ClientInstanceIdentity;
import weblogic.wsee.mc.processor.McPollManager;
import weblogic.wsee.mc.processor.McPollState;
import weblogic.wsee.persistence.Storable;
import weblogic.wsee.security.wssc.sct.SCCredential;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class McPoll
implements Storable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(McPoll.class.getName());
    private ClientInstanceIdentity _id;
    private Duration _expires;
    private Duration _interval;
    private boolean _backoff;
    private int _pollCount;
    private long _startTime;
    private transient ReentrantReadWriteLock _stateLock;
    private McPollState _state;
    private transient SCCredential _credential;
    private transient AddressingVersion _addressingVersion;
    private transient SOAPVersion _soapVersion;
    private transient WSEndpointReference _endpointRef;
    private transient String _logicalStoreName;
    private transient String _physicalStoreName;
    private transient ReentrantReadWriteLock _fiberLock;
    private transient Map<String, McPollManager.FiberBox> _fibers;
    private transient int _suspendedCount;
    private transient ReentrantReadWriteLock _persistentRequestsLock;
    private transient Map<String, String> _persistentRequests;

    public McPoll() {
    }

    private void initTransients() {
        this._stateLock = new ReentrantReadWriteLock();
        this._fiberLock = new ReentrantReadWriteLock();
        this._addressingVersion = AddressingVersion.W3C;
        this._soapVersion = SOAPVersion.SOAP_11;
        this._endpointRef = null;
        this._fibers = new HashMap<String, McPollManager.FiberBox>();
        this._suspendedCount = 0;
        this._persistentRequestsLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject("10.3.6");
        objectOutputStream.writeObject(this._addressingVersion.nsUri);
        objectOutputStream.writeObject(this._soapVersion.nsUri);
        WsUtil.serializeWSEndpointReference(this._endpointRef, objectOutputStream);
        try {
            this._stateLock.readLock().lock();
            objectOutputStream.writeObject((Object)this._state);
        }
        finally {
            this._stateLock.readLock().unlock();
        }
        try {
            this._persistentRequestsLock.writeLock().lock();
            objectOutputStream.writeObject(this._persistentRequests);
        }
        finally {
            this._persistentRequestsLock.writeLock().unlock();
        }
        objectOutputStream.defaultWriteObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.initTransients();
        objectInputStream.readObject();
        String string = (String)objectInputStream.readObject();
        this._addressingVersion = AddressingVersion.fromNsUri((String)string);
        String string2 = (String)objectInputStream.readObject();
        this._soapVersion = SOAPVersion.fromNsUri((String)string2);
        this._endpointRef = WsUtil.deserializeWSEndpointReference(objectInputStream, this.getAddressingVersion());
        try {
            this._stateLock.writeLock().lock();
            this._state = (McPollState)((Object)objectInputStream.readObject());
        }
        finally {
            this._stateLock.writeLock().unlock();
        }
        try {
            this._persistentRequestsLock.writeLock().lock();
            this._persistentRequests = (Map)objectInputStream.readObject();
        }
        finally {
            this._persistentRequestsLock.writeLock().unlock();
        }
        objectInputStream.defaultReadObject();
    }

    public McPoll(@NotNull ClientInstanceIdentity clientInstanceIdentity, @NotNull String string, @NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion) {
        this.initTransients();
        this._id = clientInstanceIdentity;
        this._logicalStoreName = string;
        this._addressingVersion = addressingVersion;
        this._soapVersion = sOAPVersion;
        try {
            this._expires = DatatypeFactory.newInstance().newDuration("P1D");
            this._interval = DatatypeFactory.newInstance().newDuration("PT10S");
            this._backoff = false;
            this._pollCount = 0;
            this._startTime = System.currentTimeMillis();
        }
        catch (Exception exception) {
            WseeMCLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
        }
        this._state = McPollState.ENABLED;
        this._persistentRequests = new HashMap<String, String>();
    }

    public String getId() {
        return this._id.getId();
    }

    public String getClientId() {
        return this._id.getClientId();
    }

    public Duration getExpires() {
        return this._expires;
    }

    public long getStartTime() {
        return this._startTime;
    }

    public Duration getInterval() {
        return this._interval;
    }

    public boolean isUseExponentialBackoff() {
        return this._backoff;
    }

    @Override
    public boolean isExpired() {
        return false;
    }

    private ReentrantReadWriteLock getStateLock() {
        return this._stateLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public McPollState getState() {
        try {
            this.getStateLock().readLock().lock();
            McPollState mcPollState = this._state;
            return mcPollState;
        }
        finally {
            this.getStateLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setState(McPollState mcPollState) {
        try {
            this.getStateLock().writeLock().lock();
            if (this._state.isValidTransition(mcPollState)) {
                this._state = mcPollState;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("MakeConnection poll " + this.getId() + " transitioned to state " + (Object)((Object)this._state));
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.getStateLock().writeLock().unlock();
        }
    }

    public void setExpires(Duration duration) {
        this._expires = duration;
    }

    public void setInterval(Duration duration) {
        this._interval = duration;
    }

    public void setExponentialBackoff(boolean bl) {
        this._backoff = bl;
    }

    public void incrementPollCount() {
        ++this._pollCount;
    }

    public int getPollCount() {
        return this._pollCount;
    }

    public void resetPollCount(boolean bl) {
        this._pollCount = bl ? -1 : 0;
    }

    public AddressingVersion getAddressingVersion() {
        return this._addressingVersion;
    }

    public void setAddressingVersion(AddressingVersion addressingVersion) {
        this._addressingVersion = addressingVersion;
    }

    public SOAPVersion getSoapVersion() {
        return this._soapVersion;
    }

    public void setSoapVersion(SOAPVersion sOAPVersion) {
        this._soapVersion = sOAPVersion;
    }

    public WSEndpointReference getEndpointReference() {
        return this._endpointRef;
    }

    public void setEndpointReference(WSEndpointReference wSEndpointReference) {
        this._endpointRef = wSEndpointReference;
    }

    public SCCredential getCredential() {
        return this._credential;
    }

    public void setCredential(SCCredential sCCredential) {
        this._credential = sCCredential;
    }

    @Override
    public boolean hasExplicitExpiration() {
        return false;
    }

    @Override
    public String getPhysicalStoreName() {
        return this._physicalStoreName;
    }

    public String getLogicalStoreName() {
        return this._logicalStoreName;
    }

    public void setLogicalStoreName(String string) {
        this._logicalStoreName = string;
    }

    @Override
    public void setPhysicalStoreName(String string) {
        this._physicalStoreName = string;
    }

    @Override
    public Long getCreationTime() {
        return this._startTime;
    }

    @Override
    public Long getLastUpdatedTime() {
        return this._startTime;
    }

    @Override
    public void touch() {
    }

    @Override
    public Serializable getObjectId() {
        return this.getId();
    }

    private ReentrantReadWriteLock getFiberLock() {
        return this._fiberLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFiber(String string, McPollManager.FiberBox fiberBox) {
        try {
            this.getFiberLock().writeLock().lock();
            this._fibers.put(string, fiberBox);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("MakeConnection poll " + this.getId() + " added fiber " + fiberBox.getName() + ", id " + string + " fiber count = " + this._fibers.size() + ", suspended fiber count = " + this.getSuspendedFiberCount());
            }
        }
        finally {
            this.getFiberLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getFiberKeySet() {
        try {
            this.getFiberLock().readLock().lock();
            Set<String> set = this._fibers.keySet();
            return set;
        }
        finally {
            this.getFiberLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public McPollManager.FiberBox removeFiber(String string) {
        try {
            this.getFiberLock().writeLock().lock();
            McPollManager.FiberBox fiberBox = this._fibers.remove(string);
            if (fiberBox != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("MakeConnection poll " + this.getId() + " removed fiber " + fiberBox.getName() + " fiber count = " + this._fibers.size() + ", suspended fiber count = " + this.getSuspendedFiberCount());
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("MakeConnection poll " + this.getId() + " no fiber with id " + string + " fiber count = " + this._fibers.size());
            }
            McPollManager.FiberBox fiberBox2 = fiberBox;
            return fiberBox2;
        }
        finally {
            this.getFiberLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public McPollManager.FiberBox getFiber(String string) {
        try {
            this.getFiberLock().readLock().lock();
            McPollManager.FiberBox fiberBox = this._fibers.get(string);
            return fiberBox;
        }
        finally {
            this.getFiberLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFiberCount() {
        try {
            this.getFiberLock().readLock().lock();
            int n = this._fibers.size();
            return n;
        }
        finally {
            this.getFiberLock().readLock().unlock();
        }
    }

    public void incrementSuspendedFiberCount() {
        ++this._suspendedCount;
    }

    public void decrementSuspendedFiberCount() {
        --this._suspendedCount;
    }

    public int getSuspendedFiberCount() {
        return this._suspendedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPersistentRequest(String string, String string2) {
        try {
            this._persistentRequestsLock.writeLock().lock();
            if (!this._persistentRequests.containsKey(string)) {
                this._persistentRequests.put(string, string2);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("MakeConnection poll " + this.getId() + " added request msg ID " + string + " and action '" + string2 + "''. PersistentRequest count = " + this._persistentRequests.size());
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("MakeConnection poll " + this.getId() + " bypassed adding request msg ID " + string + " because it already existed in this McPoll instance");
            }
        }
        finally {
            this._persistentRequestsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPersistentRequestAction(String string) {
        try {
            this._persistentRequestsLock.readLock().lock();
            String string2 = this._persistentRequests.get(string);
            return string2;
        }
        finally {
            this._persistentRequestsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPersistentRequestCount() {
        try {
            this._persistentRequestsLock.readLock().lock();
            int n = this._persistentRequests.size();
            return n;
        }
        finally {
            this._persistentRequestsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePersistentRequest(String string) {
        try {
            this._persistentRequestsLock.writeLock().lock();
            String string2 = this._persistentRequests.remove(string);
            if (string2 != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("MakeConnection poll " + this.getId() + " removed PersistentRequest msg ID " + string + " PersistentRequest count = " + this._persistentRequests.size());
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("MakeConnection poll " + this.getId() + " found NO PersistentRequest request with msg ID " + string);
            }
            boolean bl = string2 != null;
            return bl;
        }
        finally {
            this._persistentRequestsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsPersistentRequest(String string) {
        try {
            this._persistentRequestsLock.readLock().lock();
            boolean bl = this._persistentRequests.containsKey(string);
            return bl;
        }
        finally {
            this._persistentRequestsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearPersistentRequests() {
        try {
            this._persistentRequestsLock.writeLock().lock();
            this._persistentRequests.clear();
        }
        finally {
            this._persistentRequestsLock.writeLock().unlock();
        }
    }
}

