/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.processor;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.message.StringHeader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.soap.SOAPFaultException;
import weblogic.management.configuration.WebServiceLogicalStoreMBean;
import weblogic.management.configuration.WebServiceMBean;
import weblogic.management.configuration.WebServicePersistenceMBean;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.wsee.WseeMCLogger;
import weblogic.wsee.config.WebServiceMBeanFactory;
import weblogic.wsee.jaxws.spi.ClientInstance;
import weblogic.wsee.mc.exception.McException;
import weblogic.wsee.mc.exception.McMsgException;
import weblogic.wsee.mc.messages.McMsg;
import weblogic.wsee.mc.processor.McPoll;
import weblogic.wsee.mc.processor.McPollState;
import weblogic.wsee.mc.processor.PollStore;
import weblogic.wsee.mc.tube.McInitiatorDispatchFactory;
import weblogic.wsee.mc.tube.McSender;
import weblogic.wsee.mc.utils.McConstants;
import weblogic.wsee.mc.utils.McProtocolUtils;
import weblogic.wsee.persistence.LogicalStore;
import weblogic.wsee.persistence.LogicalStoreListChangeListener;
import weblogic.wsee.persistence.StoreException;
import weblogic.wsee.security.wssc.sct.SCCredential;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class McPollManager {
    private static final Logger LOGGER = Logger.getLogger(McPollManager.class.getName());
    private static McPollManager _instance;
    private final TimerManager _timerMgr;
    private final Map<McPoll, TimerInfo> _pollToTimerInfo;
    private final Map<McPoll, McSender> _pollToSender;
    private final Map<McPoll, ClientInstanceListener> _pollToListener;
    private final List<PollStore> _stores;
    private final ReentrantReadWriteLock _storesLock = new ReentrantReadWriteLock(false);

    public static McPollManager getInstance() {
        return _instance;
    }

    public McPollManager() throws StoreException {
        this._stores = new ArrayList<PollStore>();
        TimerManagerFactory timerManagerFactory = TimerManagerFactory.getTimerManagerFactory();
        this._timerMgr = timerManagerFactory.getDefaultTimerManager();
        this._pollToTimerInfo = new ConcurrentHashMap<McPoll, TimerInfo>();
        this._pollToSender = new ConcurrentHashMap<McPoll, McSender>();
        this._pollToListener = new ConcurrentHashMap<McPoll, ClientInstanceListener>();
    }

    private void recover() throws StoreException {
        WebServiceLogicalStoreMBean[] webServiceLogicalStoreMBeanArray;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Recovering McPoll instances in McPollManager");
        }
        WebServiceMBean webServiceMBean = WebServiceMBeanFactory.getInstance();
        WebServicePersistenceMBean webServicePersistenceMBean = webServiceMBean.getWebServicePersistence();
        for (WebServiceLogicalStoreMBean webServiceLogicalStoreMBean : webServiceLogicalStoreMBeanArray = webServicePersistenceMBean.getWebServiceLogicalStores()) {
            this.handleLogicalStoreAdded(webServiceLogicalStoreMBean.getName());
        }
        LogicalStore.addLogicalStoreListChangeListener(new LogicalStoreListChangeListener(){

            public void logicalStoreAdded(String string) {
                try {
                    McPollManager.this.handleLogicalStoreAdded(string);
                }
                catch (Exception exception) {
                    WseeMCLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }

            public void logicalStorePreRemoval(String string) {
                try {
                    McPollManager.this.handleLogicalStorePreRemoval(string);
                }
                catch (Exception exception) {
                    WseeMCLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }

            public void logicalStoreRemoved(String string) {
                try {
                    McPollManager.this.handleLogicalStoreRemoved(string);
                }
                catch (Exception exception) {
                    WseeMCLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLogicalStoreAdded(String string) throws StoreException {
        try {
            this._storesLock.writeLock().lock();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Handling newly added logical store: " + string);
            }
            PollStore pollStore = this.getPollStore(string);
            this._stores.add(pollStore);
            if (LOGGER.isLoggable(Level.FINE)) {
                this.dumpLogicalStoreNames("Added");
                this.dumpPolls();
            }
        }
        finally {
            this._storesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLogicalStorePreRemoval(String string) throws StoreException {
        PollStore pollStore = null;
        try {
            this._storesLock.readLock().lock();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Handling pre-removal of logical store: " + string);
            }
            for (PollStore pollStore2 : this._stores) {
                if (!pollStore2.getName().equals(string)) continue;
                pollStore = pollStore2;
                break;
            }
        }
        finally {
            this._storesLock.readLock().unlock();
        }
        if (pollStore != null) {
            pollStore.stopPollsInStore(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLogicalStoreRemoved(String string) throws StoreException {
        try {
            this._storesLock.writeLock().lock();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Handling newly removed logical store: " + string);
            }
            PollStore pollStore = null;
            for (PollStore pollStore2 : this._stores) {
                if (!pollStore2.getName().equals(string)) continue;
                pollStore = pollStore2;
                break;
            }
            if (pollStore != null) {
                this._stores.remove(pollStore);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                this.dumpLogicalStoreNames("Removed");
                this.dumpPolls();
            }
        }
        finally {
            this._storesLock.writeLock().unlock();
        }
    }

    private void dumpLogicalStoreNames(String string) {
        Set<String> set = this.getPollStoreNames();
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : set) {
            stringBuffer.append(string2).append(", ");
        }
        LOGGER.fine("These logical stores exist after one was " + string + ": " + stringBuffer.toString());
    }

    private void dumpPolls() {
        if (LOGGER.isLoggable(Level.FINER)) {
            Set<String> set = this.keySet();
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : set) {
                McPoll mcPoll = this.get(string);
                if (mcPoll == null) continue;
                stringBuffer.append("   ").append(mcPoll.getClass().getSimpleName()).append(": ").append(string).append(" - ").append(mcPoll.getLogicalStoreName()).append("\n");
            }
            LOGGER.finer("Current Polls:\n" + stringBuffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        Exception exception = null;
        try {
            this._storesLock.writeLock().lock();
            for (PollStore pollStore : this._stores) {
                try {
                    pollStore.close();
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
            }
        }
        finally {
            this._storesLock.writeLock().unlock();
        }
        super.finalize();
        if (exception != null) {
            throw exception;
        }
    }

    private PollStore getPollStore(String string) throws StoreException {
        return PollStore.getStore(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getPollStoreNames() {
        try {
            this._storesLock.readLock().lock();
            HashSet<String> hashSet = new HashSet<String>();
            for (PollStore pollStore : this._stores) {
                hashSet.add(pollStore.getName());
            }
            HashSet<String> hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    private PollStore getPollStoreForPoll(McPoll mcPoll) {
        String string = mcPoll.getLogicalStoreName();
        if (string == null) {
            throw new IllegalStateException("Poll " + mcPoll.getId() + " doesn't have a logical store name assigned to it!");
        }
        for (PollStore pollStore : this._stores) {
            if (!pollStore.getName().equals(string)) continue;
            return pollStore;
        }
        throw new IllegalStateException("Poll " + mcPoll.getId() + " refers to a logical store name for which there is no associated physical store: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoll(McPoll mcPoll, ClientInstance clientInstance) {
        McPoll mcPoll2 = mcPoll;
        synchronized (mcPoll2) {
            String string = mcPoll.getId();
            if (!this.containsKey(string)) {
                Object object;
                this.put(string, mcPoll);
                if (clientInstance != null) {
                    object = new ClientInstanceListener(mcPoll);
                    this._pollToListener.put(mcPoll, (ClientInstanceListener)object);
                    clientInstance.addClientInstanceListener(object);
                }
                object = new TimerInfo(mcPoll);
                this._pollToTimerInfo.put(mcPoll, (TimerInfo)object);
                this.schedulePoll(mcPoll);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Added poll " + string + " and started poll timers. Current poll list size: " + this.size());
                }
            } else {
                this.put(string, mcPoll);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePoll(McPoll mcPoll, ClientInstance clientInstance) {
        McPoll mcPoll2 = mcPoll;
        synchronized (mcPoll2) {
            String string = mcPoll.getId();
            if (!this.containsKey(string)) {
                this.addPoll(mcPoll, clientInstance);
                return;
            }
            this.put(string, mcPoll);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Updated poll " + string);
            }
        }
    }

    public McPoll getPoll(String string) {
        return this.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<McPoll> values() {
        try {
            this._storesLock.readLock().lock();
            LinkedList linkedList = new LinkedList();
            for (PollStore pollStore : this._stores) {
                linkedList.addAll(pollStore.values());
            }
            LinkedList linkedList2 = linkedList;
            return linkedList2;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int n = 0;
        try {
            this._storesLock.readLock().lock();
            for (PollStore pollStore : this._stores) {
                n += pollStore.size();
            }
            int n2 = n;
            return n2;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        try {
            this._storesLock.readLock().lock();
            for (PollStore pollStore : this._stores) {
                if (!pollStore.isEmpty()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object object) {
        try {
            this._storesLock.readLock().lock();
            for (PollStore pollStore : this._stores) {
                String string;
                if (!pollStore.containsKey(string = (String)object)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object object) {
        try {
            this._storesLock.readLock().lock();
            for (PollStore pollStore : this._stores) {
                McPoll mcPoll;
                if (!pollStore.containsValue(mcPoll = (McPoll)object)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public McPoll get(String string) {
        try {
            this._storesLock.readLock().lock();
            for (PollStore pollStore : this._stores) {
                if (!pollStore.containsKey(string)) continue;
                McPoll mcPoll = (McPoll)pollStore.get(string);
                return mcPoll;
            }
            Iterator<PollStore> iterator = null;
            return iterator;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public McPoll put(String string, McPoll mcPoll) {
        try {
            this._storesLock.writeLock().lock();
            PollStore pollStore = this.getPollStoreForPoll(mcPoll);
            McPoll mcPoll2 = pollStore.put(string, mcPoll);
            return mcPoll2;
        }
        finally {
            this._storesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public McPoll remove(String string) {
        try {
            this._storesLock.writeLock().lock();
            for (PollStore pollStore : this._stores) {
                if (!pollStore.containsKey(string)) continue;
                McPoll mcPoll = (McPoll)pollStore.remove(string);
                return mcPoll;
            }
            Iterator<PollStore> iterator = null;
            return iterator;
        }
        finally {
            this._storesLock.writeLock().unlock();
        }
    }

    public void putAll(Map<String, McPoll> map) {
        for (String string : map.keySet()) {
            McPoll mcPoll = map.get(string);
            this.put(string, mcPoll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this._storesLock.writeLock().lock();
            for (PollStore pollStore : this._stores) {
                pollStore.clear();
            }
        }
        finally {
            this._storesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet() {
        try {
            this._storesLock.readLock().lock();
            HashSet hashSet = new HashSet();
            for (PollStore pollStore : this._stores) {
                hashSet.addAll(pollStore.keySet());
            }
            HashSet hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Map.Entry<String, McPoll>> entrySet() {
        try {
            this._storesLock.readLock().lock();
            HashSet hashSet = new HashSet();
            for (PollStore pollStore : this._stores) {
                hashSet.addAll(pollStore.entrySet());
            }
            HashSet hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startPoll(McPoll mcPoll) {
        McPoll mcPoll2 = mcPoll;
        synchronized (mcPoll2) {
            TimerInfo timerInfo = new TimerInfo(mcPoll);
            this._pollToTimerInfo.put(mcPoll, timerInfo);
            this.schedulePoll(mcPoll);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Started poll timers for poll " + mcPoll.getId());
            }
        }
    }

    public void terminatePolling(String string) {
        this.stopPoll(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePoll(McPoll mcPoll) {
        McPoll mcPoll2 = mcPoll;
        synchronized (mcPoll2) {
            String string = mcPoll.getId();
            this.remove(string);
            TimerInfo timerInfo = this._pollToTimerInfo.remove(mcPoll);
            if (timerInfo != null) {
                timerInfo.cancelAll();
            }
            this._pollToSender.remove(mcPoll);
            ClientInstanceListener clientInstanceListener = this._pollToListener.remove(mcPoll);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Poll " + string + " removed");
            }
        }
    }

    void stopPoll(String string, boolean bl) {
        McPoll mcPoll = bl ? this.remove(string) : this.get(string);
        if (mcPoll != null) {
            TimerInfo timerInfo = this._pollToTimerInfo.remove(mcPoll);
            if (timerInfo != null) {
                timerInfo.cancelAll();
            }
            this._pollToSender.remove(mcPoll);
            this._pollToListener.remove(mcPoll);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Polling terminated for poll " + string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePoll(McPoll mcPoll) {
        McPoll mcPoll2 = mcPoll;
        synchronized (mcPoll2) {
            switch (mcPoll.getState()) {
                case ENABLED: 
                case POLLING: {
                    TimerInfo timerInfo = this._pollToTimerInfo.get(mcPoll);
                    if (timerInfo != null) {
                        timerInfo.resetIntervalTimer();
                    }
                    mcPoll.setState(McPollState.ENABLED);
                    break;
                }
                default: {
                    throw new IllegalStateException(WseeMCLogger.logIllegalPollStateLoggable((String)mcPoll.getState().toString()).getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void intervalTimeout(McPoll var1_1) {
        var2_2 = var1_1.getId();
        if (McPollManager.LOGGER.isLoggable(Level.FINE)) {
            McPollManager.LOGGER.fine("Polling interval expiration for poll " + var2_2);
        }
        if (this.get(var2_2) == null) {
            return;
        }
        if (var1_1.getState() == McPollState.ENABLED) {
            if (var1_1.getSuspendedFiberCount() > 0 || var1_1.getPollCount() == -1 || var1_1.getPersistentRequestCount() > 0) {
                var1_1.setState(McPollState.POLLING);
                var1_1.incrementPollCount();
                try {
                    this.sendMcMessage(var1_1);
                }
                catch (Exception var3_3) {
                    if (McPollManager.LOGGER.isLoggable(Level.FINE)) {
                        McPollManager.LOGGER.fine("Exception during polling for poll " + var2_2 + var3_3.getMessage());
                    }
                    WseeMCLogger.logUnexpectedException((String)var3_3.toString(), (Throwable)var3_3);
                    if (!(var3_3 instanceof SOAPException) && !(var3_3 instanceof SOAPFaultException) && !(var3_3 instanceof McException) && !(var3_3 instanceof McMsgException)) ** GOTO lbl47
                    var1_1.setState(McPollState.TERMINATED);
                    var4_5 = new HashSet<String>(var1_1.getFiberKeySet());
                    var5_6 = var1_1.getSoapVersion();
                    for (String var7_8 : var4_5) {
                        var8_9 = var1_1.getFiber(var7_8);
                        try {
                            var9_10 = var8_9.get();
                            var1_1.decrementSuspendedFiberCount();
                            var10_12 = SOAPFaultBuilder.createSOAPFaultMessage((SOAPVersion)var5_6, null, (Throwable)var3_3);
                            var11_13 = var9_10.getPacket().createClientResponse(var10_12);
                            var9_10.resume(var11_13);
                        }
                        catch (InterruptedException var9_11) {
                            if (McPollManager.LOGGER.isLoggable(Level.FINE)) {
                                McPollManager.LOGGER.log(Level.FINE, "IntervalTimeout failed for poll " + var2_2 + " " + var9_11.toString(), var9_11);
                            }
                            WseeMCLogger.logUnexpectedException((String)var3_3.toString(), (Throwable)var9_11);
                        }
                    }
                    var1_1.clearPersistentRequests();
                    this.removePoll(var1_1);
                    return;
                }
            } else if (McPollManager.LOGGER.isLoggable(Level.FINE)) {
                McPollManager.LOGGER.fine("Polling interval expiration for poll " + var2_2 + " However, there are no persistent requests or suspended fibers so no poll will be performed");
            }
        } else if (McPollManager.LOGGER.isLoggable(Level.FINE)) {
            McPollManager.LOGGER.fine("Polling interval expiration for poll " + var2_2 + " However, poll is in state " + (Object)var1_1.getState() + " so no poll will be performed");
        }
lbl47:
        // 6 sources

        var3_4 = var1_1;
        synchronized (var3_4) {
            if (var1_1.getFiberCount() > 0 || var1_1.getPollCount() == -1 || var1_1.getPersistentRequestCount() > 0) {
                if (McPollManager.LOGGER.isLoggable(Level.FINE)) {
                    McPollManager.LOGGER.fine("Scheduling poll for " + var2_2 + ", poll count = " + var1_1.getPollCount());
                }
                this.schedulePoll(var1_1);
            } else {
                if (McPollManager.LOGGER.isLoggable(Level.FINE)) {
                    McPollManager.LOGGER.fine("No fibers or persistent requests added to poll; terminating polling for " + var2_2);
                }
                this.removePoll(var1_1);
            }
        }
    }

    private void expirationTimeout(McPoll mcPoll) {
        String string = mcPoll.getId();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Polling lifetime expiration for poll " + string);
        }
        if (this.get(string) == null) {
            return;
        }
        mcPoll.setState(McPollState.EXPIRED);
        HashSet<String> hashSet = new HashSet<String>(mcPoll.getFiberKeySet());
        for (String string2 : hashSet) {
            FiberBox fiberBox = mcPoll.getFiber(string2);
            try {
                Fiber fiber = fiberBox.get();
                mcPoll.decrementSuspendedFiberCount();
                Packet packet = fiber.getPacket().createClientResponse(null);
                fiber.resume(packet);
            }
            catch (InterruptedException interruptedException) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "ExpirationTimeout failed for poll " + string + " " + interruptedException.toString(), interruptedException);
                }
                WseeMCLogger.logUnexpectedException((String)interruptedException.toString(), (Throwable)interruptedException);
            }
        }
        mcPoll.clearPersistentRequests();
        this.removePoll(mcPoll);
    }

    private void sendMcMessage(McPoll mcPoll) throws Exception {
        HashMap<String, Object> hashMap;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Sending MakeConnection message for poll " + mcPoll.getId() + ", poll count is " + mcPoll.getPollCount() + ", fiber count = " + mcPoll.getFiberCount() + ", suspended fiber count = " + mcPoll.getSuspendedFiberCount());
        }
        McMsg mcMsg = new McMsg();
        String string = McConstants.getAnonymousURITemplate(McConstants.McVersion.MC_11) + McProtocolUtils.encodeId(mcPoll.getId());
        mcMsg.setAddress(string);
        String string2 = mcPoll.getSoapVersion() == SOAPVersion.SOAP_12 ? "SOAP 1.2 Protocol" : "SOAP 1.1 Protocol";
        MessageFactory messageFactory = MessageFactory.newInstance((String)string2);
        SOAPMessage sOAPMessage = messageFactory.createMessage();
        mcMsg.writeIntoSOAPMsg(sOAPMessage);
        Message message = Messages.create((SOAPMessage)sOAPMessage);
        String string3 = McConstants.Action.MC.getActionURI(McConstants.McVersion.MC_11);
        StringHeader stringHeader = new StringHeader(mcPoll.getAddressingVersion().actionTag, string3);
        message.getHeaders().addOrReplace((Header)stringHeader);
        McSender mcSender = this.getSender(mcPoll);
        if (mcSender != null) {
            hashMap = new HashMap<String, Object>();
            SCCredential sCCredential = mcPoll.getCredential();
            if (sCCredential != null) {
                hashMap.put("weblogic.wsee.wssc.sct", sCCredential);
            }
        } else {
            throw new McException("Could not create sender for poll " + mcPoll.getId());
        }
        mcSender.send(message, string3, mcPoll.getEndpointReference(), null, null, hashMap);
    }

    private McSender getSender(McPoll mcPoll) {
        McSender mcSender = this._pollToSender.get(mcPoll);
        if (mcSender == null) {
            McInitiatorDispatchFactory mcInitiatorDispatchFactory = new McInitiatorDispatchFactory(mcPoll.getClientId());
            mcSender = new McSender(mcInitiatorDispatchFactory);
            this._pollToSender.put(mcPoll, mcSender);
        }
        return mcSender;
    }

    static {
        try {
            _instance = new McPollManager();
            _instance.recover();
        }
        catch (Exception exception) {
            WseeMCLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    private class ClientInstanceListener
    implements ClientInstance.Listener {
        private final McPoll _poll;

        private ClientInstanceListener(McPoll mcPoll) {
            this._poll = mcPoll;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clientInstanceClosing(ClientInstance clientInstance) {
            McPoll mcPoll = this._poll;
            synchronized (mcPoll) {
                TimerInfo timerInfo = (TimerInfo)McPollManager.this._pollToTimerInfo.get(this._poll);
                if (timerInfo != null) {
                    try {
                        Duration duration = DatatypeFactory.newInstance().newDuration("PT0S");
                        this._poll.setExpires(duration);
                        timerInfo.setExpirationTimer();
                    }
                    catch (Exception exception) {
                        WseeMCLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                    }
                }
            }
        }

        public void clientInstanceRecycled(ClientInstance clientInstance) {
        }
    }

    public static class FiberBox {
        private Semaphore lock = new Semaphore(0);
        private final Fiber fiber;
        private final String name;

        public FiberBox(Fiber fiber) {
            this.fiber = fiber;
            this.name = this.fiber.toString();
        }

        public void open() {
            if (this.lock != null) {
                this.lock.release();
            }
        }

        public Fiber get() throws InterruptedException {
            if (this.lock != null) {
                this.lock.acquire();
                this.lock = null;
            }
            return this.fiber;
        }

        public String getName() {
            return this.name;
        }
    }

    private class TimerInfo {
        private final McPoll _poll;
        private Timer _expirationTimer;
        private Timer _intervalTimer;

        private TimerInfo(McPoll mcPoll) {
            this._poll = mcPoll;
            this.setExpirationTimer();
        }

        private void setExpirationTimer() {
            if (this._expirationTimer != null) {
                this._expirationTimer.cancel();
            }
            long l = this._poll.getStartTime();
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            long l4 = this._poll.getExpires().getTimeInMillis(new Date());
            if ((l4 -= l3) < 0L) {
                l4 = 0L;
            }
            this._expirationTimer = McPollManager.this._timerMgr.schedule(new TimerListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void timerExpired(Timer timer) {
                    TimerInfo timerInfo = TimerInfo.this;
                    synchronized (timerInfo) {
                        McPollManager.this.expirationTimeout(TimerInfo.this._poll);
                    }
                }
            }, l4);
        }

        private void resetIntervalTimer() {
            long l;
            int n;
            if (this._intervalTimer != null) {
                this._intervalTimer.cancel();
            }
            if ((n = this._poll.getPollCount()) == -1) {
                l = 0L;
            } else {
                l = this._poll.getInterval().getTimeInMillis(new Date());
                if (this._poll.isUseExponentialBackoff() && n > 0) {
                    l = (long)(Math.random() * (Math.pow(2.0, n) * (double)l));
                }
            }
            this._intervalTimer = McPollManager.this._timerMgr.schedule(new TimerListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void timerExpired(Timer timer) {
                    TimerInfo timerInfo = TimerInfo.this;
                    synchronized (timerInfo) {
                        McPollManager.this.intervalTimeout(TimerInfo.this._poll);
                    }
                }
            }, l);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Scheduled interval timer " + l + " ms into the future");
            }
        }

        private synchronized void cancelAll() {
            if (this._expirationTimer != null) {
                this._expirationTimer.cancel();
                this._expirationTimer = null;
            }
            if (this._intervalTimer != null) {
                this._intervalTimer.cancel();
                this._intervalTimer = null;
            }
        }
    }
}

