/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.processor;

import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.wsee.mc.processor.McPoll;
import weblogic.wsee.mc.processor.McPollManager;
import weblogic.wsee.mc.processor.PollStoreConnection;
import weblogic.wsee.persistence.LogicalStore;
import weblogic.wsee.persistence.StoreConnection;
import weblogic.wsee.persistence.StoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PollStore
extends LogicalStore<String, McPoll> {
    private static final String CONNECTION_NAME = PollStore.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CONNECTION_NAME);
    private static final PollStore _instance = new PollStore();

    public static PollStore getStore(String string) throws StoreException {
        return (PollStore)_instance.getOrCreateLogicalStore(string, CONNECTION_NAME);
    }

    private PollStore() {
    }

    private PollStore(String string) throws StoreException {
        super(string, CONNECTION_NAME);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(" == PollStore created for " + this.getName() + " and connection " + CONNECTION_NAME);
        }
        this.addAvailablePhysicalStores();
    }

    public PollStore createLogicalStore(String string, String string2) throws StoreException {
        return new PollStore(string);
    }

    public PollStoreConnection createStoreConnection(String string, String string2) throws StoreException {
        return new PollStoreConnection(this.getName(), string, string2);
    }

    @Override
    public StoreConnection<String, McPoll> removePhysicalStore(String string) throws StoreException {
        PollStoreConnection pollStoreConnection = (PollStoreConnection)this.getStoreConnectionInternal(string);
        for (String string2 : pollStoreConnection.keySet()) {
            try {
                McPollManager.getInstance().stopPoll(string2, false);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.toString(), exception);
            }
        }
        return super.removePhysicalStore(string);
    }

    @Override
    public boolean addPhysicalStore(String string) throws StoreException {
        if (super.addPhysicalStore(string)) {
            PollStoreConnection pollStoreConnection = (PollStoreConnection)this.getStoreConnectionInternal(string);
            for (McPoll mcPoll : pollStoreConnection.values()) {
                McPollManager.getInstance().startPoll(mcPoll);
            }
            return true;
        }
        return false;
    }

    void stopPollsInStore(boolean bl) {
        for (String string : this.keySet()) {
            try {
                McPollManager.getInstance().stopPoll(string, bl);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.toString(), exception);
            }
        }
    }

    static {
        _instance.toString();
    }
}

