/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.tube;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.PropertySet;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.OneWayFeature;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.server.sei.CorrelationPropertySet;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.ws.WebServiceException;
import weblogic.jws.jaxws.client.async.AsyncClientHandlerFeature;
import weblogic.wsee.WseeMCLogger;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.JAXRPCEnvironmentFeature;
import weblogic.wsee.jaxws.persistence.PersistenceConfig;
import weblogic.wsee.jaxws.persistence.PersistentContext;
import weblogic.wsee.jaxws.persistence.PersistentContextStore;
import weblogic.wsee.jaxws.persistence.PersistentMessageFactory;
import weblogic.wsee.jaxws.spi.ClientInstance;
import weblogic.wsee.jaxws.spi.ClientInstanceIdentity;
import weblogic.wsee.jaxws.spi.ClientInstanceIdentityFeature;
import weblogic.wsee.mc.api.McFeature;
import weblogic.wsee.mc.api.McPolicyInfo;
import weblogic.wsee.mc.api.McPolicyInfoFactory;
import weblogic.wsee.mc.api.McPollingTimeoutException;
import weblogic.wsee.mc.exception.McException;
import weblogic.wsee.mc.headers.McHeaderFactory;
import weblogic.wsee.mc.headers.MessagePendingHeader;
import weblogic.wsee.mc.messages.McMsg;
import weblogic.wsee.mc.processor.McPending;
import weblogic.wsee.mc.processor.McPendingManager;
import weblogic.wsee.mc.processor.McPoll;
import weblogic.wsee.mc.processor.McPollManager;
import weblogic.wsee.mc.property.McPropertyBag;
import weblogic.wsee.mc.tube.McTubeUtils;
import weblogic.wsee.mc.utils.McConstants;
import weblogic.wsee.mc.utils.McProtocolUtils;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.reliability2.property.WsrmConfig;
import weblogic.wsee.reliability2.tube.WsrmClientRuntimeFeature;
import weblogic.wsee.security.wssc.sct.SCCredential;
import weblogic.wsee.security.wssp.handlers.WssHandlerListener;
import weblogic.wsee.ws.WsPort;

public class McInitiatorTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(McInitiatorTube.class.getName());
    private ClientTubeAssemblerContext _context;
    private WSBinding _binding;
    private AddressingVersion _addrVersion;
    private SOAPVersion _soapVersion;
    private String _defaultFaultAction;
    private McFeature _mcFeature;
    private WSDLPort _wsdlPort;
    private WSService _service;
    private URL _url;
    private McPolicyInfo _policy;
    private ClientInstanceIdentity _clientInstanceIdentity;
    private boolean _configChecked;
    private Duration _intervalDuration;
    private Duration _expirationDuration;
    private boolean _exponentialBackoff;
    private static final Object _createPollLock = "CreatePollLock";
    private static final Object _createPendingLock = "CreatePendingLock";

    public McInitiatorTube(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext) {
        super(tube);
        WSBinding wSBinding = clientTubeAssemblerContext.getBinding();
        WSDLPort wSDLPort = clientTubeAssemblerContext.getWsdlModel();
        WSService wSService = clientTubeAssemblerContext.getService();
        this.commonConstructorCode(clientTubeAssemblerContext, wSBinding, wSDLPort, wSService);
        McPollManager.getInstance();
    }

    public McInitiatorTube(McInitiatorTube mcInitiatorTube, TubeCloner tubeCloner) {
        super((AbstractFilterTubeImpl)mcInitiatorTube, tubeCloner);
        this.commonConstructorCode(mcInitiatorTube._context, mcInitiatorTube._binding, mcInitiatorTube._wsdlPort, mcInitiatorTube._service);
    }

    private void commonConstructorCode(ClientTubeAssemblerContext clientTubeAssemblerContext, WSBinding wSBinding, WSDLPort wSDLPort, WSService wSService) {
        this._context = clientTubeAssemblerContext;
        this._binding = wSBinding;
        this._addrVersion = wSBinding.getAddressingVersion();
        this._soapVersion = wSBinding.getSOAPVersion();
        this._defaultFaultAction = this._addrVersion.getDefaultFaultAction();
        this._mcFeature = (McFeature)wSBinding.getFeature(McFeature.class);
        this._wsdlPort = wSDLPort;
        this._service = wSService;
        this._configChecked = false;
        ClientInstanceIdentityFeature clientInstanceIdentityFeature = (ClientInstanceIdentityFeature)wSBinding.getFeature(ClientInstanceIdentityFeature.class);
        this._clientInstanceIdentity = clientInstanceIdentityFeature.getClientInstanceId();
        String string = this._clientInstanceIdentity.getId();
        this.setReplyTo(string);
        this.setMcPolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public NextAction processRequest(@NotNull Packet packet) {
        String string;
        ClientInstanceIdentity clientInstanceIdentity;
        McPropertyBag mcPropertyBag = McPropertyBag.propertySetRetriever.getFromPacket(packet);
        McPropertyBag.flagPersistentPropsOnPacket(packet);
        Message message = packet.getMessage();
        if (message == null) {
            LOGGER.log(Level.FINE, "processRequest: passing null request message on");
            return this.doInvoke(this.next, packet);
        }
        HeaderList headerList = message.getHeaders();
        String string2 = headerList.getAction(this._addrVersion, this._soapVersion);
        mcPropertyBag.setRqstAction(string2);
        WeakReference weakReference = (WeakReference)packet.invocationProperties.get("weblogic.wsee.jaxws.spi.ClientInstanceWeakRef");
        ClientInstance clientInstance = weakReference != null ? (ClientInstance)weakReference.get() : null;
        ClientInstanceIdentity clientInstanceIdentity2 = clientInstanceIdentity = clientInstance != null ? clientInstance.getId() : null;
        if (clientInstanceIdentity == null) {
            clientInstanceIdentity = this._clientInstanceIdentity;
        }
        String string3 = string = clientInstanceIdentity != null ? clientInstanceIdentity.getId() : null;
        if (LOGGER.isLoggable(Level.FINE)) {
            if (string == null) {
                LOGGER.fine("processRequest: null client instance identity. Action = " + string2);
            } else {
                LOGGER.fine("processRequest: non-null outgoing request message. Action= " + string2 + " client instance " + string);
            }
        }
        if (!McConstants.Action.MC.matchesAnyMCVersion(string2)) {
            boolean bl = McTubeUtils.isMcAnonURI(packet.endpointAddress);
            if (bl) {
                McPending mcPending;
                McPendingManager mcPendingManager = McPendingManager.getInstance();
                String string4 = McTubeUtils.getUUID(packet.endpointAddress);
                Object object = _createPendingLock;
                synchronized (object) {
                    mcPending = mcPendingManager.getPending(string4);
                    if (mcPending == null) {
                        PersistenceConfig.Client client = PersistenceConfig.getClientConfig(this._context);
                        String string5 = client.getLogicalStoreName();
                        mcPending = new McPending(string4, string5, this._addrVersion, this._soapVersion);
                        mcPending.setAddress(this._url.getPath());
                        mcPendingManager.addPending(mcPending);
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    object = headerList.getRelatesTo(this._addrVersion, this._soapVersion);
                    LOGGER.log(Level.FINE, "processRequest: adding packet to pending list, target: " + packet.endpointAddress + " action = " + string2 + " relatesTo " + (String)object);
                }
                mcPending.addMessage(packet);
                mcPendingManager.updatePending(mcPending);
                packet.setMessage(null);
                return this.doReturnWith(packet);
            }
            WSEndpointReference wSEndpointReference = headerList.getReplyTo(this._addrVersion, this._soapVersion);
            WSEndpointReference wSEndpointReference2 = headerList.getFaultTo(this._addrVersion, this._soapVersion);
            if (wSEndpointReference2 == null) {
                wSEndpointReference2 = wSEndpointReference;
            }
            boolean bl2 = McTubeUtils.isMcAnonURI(wSEndpointReference);
            boolean bl3 = McTubeUtils.isMcAnonURI(wSEndpointReference2);
            if (!(this._policy.isMcOptional() || bl2 && bl3)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "processRequest failed: policy required mandatory MC anonymous URI(s)");
                }
                return this.doThrow(new McException(WseeMCLogger.logPolicyURIMismatchLoggable().getMessage()));
            }
            McTubeUtils.setMessageID(message, this._addrVersion, this._soapVersion);
            mcPropertyBag.setPollId(string);
            mcPropertyBag.setIsPoll(false);
            mcPropertyBag.setMsgId(headerList.getMessageID(this._addrVersion, this._soapVersion));
            McPollManager mcPollManager = McPollManager.getInstance();
            Object object = _createPollLock;
            synchronized (object) {
                if (packet.expectReply.booleanValue() && (bl2 || bl3)) {
                    McPoll mcPoll;
                    if (!this._configChecked) {
                        this.checkMcConfig();
                    }
                    if ((mcPoll = mcPollManager.getPoll(string)) == null) {
                        SecurityHanlderListener securityHanlderListener;
                        PersistenceConfig.Client client = PersistenceConfig.getClientConfig(this._context);
                        String string6 = client.getLogicalStoreName();
                        mcPoll = new McPoll(clientInstanceIdentity, string6, this._addrVersion, this._soapVersion);
                        SCCredential sCCredential = null;
                        if (packet.proxy != null) {
                            sCCredential = (SCCredential)packet.proxy.getRequestContext().get("weblogic.wsee.wssc.sct");
                        }
                        if (sCCredential == null) {
                            sCCredential = (SCCredential)packet.invocationProperties.get("weblogic.wsee.wssc.sct");
                        }
                        if (sCCredential == null) {
                            securityHanlderListener = new SecurityHanlderListener(mcPoll);
                            securityHanlderListener.init(packet);
                        } else {
                            mcPoll.setCredential(sCCredential);
                        }
                        mcPoll.setExpires(this._expirationDuration);
                        mcPoll.setInterval(this._intervalDuration);
                        mcPoll.setExponentialBackoff(this._exponentialBackoff);
                        securityHanlderListener = new WSEndpointReference(packet.endpointAddress.getURI(), this._addrVersion);
                        mcPoll.setEndpointReference((WSEndpointReference)securityHanlderListener);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "processRequest: adding new poll for " + string);
                        }
                        mcPollManager.addPoll(mcPoll, clientInstance);
                        this.addRequest(mcPollManager, packet, mcPoll, string2, headerList, clientInstance);
                    } else {
                        McPoll mcPoll2 = mcPoll;
                        synchronized (mcPoll2) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, "processRequest: poll already exists for " + string);
                            }
                            switch (mcPoll.getState()) {
                                case EXPIRED: {
                                    return this.doThrow((Throwable)((Object)new McPollingTimeoutException()));
                                }
                                case TERMINATED: {
                                    return this.doThrow(new WebServiceException("MakeConnection polling already terminated for " + string));
                                }
                            }
                            this.addRequest(mcPollManager, packet, mcPoll, string2, headerList, clientInstance);
                        }
                    }
                } else if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "processRequest: no fiber added to poll " + string + " as either a one-way message or non MC uri for replyTo/faultTo");
                }
            }
            return this.doInvoke(this.next, packet);
        }
        McMsg mcMsg = new McMsg();
        try {
            mcMsg.readFromSOAPMsg(message.readAsSOAPMessage());
        }
        catch (SOAPException sOAPException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "processRequest failed: exception reading SOAP message: " + (Object)((Object)sOAPException));
            }
            WseeMCLogger.logUnexpectedException((String)sOAPException.toString(), (Throwable)sOAPException);
            return this.doThrow(sOAPException);
        }
        String string7 = mcMsg.getAddress();
        String string8 = McTubeUtils.getUUID(string7);
        mcPropertyBag.setPollId(McProtocolUtils.decodeId(string8));
        mcPropertyBag.setIsPoll(true);
        McTubeUtils.setMessageID(message, this._addrVersion, this._soapVersion);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Processing outbound MakeConnection message for poll " + string8);
        }
        return this.doInvoke(this.next, packet);
    }

    private void addRequest(McPollManager mcPollManager, Packet packet, McPoll mcPoll, String string, HeaderList headerList, ClientInstance clientInstance) {
        String string2 = headerList.getMessageID(this._addrVersion, this._soapVersion);
        if (this._binding.isFeatureEnabled(AsyncClientHandlerFeature.class)) {
            this.savePersistentContext(packet, headerList.getMessageID(this._addrVersion, this._soapVersion));
            mcPoll.addPersistentRequest(string2, string);
        } else if (mcPoll.getFiber(string2) == null) {
            McPollManager.FiberBox fiberBox = new McPollManager.FiberBox(Fiber.current());
            mcPoll.addFiber(string2, fiberBox);
        }
        mcPollManager.updatePoll(mcPoll, clientInstance);
    }

    @NotNull
    public NextAction processResponse(@NotNull Packet packet) {
        McPropertyBag mcPropertyBag = McPropertyBag.propertySetRetriever.getFromPacket(packet);
        McPollManager mcPollManager = McPollManager.getInstance();
        String string = mcPropertyBag.getPollId();
        boolean bl = mcPropertyBag.getIsPoll();
        McPoll mcPoll = mcPollManager.getPoll(string);
        try {
            if (bl) {
                return this.handlePollResponse(packet, string, mcPoll);
            }
            return this.handleNonPolledResponse(packet, mcPropertyBag, string, mcPoll);
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "processResponse failed: " + exception.toString(), exception);
            }
            WseeMCLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            this.doThrow(exception);
            return this.doReturnWith(packet);
        }
    }

    private NextAction handleNonPolledResponse(Packet packet, McPropertyBag mcPropertyBag, String string, McPoll mcPoll) {
        if (mcPoll == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                if (packet.getMessage() != null) {
                    HeaderList headerList = packet.getMessage().getHeaders();
                    String string2 = headerList.getAction(this._addrVersion, this._soapVersion);
                    String string3 = headerList.getMessageID(this._addrVersion, this._soapVersion);
                    LOGGER.log(Level.FINE, "processResponse: poll " + string + " doesn't exist, passing through response with action " + string2 + " and message id " + string3);
                }
                LOGGER.log(Level.FINE, "processResponse: poll " + string + " doesn't exist, passing through response with no message");
            }
            return this.doReturnWith(packet);
        }
        if (packet.getMessage() == null) {
            switch (mcPoll.getState()) {
                case ENABLED: 
                case POLLING: {
                    McPollManager.FiberBox fiberBox = mcPoll.getFiber(mcPropertyBag.getMsgId());
                    if (fiberBox != null) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "processResponse: suspending fiber " + mcPropertyBag.getMsgId() + " for poll " + string);
                        }
                        packet.addSatellite((PropertySet)new CorrelationPropertySet(mcPropertyBag.getRqstAction()));
                        fiberBox.open();
                        mcPoll.incrementSuspendedFiberCount();
                        return this.doSuspend();
                    }
                    if (mcPoll.containsPersistentRequest(mcPropertyBag.getMsgId())) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "processResponse: no response message received. Looking for response to persistent request msg id " + mcPropertyBag.getMsgId());
                        }
                        NextAction nextAction = new NextAction();
                        nextAction.abortResponse(packet);
                        return nextAction;
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "processResponse: no fiber box or persistent request found for poll " + string + " with id " + mcPropertyBag.getMsgId());
                    }
                    return this.doReturnWith(packet);
                }
                case EXPIRED: {
                    return this.doThrow((Throwable)((Object)new McPollingTimeoutException()));
                }
                case TERMINATED: {
                    return this.doReturnWith(packet);
                }
            }
            WseeMCLogger.logUnexpectedResponse((String)mcPoll.getId(), (String)mcPoll.getState().toString());
            return this.doReturnWith(packet);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "processResponse: passing along response for poll " + string);
        }
        HeaderList headerList = packet.getMessage().getHeaders();
        String string4 = headerList.getAction(this._addrVersion, this._soapVersion);
        this.setupCorrelationPropertySetIfNeeded(packet, mcPropertyBag.getRqstAction(), string4);
        return this.doReturnWith(packet);
    }

    private void setupCorrelationPropertySetIfNeeded(Packet packet, String string, String string2) {
        if (this._defaultFaultAction.equals(string2)) {
            packet.addSatellite((PropertySet)new CorrelationPropertySet(string));
        }
    }

    private void savePersistentContext(Packet packet, String string) {
        PersistentContext persistentContext = PersistentMessageFactory.getInstance().createContextFromPacket(string, packet);
        PersistenceConfig.Client client = PersistenceConfig.getClientConfig(this._context);
        PersistentContext.getStoreMap(client.getLogicalStoreName()).put(string, persistentContext);
    }

    private void setupPersistentContext(Packet packet, String string) {
        PersistenceConfig.Client client = PersistenceConfig.getClientConfig(this._context);
        PersistentContextStore persistentContextStore = PersistentContext.getStoreMap(client.getLogicalStoreName());
        PersistentContext persistentContext = (PersistentContext)persistentContextStore.get(string);
        if (persistentContext != null) {
            String string2 = (String)packet.get((Object)"javax.xml.ws.soap.http.soapaction.uri");
            PersistentMessageFactory.getInstance().setContextIntoPacket(persistentContext, packet);
            packet.put("javax.xml.ws.soap.http.soapaction.uri", (Object)string2);
            persistentContext.setState(PersistentContext.State.UNUSED);
        }
    }

    private NextAction handlePollResponse(Packet packet, String string, McPoll mcPoll) throws InterruptedException {
        if (mcPoll == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "processResponse: no poll instance for poll " + string);
            }
            packet.setMessage(null);
            return this.doReturnWith(packet);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Handling poll response for poll " + string);
        }
        switch (mcPoll.getState()) {
            case POLLING: {
                if (packet.getMessage() == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Handled poll response with null message for poll " + string);
                    }
                    return this.doReturnWith(packet);
                }
                this.handlePolledResponseMsg(packet, string, mcPoll);
                return this.doReturnWith(packet);
            }
            case EXPIRED: {
                return this.doThrow((Throwable)((Object)new McPollingTimeoutException()));
            }
            case TERMINATED: {
                packet.setMessage(null);
                return this.doReturnWith(packet);
            }
        }
        WseeMCLogger.logUnexpectedResponse((String)mcPoll.getId(), (String)mcPoll.getState().toString());
        packet.setMessage(null);
        return this.doReturnWith(packet);
    }

    private void handlePolledResponseMsg(Packet packet, String string, McPoll mcPoll) throws InterruptedException {
        Object object;
        HeaderList headerList;
        boolean bl;
        block13: {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Handling poll response message for poll " + string);
            }
            bl = false;
            headerList = packet.getMessage().getHeaders();
            Header header = headerList.get(McConstants.Element.MESSAGE_PENDING.getQName(McConstants.McVersion.MC_11), false);
            if (header != null) {
                try {
                    object = McHeaderFactory.getInstance().createMcHeaderFromHeader(MessagePendingHeader.class, header);
                    if (object != null && ((MessagePendingHeader)object).getPending()) {
                        bl = true;
                    }
                }
                catch (MsgHeaderException msgHeaderException) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block13;
                    LOGGER.log(Level.FINE, "processResponse failed: " + msgHeaderException.toString(), msgHeaderException);
                }
            }
        }
        mcPoll.resetPollCount(bl);
        object = headerList.getRelatesTo(this._addrVersion, this._soapVersion);
        if (this._binding.isFeatureEnabled(AsyncClientHandlerFeature.class)) {
            String string2 = packet.getMessage().getHeaders().getAction(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
            if (packet.soapAction == null) {
                packet.soapAction = "\"" + string2 + "\"";
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Handling poll response with AsyncClientHandlerFeature with RelatesTo " + (String)object + " and action " + string2 + " for poll " + string);
            }
            this.setupCorrelationPropertySetIfNeeded(packet, mcPoll.getPersistentRequestAction((String)object), string2);
            this.setupPersistentContext(packet, (String)object);
            mcPoll.removePersistentRequest((String)object);
            McPollManager.getInstance().updatePoll(mcPoll, null);
        } else {
            McPollManager.FiberBox fiberBox = mcPoll.getFiber((String)object);
            if (fiberBox == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "processResponse: no suspended fiber for poll " + string + " with id " + (String)object);
                }
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "processResponse: suspended fiber found for poll " + string + " with id " + (String)object);
                }
                Fiber fiber = fiberBox.get();
                mcPoll.decrementSuspendedFiberCount();
                mcPoll.removeFiber((String)object);
                Packet packet2 = fiber.getPacket().createClientResponse(packet.getMessage());
                packet2.wasTransportSecure = packet.wasTransportSecure;
                fiber.resume(packet2);
                packet.setMessage(null);
            }
        }
    }

    @NotNull
    public NextAction processException(@NotNull Throwable throwable) {
        return this.doThrow(throwable);
    }

    private void setMcPolicy() {
        EnvironmentFactory environmentFactory = JAXRPCEnvironmentFeature.getFactory(this._binding, this._service, this._wsdlPort);
        EnvironmentFactory.SingletonService singletonService = environmentFactory.getService();
        QName qName = environmentFactory.getPort().getName();
        WsPort wsPort = singletonService.getPort(qName.getLocalPart());
        PolicyServer policyServer = singletonService.getPolicyServer();
        try {
            NormalizedExpression normalizedExpression = policyServer.getEndpointPolicy(wsPort.getWsdlPort());
            this._policy = McPolicyInfoFactory.getInstance(normalizedExpression);
        }
        catch (PolicyException policyException) {
            WseeMCLogger.logUnexpectedException((String)policyException.toString(), (Throwable)policyException);
            throw new RuntimeException(policyException.toString(), policyException);
        }
    }

    private void setReplyTo(String string) {
        WSEndpointReference wSEndpointReference;
        String string2;
        if (this._context.getAddress().toString().equals(this._addrVersion.anonymousUri)) {
            string2 = this._wsdlPort.getAddress().toString();
            wSEndpointReference = new WSEndpointReference(string2, this._addrVersion);
            this._url = this._wsdlPort.getAddress().getURL();
        } else {
            string2 = McConstants.getAnonymousURITemplate(McConstants.McVersion.MC_11) + McProtocolUtils.encodeId(string);
            wSEndpointReference = new WSEndpointReference(string2, this._addrVersion);
            this._url = null;
        }
        string2 = (OneWayFeature)this._binding.getFeature(OneWayFeature.class);
        string2.setReplyTo(wSEndpointReference);
        if (this._mcFeature.isUseMcWithSyncInvoke()) {
            string2.setUseAsyncWithSyncInvoke(true);
        }
    }

    private void checkMcConfig() {
        this._exponentialBackoff = this._mcFeature.isUseExponentialBackoff();
        try {
            WsrmConfig.Source source;
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            this._intervalDuration = datatypeFactory.newDuration(this._mcFeature.getInterval());
            this._expirationDuration = datatypeFactory.newDuration(this._mcFeature.getExpires());
            if (this._binding.getFeatures().isEnabled(WsrmClientRuntimeFeature.class) && (source = WsrmConfig.getSource(this._context, null, false)) != null) {
                boolean bl;
                String string = source.getBaseRetransmissionInterval();
                Duration duration = datatypeFactory.newDuration(string);
                if (!this._intervalDuration.isShorterThan(duration)) {
                    Duration duration2 = datatypeFactory.newDuration(3000L);
                    this._intervalDuration = duration.isLongerThan(duration2) ? duration.subtract(duration2) : duration;
                }
                if (!(bl = source.getRetransmissionExponentialBackoff().booleanValue())) {
                    this._exponentialBackoff = false;
                }
            }
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "setMcConfig failed: " + datatypeConfigurationException.toString(), datatypeConfigurationException);
            }
            WseeMCLogger.logUnexpectedException((String)datatypeConfigurationException.toString(), (Throwable)datatypeConfigurationException);
        }
        this._configChecked = true;
    }

    public void preDestroy() {
        if (this.next != null) {
            this.next.preDestroy();
        }
    }

    public AbstractTubeImpl copy(TubeCloner tubeCloner) {
        return new McInitiatorTube(this, tubeCloner);
    }

    private class SecurityHanlderListener
    extends WssHandlerListener {
        private McPoll poll = null;

        public SecurityHanlderListener(McPoll mcPoll) {
            this.poll = mcPoll;
        }

        public void init(Packet packet) {
            SecurityHanlderListener.registerToProperties(packet.invocationProperties, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postHandlingRequest(MessageContext messageContext) {
            if (this.poll == null) {
                return;
            }
            try {
                this.processSCCredential(messageContext);
            }
            catch (Exception exception) {
                LOGGER.log(Level.FINE, "SCCredential processing failed: " + exception.toString(), exception);
            }
            finally {
                if (this.poll.getCredential() != null) {
                    this.poll = null;
                }
            }
        }

        private void processSCCredential(MessageContext messageContext) {
            Map map = (Map)messageContext.getProperty("weblogic.wsee.invoke_properties");
            SCCredential sCCredential = map != null ? (SCCredential)map.get("weblogic.wsee.wssc.sct") : (SCCredential)messageContext.getProperty("weblogic.wsee.wssc.sct");
            this.poll.setCredential(sCCredential);
        }

        public boolean isDisposed() {
            return this.poll == null;
        }
    }
}

