/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.tube;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.server.WSEndpointImpl;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.ws.WebServiceException;
import weblogic.wsee.WseeMCLogger;
import weblogic.wsee.jaxws.MonitoringPipe;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.JAXRPCEnvironmentFeature;
import weblogic.wsee.jaxws.persistence.PersistenceConfig;
import weblogic.wsee.mc.api.McPolicyInfo;
import weblogic.wsee.mc.api.McPolicyInfoFactory;
import weblogic.wsee.mc.exception.McException;
import weblogic.wsee.mc.faults.MissingSelectionFaultMsg;
import weblogic.wsee.mc.faults.UnsupportedSelectionFaultMsg;
import weblogic.wsee.mc.headers.MessagePendingHeader;
import weblogic.wsee.mc.mbean.WseeMcRuntimeMBeanImpl;
import weblogic.wsee.mc.messages.McMsg;
import weblogic.wsee.mc.processor.McPending;
import weblogic.wsee.mc.processor.McPendingManager;
import weblogic.wsee.mc.tube.McTubeUtils;
import weblogic.wsee.mc.utils.McConstants;
import weblogic.wsee.mc.utils.McProtocolUtils;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.ws.WsPort;

public class McReceiverTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(McReceiverTube.class.getName());
    private ServerTubeAssemblerContext _context;
    private WSEndpointImpl _endpoint;
    private WSBinding _binding;
    private AddressingVersion _addrVersion;
    private SOAPVersion _soapVersion;
    private WSDLPort _wsdlPort;
    private McPolicyInfo _policy;
    private McTubeUtils _tubeUtils;
    private static final Object _createPendingLock = "CreatePendingLock";

    public McReceiverTube(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
        super(tube);
        WSEndpoint wSEndpoint = serverTubeAssemblerContext.getEndpoint();
        WSBinding wSBinding = serverTubeAssemblerContext.getEndpoint().getBinding();
        WSDLPort wSDLPort = serverTubeAssemblerContext.getWsdlModel();
        this.commonConstructorCode(serverTubeAssemblerContext, wSEndpoint, wSBinding, wSDLPort);
    }

    public McReceiverTube(McReceiverTube mcReceiverTube, TubeCloner tubeCloner) {
        super((AbstractFilterTubeImpl)mcReceiverTube, tubeCloner);
        this.commonConstructorCode(mcReceiverTube._context, (WSEndpoint)mcReceiverTube._endpoint, mcReceiverTube._binding, mcReceiverTube._wsdlPort);
    }

    private void commonConstructorCode(ServerTubeAssemblerContext serverTubeAssemblerContext, WSEndpoint wSEndpoint, WSBinding wSBinding, WSDLPort wSDLPort) {
        this._context = serverTubeAssemblerContext;
        this._endpoint = (WSEndpointImpl)wSEndpoint;
        this._binding = wSBinding;
        this._addrVersion = wSBinding.getAddressingVersion();
        this._soapVersion = wSBinding.getSOAPVersion();
        this._wsdlPort = wSDLPort;
        this.setMcPolicy();
        this._tubeUtils = new McTubeUtils((WSEndpoint)this._endpoint, null, this._binding);
    }

    @NotNull
    public NextAction processRequest(@NotNull Packet packet) {
        Object object;
        Message message = packet.getMessage();
        if (message == null) {
            return this.doInvoke(this.next, packet);
        }
        HeaderList headerList = message.getHeaders();
        String string = headerList.getAction(this._addrVersion, this._soapVersion);
        McPendingManager mcPendingManager = McPendingManager.getInstance();
        if (!McConstants.Action.MC.matchesAnyMCVersion(string)) {
            WSEndpointReference wSEndpointReference = headerList.getReplyTo(this._addrVersion, this._soapVersion);
            WSEndpointReference wSEndpointReference2 = headerList.getFaultTo(this._addrVersion, this._soapVersion);
            if (wSEndpointReference2 == null) {
                wSEndpointReference2 = wSEndpointReference;
            }
            boolean bl = McTubeUtils.isMcAnonURI(wSEndpointReference);
            boolean bl2 = McTubeUtils.isMcAnonURI(wSEndpointReference2);
            if (!(this._policy.isMcOptional() || bl && bl2)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "processRequest failed: policy required mandatory MC anonymous URI(s)");
                }
                return this.doThrow(new McException(WseeMCLogger.logPolicyURIMismatchLoggable().getMessage()));
            }
            return this.doInvoke(this.next, packet);
        }
        McMsg mcMsg = new McMsg();
        try {
            mcMsg.readFromSOAPMsg(message.readAsSOAPMessage());
        }
        catch (SOAPException sOAPException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "processRequest failed: exception reading SOAP message: " + (Object)((Object)sOAPException));
            }
            WseeMCLogger.logUnexpectedException((String)sOAPException.toString(), (Throwable)sOAPException);
            return this.doThrow(sOAPException);
        }
        List<QName> list = mcMsg.getOther();
        if (list.size() > 0) {
            Message message2;
            UnsupportedSelectionFaultMsg unsupportedSelectionFaultMsg = new UnsupportedSelectionFaultMsg(McConstants.McVersion.MC_11);
            unsupportedSelectionFaultMsg.setUnsupported(list);
            try {
                message2 = McProtocolUtils.createMessageFromFaultMessage(unsupportedSelectionFaultMsg, this._addrVersion, this._soapVersion);
            }
            catch (SOAPException sOAPException) {
                WseeMCLogger.logUnexpectedException((String)sOAPException.toString(), (Throwable)sOAPException);
                return this.doThrow(sOAPException);
            }
            return this.doReturnWith(packet.createServerResponse(message2, this._addrVersion, this._soapVersion, null));
        }
        String string2 = mcMsg.getAddress();
        if (string2 == null) {
            Message message3;
            MissingSelectionFaultMsg missingSelectionFaultMsg = new MissingSelectionFaultMsg(McConstants.McVersion.MC_11);
            try {
                message3 = McProtocolUtils.createMessageFromFaultMessage(missingSelectionFaultMsg, this._addrVersion, this._soapVersion);
            }
            catch (SOAPException sOAPException) {
                WseeMCLogger.logUnexpectedException((String)sOAPException.toString(), (Throwable)sOAPException);
                return this.doThrow(sOAPException);
            }
            return this.doReturnWith(packet.createServerResponse(message3, this._addrVersion, this._soapVersion, null));
        }
        boolean bl = McTubeUtils.isMcAnonURI(string2);
        if (!bl) {
            return this.doReturnWith(packet.createServerResponse(null, this._addrVersion, this._soapVersion, null));
        }
        String string3 = McTubeUtils.getUUID(string2);
        McPending mcPending = mcPendingManager.getPending(string3);
        if (mcPending == null) {
            return this.doReturnWith(packet.createServerResponse(null, this._addrVersion, this._soapVersion, null));
        }
        String string4 = mcPending.getAddress();
        if (string4 == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "processRequest: no address associated with pending list, target: " + McProtocolUtils.decodeId(string3));
            }
            return this.doReturnWith(packet.createServerResponse(null, this._addrVersion, this._soapVersion, null));
        }
        if (!string4.equals(McTubeUtils.getUriPattern(packet))) {
            return this.doThrow(new WebServiceException("MakeConnection sent to different service address than original request that used the shared MC anon URI. Anon URI=" + string2 + " Original request address: " + string4 + " Address of MakeConnection: " + McTubeUtils.getUriPattern(packet)));
        }
        Packet packet2 = mcPending.removeMessage(packet);
        if (packet2 == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "processRequest: no pending packet in store, target: " + McProtocolUtils.decodeId(string3));
            }
            return this.doReturnWith(packet.createServerResponse(null, this._addrVersion, this._soapVersion, null));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            object = packet2.getMessage().getHeaders();
            String string5 = object.getAction(this._addrVersion, this._soapVersion);
            LOGGER.log(Level.FINE, "processRequest: removed pending packet from store, target: " + McProtocolUtils.decodeId(string3) + " action = " + string5);
        }
        mcPendingManager.updatePending(mcPending);
        if (mcPending.size() > 0) {
            object = new MessagePendingHeader();
            ((MessagePendingHeader)object).setPending(true);
            headerList = packet2.getMessage().getHeaders();
            headerList.addOrReplace((Header)object);
        }
        return this.doReturnWith(packet2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public NextAction processResponse(@NotNull Packet packet) {
        McPending mcPending;
        Message message = packet.getMessage();
        if (message == null) {
            return this.doReturnWith(packet);
        }
        WSEndpointReference wSEndpointReference = (WSEndpointReference)packet.get((Object)"com.sun.xml.ws.addressing.WsaPropertyBag.ReplyToFromRequest");
        WSEndpointReference wSEndpointReference2 = (WSEndpointReference)packet.get((Object)"com.sun.xml.ws.addressing.WsaPropertyBag.FaultToFromRequest");
        if (wSEndpointReference2 == null) {
            wSEndpointReference2 = wSEndpointReference;
        }
        WSEndpointReference wSEndpointReference3 = message.isFault() ? wSEndpointReference2 : wSEndpointReference;
        HeaderList headerList = message.getHeaders();
        String string = headerList.getAction(this._addrVersion, this._soapVersion);
        if (!McTubeUtils.isMcAnonURI(wSEndpointReference3)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "processResponse: non MC anon target msg being passed through, target: " + wSEndpointReference3.getAddress() + " action: " + string);
            }
            return this.doReturnWith(packet);
        }
        McPendingManager mcPendingManager = McPendingManager.getInstance();
        String string2 = McTubeUtils.getUUID(wSEndpointReference3);
        Object object = _createPendingLock;
        synchronized (object) {
            Object object2;
            mcPending = mcPendingManager.getPending(string2);
            if (mcPending == null) {
                object2 = PersistenceConfig.getServiceConfig(this._context);
                String string3 = ((PersistenceConfig.Common)object2).getLogicalStoreName();
                mcPending = new McPending(string2, string3, this._addrVersion, this._soapVersion);
                mcPending.setAddress(McTubeUtils.getUriPattern((WSEndpoint)this._endpoint));
                mcPendingManager.addPending(mcPending);
            }
            if ((object2 = McTubeUtils.getMcRuntimeFromPacket(packet)) != null) {
                ((WseeMcRuntimeMBeanImpl)object2).addAnonymousEndpointId(string2);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            object = headerList.getRelatesTo(this._addrVersion, this._soapVersion);
            LOGGER.log(Level.FINE, "processResponse: adding packet to pending list, target: " + McProtocolUtils.decodeId(string2) + " action = " + string + " relatesTo " + (String)object);
        }
        mcPending.addMessage(packet);
        mcPendingManager.updatePending(mcPending);
        packet.setMessage(null);
        object = (MonitoringPipe.MonitoringPropertySet)packet.getSatellite(MonitoringPipe.MonitoringPropertySet.class);
        if (object != null) {
            ((MonitoringPipe.MonitoringPropertySet)((Object)object)).setOpName("Ws-Protocol");
        }
        return this.doReturnWith(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public NextAction processException(@NotNull Throwable throwable) {
        McPending mcPending;
        Packet packet = Fiber.current().getPacket();
        WSEndpointReference wSEndpointReference = (WSEndpointReference)packet.get((Object)"com.sun.xml.ws.addressing.WsaPropertyBag.FaultToFromRequest");
        if (!McTubeUtils.isMcAnonURI(wSEndpointReference)) {
            return this.doThrow(throwable);
        }
        Packet packet2 = packet.createServerResponse(SOAPFaultBuilder.createSOAPFaultMessage((SOAPVersion)this._soapVersion, null, (Throwable)throwable), this._wsdlPort, packet.endpoint.getSEIModel(), this._binding);
        McPendingManager mcPendingManager = McPendingManager.getInstance();
        String string = McTubeUtils.getUUID(wSEndpointReference);
        Object object = _createPendingLock;
        synchronized (object) {
            Object object2;
            mcPending = mcPendingManager.getPending(string);
            if (mcPending == null) {
                object2 = PersistenceConfig.getServiceConfig(this._context);
                String string2 = ((PersistenceConfig.Common)object2).getLogicalStoreName();
                mcPending = new McPending(string, string2, this._addrVersion, this._soapVersion);
                mcPending.setAddress(McTubeUtils.getUriPattern((WSEndpoint)this._endpoint));
                mcPendingManager.addPending(mcPending);
            }
            if ((object2 = McTubeUtils.getMcRuntimeFromPacket(packet2)) != null) {
                ((WseeMcRuntimeMBeanImpl)object2).addAnonymousEndpointId(string);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "processException: adding pending packet to store, target: " + McProtocolUtils.decodeId(string));
        }
        mcPending.addMessage(packet2);
        mcPendingManager.updatePending(mcPending);
        packet2 = packet2.copy(false);
        return this.doReturnWith(packet2);
    }

    private void setMcPolicy() {
        EnvironmentFactory environmentFactory = JAXRPCEnvironmentFeature.getFactory(this._endpoint);
        EnvironmentFactory.SingletonService singletonService = environmentFactory.getService();
        QName qName = environmentFactory.getPort().getName();
        WsPort wsPort = singletonService.getPort(qName.getLocalPart());
        PolicyServer policyServer = singletonService.getPolicyServer();
        try {
            NormalizedExpression normalizedExpression = policyServer.getEndpointPolicy(wsPort.getWsdlPort());
            this._policy = McPolicyInfoFactory.getInstance(normalizedExpression);
        }
        catch (PolicyException policyException) {
            WseeMCLogger.logUnexpectedException((String)policyException.toString(), (Throwable)policyException);
            throw new RuntimeException(policyException.toString(), policyException);
        }
    }

    public void preDestroy() {
        if (this.next != null) {
            this.next.preDestroy();
        }
    }

    public AbstractTubeImpl copy(TubeCloner tubeCloner) {
        return new McReceiverTube(this, tubeCloner);
    }
}

