/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.tube;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Response;
import javax.xml.ws.soap.SOAPFaultException;
import weblogic.wsee.mc.tube.McDispatchFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class McSender {
    private static final Logger LOGGER = Logger.getLogger(McSender.class.getName());
    @NotNull
    private McDispatchFactory _dispatchFactory;

    public McSender(@NotNull McDispatchFactory mcDispatchFactory) {
        this._dispatchFactory = mcDispatchFactory;
    }

    public void send(@NotNull Message message, @Nullable String string, @NotNull WSEndpointReference wSEndpointReference, @Nullable WSEndpointReference wSEndpointReference2, @Nullable WSEndpointReference wSEndpointReference3) throws Exception {
        this.send(message, string, wSEndpointReference, wSEndpointReference2, wSEndpointReference3, new HashMap<String, Object>());
    }

    public void send(@NotNull Message message, @Nullable String string, @NotNull WSEndpointReference wSEndpointReference, @Nullable WSEndpointReference wSEndpointReference2, @Nullable WSEndpointReference wSEndpointReference3, @NotNull Map<String, Object> map) throws Exception {
        this.send(message, string, wSEndpointReference, wSEndpointReference2, wSEndpointReference3, map, false);
    }

    public void send(@NotNull Message message, @Nullable String string, @NotNull WSEndpointReference wSEndpointReference, @Nullable WSEndpointReference wSEndpointReference2, @Nullable WSEndpointReference wSEndpointReference3, @NotNull Map<String, Object> map, boolean bl) throws Exception {
        Response response;
        Message message2;
        if (wSEndpointReference2 == null) {
            wSEndpointReference2 = wSEndpointReference.getVersion().anonymousEpr;
        }
        if (wSEndpointReference3 == null) {
            wSEndpointReference3 = wSEndpointReference.getVersion().anonymousEpr;
        }
        Dispatch<Message> dispatch = this._dispatchFactory.createDispatch(wSEndpointReference, Message.class);
        dispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.uri", string);
        dispatch.getRequestContext().putAll(map);
        Header header = wSEndpointReference2.createHeader(wSEndpointReference2.getVersion().replyToTag);
        message.getHeaders().addOrReplace(header);
        header = wSEndpointReference3.createHeader(wSEndpointReference3.getVersion().faultToTag);
        message.getHeaders().addOrReplace(header);
        wSEndpointReference.addReferenceParameters(message.getHeaders());
        if (wSEndpointReference2.isAnonymous()) {
            message2 = (Message)dispatch.invoke((Object)message);
        } else {
            message2 = null;
            response = dispatch.invokeAsync((Object)message);
            if (bl) {
                while (response.getContext() == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("McSender is polling for result of action '" + string + "' from service at address: " + wSEndpointReference.getAddress());
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                message2 = (Message)response.get();
            }
        }
        if (message2 != null && message2.isFault()) {
            response = message2.readAsSOAPMessage();
            SOAPBody sOAPBody = response.getSOAPBody();
            SOAPFault sOAPFault = sOAPBody.getFault();
            throw new SOAPFaultException(sOAPFault);
        }
    }
}

