/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.tube;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.message.StringHeader;
import com.sun.xml.ws.server.WSEndpointImpl;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;
import weblogic.kernel.KernelStatus;
import weblogic.management.runtime.WseeBasePortRuntimeMBean;
import weblogic.management.runtime.WseeV2RuntimeMBean;
import weblogic.wsee.mc.mbean.WseeMcRuntimeMBeanImpl;
import weblogic.wsee.mc.utils.McConstants;
import weblogic.wsee.mc.utils.McProtocolUtils;
import weblogic.wsee.monitoring.WseePortRuntimeMBeanImpl;

public class McTubeUtils {
    private static String ANON_URI_TEMPLATE = McConstants.getAnonymousURITemplate(McConstants.McVersion.MC_11);
    private WSEndpoint _endpoint;
    private WSService _service;
    private WSBinding _binding;

    public McTubeUtils(@Nullable WSEndpoint wSEndpoint, @Nullable WSService wSService, @NotNull WSBinding wSBinding) {
        this._endpoint = wSEndpoint;
        this._binding = wSBinding;
        this._service = wSService;
    }

    public static WSEndpointReference getEndpointReferenceFromIncomingPacket(@NotNull Packet packet, @NotNull WSEndpointImpl wSEndpointImpl) {
        String string = packet.webServiceContextDelegate.getEPRAddress(packet, (WSEndpoint)wSEndpointImpl);
        String string2 = null;
        if (wSEndpointImpl.getServiceDefinition() != null) {
            string2 = packet.webServiceContextDelegate.getWSDLAddress(packet, (WSEndpoint)wSEndpointImpl);
        }
        Class<W3CEndpointReference> clazz = W3CEndpointReference.class;
        return wSEndpointImpl.getWSEndpointReference(clazz, string, string2, new Element[0]);
    }

    public static void setMessageID(Message message, AddressingVersion addressingVersion, SOAPVersion sOAPVersion) {
        String string = message.getHeaders().getMessageID(addressingVersion, sOAPVersion);
        if (string == null) {
            string = McProtocolUtils.generateUUID();
            StringHeader stringHeader = new StringHeader(addressingVersion.messageIDTag, string);
            message.getHeaders().add((Header)stringHeader);
        }
    }

    public static boolean isMcAnonURI(WSEndpointReference wSEndpointReference) {
        if (wSEndpointReference != null) {
            String string = wSEndpointReference.getAddress();
            return string.startsWith(ANON_URI_TEMPLATE) && string.length() > ANON_URI_TEMPLATE.length();
        }
        return false;
    }

    public static boolean isMcAnonURI(EndpointAddress endpointAddress) {
        if (endpointAddress != null) {
            String string = endpointAddress.toString();
            return string.startsWith(ANON_URI_TEMPLATE) && string.length() > ANON_URI_TEMPLATE.length();
        }
        return false;
    }

    public static boolean isMcAnonURI(String string) {
        if (string != null) {
            return string.startsWith(ANON_URI_TEMPLATE) && string.length() > ANON_URI_TEMPLATE.length();
        }
        return false;
    }

    public static String getUUID(WSEndpointReference wSEndpointReference) {
        String string = wSEndpointReference.getAddress();
        return string.substring(ANON_URI_TEMPLATE.length());
    }

    public static String getUUID(EndpointAddress endpointAddress) {
        String string = endpointAddress.toString();
        return string.substring(ANON_URI_TEMPLATE.length());
    }

    public static String getUUID(String string) {
        return string.substring(ANON_URI_TEMPLATE.length());
    }

    public static String getUriPattern(@NotNull Packet packet) {
        WseeV2RuntimeMBean wseeV2RuntimeMBean = (WseeV2RuntimeMBean)packet.component.getSPI(WseeV2RuntimeMBean.class);
        if (wseeV2RuntimeMBean != null) {
            return wseeV2RuntimeMBean.getURI();
        }
        return null;
    }

    public static String getUriPattern(@NotNull WSEndpoint wSEndpoint) {
        WseeV2RuntimeMBean wseeV2RuntimeMBean = (WseeV2RuntimeMBean)wSEndpoint.getSPI(WseeV2RuntimeMBean.class);
        if (wseeV2RuntimeMBean != null) {
            return wseeV2RuntimeMBean.getURI();
        }
        return null;
    }

    public static String getUniqueName(@NotNull Packet packet) {
        WseeV2RuntimeMBean wseeV2RuntimeMBean = (WseeV2RuntimeMBean)packet.component.getSPI(WseeV2RuntimeMBean.class);
        if (wseeV2RuntimeMBean != null) {
            return wseeV2RuntimeMBean.getName();
        }
        return null;
    }

    @Nullable
    public static WseeMcRuntimeMBeanImpl getMcRuntimeFromPacket(Packet packet) {
        if (KernelStatus.isServer()) {
            WseeBasePortRuntimeMBean wseeBasePortRuntimeMBean = WseePortRuntimeMBeanImpl.getFromPacket(packet);
            WseeMcRuntimeMBeanImpl wseeMcRuntimeMBeanImpl = McTubeUtils.getMcRuntimeFromPortRuntime(wseeBasePortRuntimeMBean);
            return wseeMcRuntimeMBeanImpl;
        }
        return null;
    }

    private static WseeMcRuntimeMBeanImpl getMcRuntimeFromPortRuntime(WseeBasePortRuntimeMBean wseeBasePortRuntimeMBean) {
        WseeMcRuntimeMBeanImpl wseeMcRuntimeMBeanImpl = null;
        try {
            if (wseeBasePortRuntimeMBean == null) {
                throw new IllegalStateException("Couldn't find WseePortRuntimeMBean for port");
            }
            wseeMcRuntimeMBeanImpl = (WseeMcRuntimeMBeanImpl)wseeBasePortRuntimeMBean.getMc();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return wseeMcRuntimeMBeanImpl;
    }
}

