/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.tube;

import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.OneWayFeature;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.developer.MemberSubmissionAddressingFeature;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import weblogic.jws.jaxws.client.ClientIdentityFeature;
import weblogic.jws.jaxws.client.async.AsyncClientTransportFeature;
import weblogic.wsee.WseeMCLogger;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.JAXRPCEnvironmentFeature;
import weblogic.wsee.jaxws.tubeline.AbstractTubeFactory;
import weblogic.wsee.jaxws.tubeline.TubeFactory;
import weblogic.wsee.jaxws.tubeline.TubelineAssemblerItem;
import weblogic.wsee.jaxws.tubeline.TubelineDeploymentListener;
import weblogic.wsee.mc.api.McFeature;
import weblogic.wsee.mc.internal.MCSupported;
import weblogic.wsee.mc.tube.McInitiatorTube;
import weblogic.wsee.mc.tube.McReceiverTube;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.ws.WsPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class McTubelineDeploymentListener
implements TubelineDeploymentListener {
    public static final String MC_INITIATOR_TUBE = "McInitiator";
    public static final String MC_RECEIVER_TUBE = "McReceiver";
    private static final Logger LOGGER = Logger.getLogger(McTubelineDeploymentListener.class.getName());

    @Override
    public void createClient(ClientTubeAssemblerContext clientTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
        Object object;
        boolean bl;
        NormalizedExpression normalizedExpression;
        EnvironmentFactory environmentFactory = JAXRPCEnvironmentFeature.getFactory(clientTubeAssemblerContext);
        if (environmentFactory == null) {
            return;
        }
        EnvironmentFactory.SingletonService singletonService = environmentFactory.getService();
        if (singletonService == null) {
            return;
        }
        WSDLPort wSDLPort = environmentFactory.getPort();
        if (wSDLPort == null) {
            return;
        }
        QName qName = wSDLPort.getName();
        WsPort wsPort = singletonService.getPort(qName.getLocalPart());
        PolicyServer policyServer = singletonService.getPolicyServer();
        try {
            normalizedExpression = policyServer.getEndpointPolicy(wsPort.getWsdlPort());
        }
        catch (PolicyException policyException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Exception getting policy for " + clientTubeAssemblerContext.getService().getServiceName());
            }
            WseeMCLogger.logUnexpectedException((String)policyException.toString(), (Throwable)policyException);
            return;
        }
        MCSupported mCSupported = (MCSupported)normalizedExpression.getPolicyAssertion(MCSupported.class);
        if (mCSupported == null) {
            return;
        }
        Object object2 = clientTubeAssemblerContext.getBinding();
        Object object3 = (AsyncClientTransportFeature)object2.getFeature(AsyncClientTransportFeature.class);
        boolean bl2 = bl = object3 != null && object3.isEnabled();
        if (bl) {
            if (mCSupported.isOptional()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("AsyncClientTransportFeature is enabled, so MakeConnection won't be enabled by the optional MC assertion");
                }
                return;
            }
            throw new WebServiceException(WseeMCLogger.logCannotUseAsyncClientTransportLoggable().getMessage());
        }
        if (mCSupported.isOptional()) {
            object = (McFeature)object2.getFeature(McFeature.class);
            EndpointAddress endpointAddress = clientTubeAssemblerContext.getAddress();
            AddressingVersion addressingVersion = object2.getAddressingVersion();
            if (!(object != null && object.isEnabled() || addressingVersion != null && endpointAddress.toString().equals(addressingVersion.anonymousUri))) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("No user-defined MC feature, so MakeConnection won't be enabled by the optional MC assertion");
                }
                return;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating MakeConnection initiator tubeline items for " + clientTubeAssemblerContext.getService().getServiceName());
        }
        object2 = new AbstractTubeFactory(){

            public Tube createClient(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext) {
                ClientIdentityFeature clientIdentityFeature;
                McFeature mcFeature;
                WSBinding wSBinding = clientTubeAssemblerContext.getBinding();
                WebServiceFeatureList webServiceFeatureList = (WebServiceFeatureList)wSBinding.getFeatures();
                if (!webServiceFeatureList.isEnabled(McFeature.class)) {
                    mcFeature = new McFeature();
                    webServiceFeatureList.add((WebServiceFeature)mcFeature);
                } else {
                    mcFeature = (McFeature)wSBinding.getFeature(McFeature.class);
                }
                if (!webServiceFeatureList.isEnabled(MemberSubmissionAddressingFeature.class) && !webServiceFeatureList.isEnabled(AddressingFeature.class)) {
                    webServiceFeatureList.add((WebServiceFeature)new AddressingFeature(true));
                }
                if (!webServiceFeatureList.isEnabled(OneWayFeature.class)) {
                    webServiceFeatureList.add((WebServiceFeature)new OneWayFeature(true));
                }
                if ((clientIdentityFeature = (ClientIdentityFeature)webServiceFeatureList.get(ClientIdentityFeature.class)) == null || clientIdentityFeature.getRawClientId() == null) {
                    throw new IllegalStateException(WseeMCLogger.logClientIdentityNotProvidedLoggable().getMessage());
                }
                mcFeature.setBinding(clientTubeAssemblerContext.getBinding());
                return new McInitiatorTube(tube, clientTubeAssemblerContext);
            }
        };
        object3 = new TubelineAssemblerItem(MC_INITIATOR_TUBE, (TubeFactory)object2);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("WS_SECURITY_1.1");
        hashSet.add("PRE_WS_SECURITY_POLICY_1.2");
        ((TubelineAssemblerItem)object3).setGoAfter(hashSet);
        object = new HashSet();
        object.add("WsrmClient");
        object.add("ADDRESSING_HANDLER");
        object.add("client");
        ((TubelineAssemblerItem)object3).setGoBefore((Set<String>)object);
        set.add((TubelineAssemblerItem)object3);
    }

    @Override
    public void createServer(ServerTubeAssemblerContext serverTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
        NormalizedExpression normalizedExpression;
        EnvironmentFactory environmentFactory = JAXRPCEnvironmentFeature.getFactory(serverTubeAssemblerContext.getEndpoint());
        if (environmentFactory == null) {
            return;
        }
        WSDLPort wSDLPort = environmentFactory.getPort();
        if (wSDLPort == null) {
            return;
        }
        EnvironmentFactory.SingletonService singletonService = environmentFactory.getService();
        if (singletonService == null) {
            return;
        }
        QName qName = wSDLPort.getName();
        WsPort wsPort = singletonService.getPort(qName.getLocalPart());
        PolicyServer policyServer = singletonService.getPolicyServer();
        if (policyServer == null) {
            return;
        }
        try {
            normalizedExpression = policyServer.getEndpointPolicy(wsPort.getWsdlPort());
        }
        catch (PolicyException policyException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Exception getting policy for " + serverTubeAssemblerContext.getEndpoint().getServiceName());
            }
            WseeMCLogger.logUnexpectedException((String)policyException.toString(), (Throwable)policyException);
            return;
        }
        if (!normalizedExpression.containsPolicyAssertion(MCSupported.class)) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating MakeConnection server tubeline items for " + serverTubeAssemblerContext.getEndpoint().getServiceName());
        }
        AbstractTubeFactory abstractTubeFactory = new AbstractTubeFactory(){

            public Tube createServer(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
                WSBinding wSBinding = serverTubeAssemblerContext.getEndpoint().getBinding();
                WebServiceFeatureList webServiceFeatureList = (WebServiceFeatureList)wSBinding.getFeatures();
                if (!webServiceFeatureList.isEnabled(AddressingFeature.class)) {
                    webServiceFeatureList.add((WebServiceFeature)new AddressingFeature(true));
                }
                return new McReceiverTube(tube, serverTubeAssemblerContext);
            }
        };
        TubelineAssemblerItem tubelineAssemblerItem = new TubelineAssemblerItem(MC_RECEIVER_TUBE, abstractTubeFactory);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("ADDRESSING_HANDLER");
        hashSet.add("WS_SECURITY_1.1");
        tubelineAssemblerItem.setGoBefore(hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("WsrmServer");
        tubelineAssemblerItem.setGoAfter(hashSet2);
        set.add(tubelineAssemblerItem);
    }
}

